/*
	heap.c -- heapsort

	Donald E. Knuth, "The Art of Computer Programming," 5.2.3,
	Algorithm H.
*/

#include "demosort.h"

void
heap(char *a, int n, int speed_factor)
{
	char c;
	register int i, j;
	register int r;
	register int L;

	r = n;
	L = n / 2 + 1;
	while(1)
	{
		if (slowdown(speed_factor) == 1)
			return;	/* user hit ctl-break */
		if (L > 1)
		{
			--L;
			c = a[2 * (L - 1)];
		}
		else
		{
			c = a[2 * (r - 1)];
			a[2 * (r - 1)] = a[0];
			--r;
			if(r == 1)
			{
				a[0] = c;
				return;
			}
		}
		j = L;
		while(1)
		{
			i = j;
			j = j * 2;
			if (j < r)
			{
				if (a[2 * (j - 1)] < a[2 * j])
					++j;
				if (c >= a[2 * (j - 1)])
				{
					a[2 * (i - 1)] = c;
					break;
				}
				a[2* (i - 1)] = a[2 * (j - 1)];
			}
			else if (j == r)
			{
				if (c >= a[2 * (j - 1)])
				{
					a[2 * (i - 1)] = c;
					break;
				}
				a[2 * (i - 1)] = a[2 * (j - 1)];
			}
			else
			{
				a[2 * (i - 1)] = c;
				break;
			}
		}
	}
}
