/*
	edit_me.c -- Les Hancock, 9/25/89
*/

#include "defs.h"

/***************************************************
	PROTOTYPES OF PUBLIC SORT ROUTINES
****************************************************/
extern void bubble(char *p, int n, int slowdown_factor);
extern void dim(char *p, int n, int slowdown_factor);
extern void heap(char *p, int n, int slowdown_factor);
extern void med3(char *p, int n, int slowdown_factor);
extern void quick(char *p, int n, int slowdown_factor);
extern void quicker(char *p, int n, int slowdown_factor);
extern void radix(unsigned char *p, int n, int slowdown_factor);
extern void shell(char *p, int n, int slowdown_factor);
extern void shuttle(char *p, int n, int slowdown_factor);
extern void sift(char *p, int n, int slowdown_factor);
extern void sing(char p, int n, int slowdown_factor);
extern void straight(char *p, int n, int slowdown_factor);
extern void tree(char *p, int n, int slowdown_factor);
/* +++ */ extern void your_sort(char *p, int n, int slowdown_factor);

/***************************************************
         PUBLIC VARIABLES
****************************************************/
/*
   Menu choices for the routines listed below in sort[].
*/
char *sort_menu_strings[] = 
{
      "radix exchange",
      "quicksort",
      "quicker quicksort",
      "median-of-3 quicksort",
      "Singleton's algorithm",
      "heapsort",
      "treesort-3",
      "Shell's sort #1",
      "Shell's sort #2",
      "simple sifting",
      "straight insertion",
      "shuttle sort",
      "bubble sort",
/* +++ */ "your sort"                                /* your menu text here */
};

/*
   Synopses of various sort algorithms, in same order as the
   sorts listed in sort_menu_strings[].  You have one line for
   the synopsis.
*/
char *sort_menu_synopses[] = {
"Sort on bits in keys.  See Robert Sedgewick, ALGORITHMS, p117.",
"C.A.R. Hoare, 1961.  See Harold Lorin, SORTING AND SORT SYSTEMS, p A-11.",
"R.S. Scowen, 1965.  See Harold Lorin, SORTING AND SORT SYSTEMS, p A-38.",
"Variant of QUICKSORT.  See Robert Sedgewick, QUICKSORT, p. 206, program 8.1.",
"R.C. Singleton, 1968.  See Harold Lorin, SORTING AND SORT SYSTEMS, p A-42.",
"J.W.J. Williams, 1964.  See Knuth, ART OF COMPUTER PROGRAMMING, III, p. 145.",
"Robert W. Floyd, 1964.  See Harold Lorin, SORTING AND SORT SYSTEMS, p. A-28.",
"Donald L. Shell, 1959.  See Knuth, ART OF COMPUTER PROGRAMMING, III, p. 84.",
"T.N. Hibberd's variant, 1963.  Harold Lorin, SORTING AND SORT SYSTEMS, A-22.",
"SIMPLE SIFTING algorithm, provenance uncertain.",
"STRAIGHT INSERTION SORT.  Knuth, ART OF COMPUTER PROGRAMMING, III, p. 80.",
"C.J. Shaw & T.N. Trimble, 1963.  H. Lorin, SORTING AND SORT SYSTEMS, p. A-20.",
"BUBBLE SORT.  The algorithm we all rewrite at least twice a year.",
/* +++ */ "I know your sort."                         /* your synopsis here */
};

/*
	Colors for the menu choices.
*/
unsigned char sort_menu_colors[] = {
         COLOR(LIGHT_BLUE,WHITE),
         COLOR(LIGHT_BLUE,WHITE),
         COLOR(LIGHT_BLUE,WHITE),
         COLOR(LIGHT_BLUE,WHITE),
         COLOR(LIGHT_BLUE,WHITE),
         COLOR(LIGHT_BLUE,WHITE),
         COLOR(LIGHT_BLUE,WHITE),
         COLOR(LIGHT_BLUE,WHITE),
         COLOR(LIGHT_BLUE,WHITE),
         COLOR(LIGHT_BLUE,WHITE),
         COLOR(LIGHT_BLUE,WHITE),
         COLOR(LIGHT_BLUE,WHITE),
         COLOR(LIGHT_BLUE,WHITE),
         COLOR(LIGHT_BLUE,WHITE)
			};

/*
	List of available sorting algorithms -- matches lists above.
   Algorithms are given in very approximate order from fastest
   to slowest (sorting our small random sample).
*/
PTR_TO_FN_RET_VOID sortlist[] =
{
      radix,
      quick,
      quicker,
      med3,
      sing,
      heap,
      tree,
      dim,
      shell,
      sift,
      straight,
      shuttle,
      bubble,
/* +++ */ your_sort                               /* your function's address */
};

/*
	This kludge is necessary to convey the dimensionality of
	the arrays defined above to a foreign module.
*/
unsigned char number_of_sort_items =
	sizeof(sortlist) / sizeof(PTR_TO_FN_RET_VOID);
