/* defs.h -- Les Hancock, 9/26/89 */

#ifndef DEFS_H
#define DEFS_H

/***************************************************
         TYPEDEFS
****************************************************/

typedef void (*PTR_TO_FN_RET_VOID)();

typedef int BOOLEAN;

/*
VECTOR types an interrupt vector (timer, ctl-break, etc).  Important:
enumerated values are the vectors' offset addresses, not their ID numbers.
*/
typedef enum { timer = 0x70, ctl_break = 0x6c } VECTOR;

typedef enum { unknown, mda, cga, ega, vga } DISPLAY_TYPE;

typedef enum { kill, revive } CURSOR_COMMAND;

typedef enum { none = 0, alnum = 1, alpha = 2, lower = 3, digit = 4,
     print = 5, graph = 6, punct = 7, upper = 8 } FILTER;

typedef struct
{
	char *choice;	/* menu string */
	char *synopsis;	/* string giving one-line synopsis of algorithm */
	PTR_TO_FN_RET_VOID sort;	/* ptr to sort function */
} SORT;

typedef struct
{
   DISPLAY_TYPE type;                                 /* mda, cga, ega, vga */
   int mode; /* video mode (0 through 16, as returned by BIOS Int 10, Svc 0)*/
   char *base_addr;                    /* long base address of video page 1 */
} DISPLAY;

/*
Here's the template for a menu.  <start_row>, etc, define its position on the
screen (numbering from u.l.h. corner).  IMPORTANT: menus are indexed from 0,0
and not from 1,1.  The ROM BIOS routines expect indexing from 1,1, so
conversion is applied in display_menu_line().

Why index from 0?  So we can figure out how to fold columns that run over the
number of rows in a page.  (Twenty-three, that is, since two rows at the
bottom are reserved.)

NB: colors can be specified individually for each menu choice.  Each color is
an integer put together from (background_color < 4 & foreground_color).
*/
typedef struct
{
   unsigned char start_row, start_col, width, length;
   char **choices;
   char **synopses;
   unsigned char *colors;
   signed char current_choice;
}
MENU, *MENUPTR;

/***************************************************
         DEFINES
****************************************************/

#define BLACK 0
#define BLUE 1
#define DARK_GRAY 8
#define LIGHT_BLUE 9
#define LIGHT_CYAN 11
#define LIGHT_MAGENTA 13
#define BRIGHT_WHITE 15
#define BROWN 6
#define CYAN 3
#define GREEN 2
#define LIGHT_GREEN 10
#define LIGHT_RED 12
#define MAGENTA 5
#define RED 4
#define WHITE 7
#define YELLOW 14
#define BLINK(color) ((color) + 16)

#define COMMIT 0
#define DOWN_ARROW -2
#define FILE_INPUT 1
#define KEYBOARD_INPUT 2
#define LEFT_ARROW -3
#define RANDOM 0
#define RIGHT_ARROW -4
#define UP_ARROW -1

#define MAIN 0
#define INPUT 1
#define SORT 2
#define SLOWDOWN 3
#define FILTERS 4
#define COLORS 5
#define FORE 6
#define BACK 7

#define STATIC static                /* for debugging define STATIC as null */
#define BEL 7                                     /* beep or bell character */

/*
	Colors are stored in 8 bits; leftmost nybble = background, rightmost =
	foreground (ie text).  These macros provide the following services:

		COLOR -- combine color constants into one color byte
		BACKGROUND -- extract background color from color byte
		FOREGROUND -- ditto for foreground color
		COLORSWAP -- make background foreground and vice-versa
*/
#define COLOR(background, foreground) ((background * 16) + (foreground))
#define BACKGROUND(color) ((unsigned int)(color) / 16)
#define FOREGROUND(color) ((color) & 0xf)
#define COLORSWAP(color) ((((color) & 0xf) * 16) + ((unsigned)((color) / 16)))

#endif

