/*
   banner.c -- Les Hancock, 9/26/89
      
   Paint a suitable prologue for DemoSort.
*/
#include <ctype.h>
#include <graph.h>
#include <malloc.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "defs.h"

/*
   Yes, the following init was generated automatically.
*/
static int page[] = 
{
   0x1e20,0x1e20,0x1e41,0x1e42,0x1e43,0x1e44,0x1e45,0x1e46,0x1e20,0x1e20,0x1e20,
   0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,
   0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,
   0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e47,0x1e48,0x1e49,0x1e4a,0x1e4b,
   0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,
   0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,
   0x1e20,0x1e20,0x1e4c,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,
   0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e4c,0x1e4d,0x1e20,0x1e20,0x1e4e,
   0x1e4f,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,
   0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,
   0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e50,0x1e51,0x1e20,
   0x1e20,0x1e20,0x1e20,0x1e52,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,
   0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,
   0x1e20,0x1e20,0x1e20,0x1e20,0x1e53,0x1e54,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,
   0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e55,0x1e56,
   0x1e20,0x1e20,0x1e57,0x1e58,0x1e20,0x1e20,0x1e20,0x1e59,0x1e5a,0x1e41,0x1e42,
   0x1e43,0x1e20,0x1e20,0x1e20,0x1e44,0x1e45,0x1e46,0x1e20,0x1e47,0x1e48,0x1e20,
   0x1e20,0x1e20,0x1e20,0x1e20,0x1e49,0x1e4a,0x1e4b,0x1e4c,0x1e20,0x1e20,0x1e20,
   0x1e4d,0x1e4e,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,
   0x1e4f,0x1e50,0x1e51,0x1e52,0x1e20,0x1e20,0x1e20,0x1e53,0x1e54,0x1e20,0x1e20,
   0x1e55,0x1e56,0x1e57,0x1e20,0x1e20,0x1e20,0x1e58,0x1e59,0x1e5a,0x1e41,0x1e42,
   0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,
   0x1e20,0x1e43,0x1e44,0x1e20,0x1e20,0x1e45,0x1e46,0x1e20,0x1e20,0x1e47,0x1e48,
   0x1e20,0x1e20,0x1e20,0x1e20,0x1e49,0x1e20,0x1e20,0x1e4a,0x1e4b,0x1e20,0x1e4c,
   0x1e20,0x1e4d,0x1e4e,0x1e20,0x1e20,0x1e20,0x1e4f,0x1e50,0x1e20,0x1e20,0x1e51,
   0x1e52,0x1e20,0x1e20,0x1e20,0x1e53,0x1e54,0x1e55,0x1e56,0x1e57,0x1e20,0x1e20,
   0x1e20,0x1e20,0x1e58,0x1e59,0x1e20,0x1e20,0x1e5a,0x1e41,0x1e20,0x1e20,0x1e20,
   0x1e42,0x1e43,0x1e44,0x1e20,0x1e45,0x1e46,0x1e20,0x1e20,0x1e20,0x1e20,0x1e47,
   0x1e48,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e42,
   0x1e20,0x1e20,0x1e20,0x1e20,0x1e49,0x1e4a,0x1e20,0x1e20,0x1e4b,0x1e4c,0x1e20,
   0x1e20,0x1e4d,0x1e4e,0x1e4f,0x1e50,0x1e51,0x1e52,0x1e53,0x1e20,0x1e20,0x1e54,
   0x1e55,0x1e20,0x1e56,0x1e20,0x1e57,0x1e58,0x1e20,0x1e20,0x1e20,0x1e59,0x1e5a,
   0x1e20,0x1e20,0x1e41,0x1e42,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,
   0x1e43,0x1e44,0x1e20,0x1e20,0x1e20,0x1e45,0x1e46,0x1e20,0x1e20,0x1e47,0x1e48,
   0x1e20,0x1e20,0x1e20,0x1e49,0x1e4a,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,
   0x1e20,0x1e20,0x1e4b,0x1e4c,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,
   0x1e20,0x1e20,0x1e79,0x1e20,0x1e20,0x1e20,0x1e20,0x1e4d,0x1e4e,0x1e20,0x1e20,
   0x1e4f,0x1e50,0x1e20,0x1e20,0x1e51,0x1e52,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,
   0x1e20,0x1e20,0x1e53,0x1e54,0x1e20,0x1e20,0x1e20,0x1e55,0x1e56,0x1e20,0x1e20,
   0x1e20,0x1e57,0x1e58,0x1e20,0x1e20,0x1e59,0x1e5a,0x1e20,0x1e20,0x1e41,0x1e20,
   0x1e20,0x1e20,0x1e20,0x1e42,0x1e43,0x1e20,0x1e20,0x1e20,0x1e44,0x1e45,0x1e20,
   0x1e20,0x1e46,0x1e47,0x1e20,0x1e20,0x1e20,0x1e48,0x1e49,0x1e20,0x1e20,0x1e20,
   0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e4a,0x1e4b,0x1e20,0x1e4c,0x1e4d,0x1e20,
   0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e4d,0x1e4e,
   0x1e4f,0x1e50,0x1e51,0x1e52,0x1e20,0x1e20,0x1e20,0x1e20,0x1e53,0x1e54,0x1e55,
   0x1e56,0x1e57,0x1e20,0x1e20,0x1e20,0x1e53,0x1e59,0x1e5a,0x1e20,0x1e20,0x1e41,
   0x1e42,0x1e43,0x1e20,0x1e20,0x1e20,0x1e44,0x1e45,0x1e46,0x1e47,0x1e20,0x1e20,
   0x1e20,0x1e20,0x1e48,0x1e49,0x1e4a,0x1e4b,0x1e4c,0x1e20,0x1e20,0x1e20,0x1e20,
   0x1e20,0x1e4d,0x1e4e,0x1e4f,0x1e50,0x1e20,0x1e20,0x1e20,0x1e51,0x1e52,0x1e53,
   0x1e54,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e55,0x1e56,
   0x1e57,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e4c,0x1e20,0x1e20,
   0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,
   0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,
   0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,
   0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,
   0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,
   0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,
   0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,
   0x1e65,0x1e20,0x1e20,0x1e20,0x1e41,0x1e42,0x1e43,0x1e44,0x1e45,0x1e46,0x1e20,
   0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,
   0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,
   0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e47,0x1e48,0x1e49,
   0x1e4a,0x1e4b,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,
   0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,
   0x1e20,0x1e20,0x1e20,0x1e20,0x1e4c,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,
   0x1e20,0x1e20,0x1e20,0x1e73,0x1e20,0x1e20,0x1e20,0x1e20,0x1e4c,0x1e4d,0x1e20,
   0x1e20,0x1e4e,0x1e4f,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,
   0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,
   0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e50,
   0x1e51,0x1e20,0x1e20,0x1e20,0x1e20,0x1e52,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,
   0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,
   0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e53,0x1e54,0x1e20,0x1e20,0x1e20,
   0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,
   0x1e55,0x1e56,0x1e20,0x1e20,0x1e57,0x1e58,0x1e20,0x1e20,0x1e20,0x1e59,0x1e5a,
   0x1e41,0x1e42,0x1e43,0x1e20,0x1e20,0x1e20,0x1e44,0x1e45,0x1e46,0x1e20,0x1e47,
   0x1e48,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e49,0x1e4a,0x1e4b,0x1e4c,0x1e20,
   0x1e20,0x1e20,0x1e4d,0x1e4e,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,
   0x1e20,0x1e20,0x1e4f,0x1e50,0x1e51,0x1e52,0x1e20,0x1e20,0x1e20,0x1e53,0x1e54,
   0x1e20,0x1e20,0x1e55,0x1e56,0x1e57,0x1e20,0x1e20,0x1e20,0x1e58,0x1e59,0x1e5a,
   0x1e41,0x1e42,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e48,0x1e20,
   0x1e20,0x1e20,0x1e20,0x1e43,0x1e44,0x1e20,0x1e20,0x1e45,0x1e46,0x1e20,0x1e20,
   0x1e47,0x1e48,0x1e20,0x1e20,0x1e20,0x1e20,0x1e49,0x1e20,0x1e20,0x1e4a,0x1e4b,
   0x1e20,0x1e4c,0x1e20,0x1e4d,0x1e4e,0x1e20,0x1e20,0x1e20,0x1e4f,0x1e50,0x1e20,
   0x1e20,0x1e51,0x1e52,0x1e20,0x1e20,0x1e20,0x1e53,0x1e54,0x1e55,0x1e56,0x1e57,
   0x1e20,0x1e20,0x1e20,0x1e20,0x1e58,0x1e59,0x1e20,0x1e20,0x1e5a,0x1e41,0x1e20,
   0x1e20,0x1e20,0x1e42,0x1e43,0x1e44,0x1e20,0x1e45,0x1e46,0x1e20,0x1e20,0x1e20,
   0x1e20,0x1e47,0x1e48,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,
   0x1e20,0x1e61,0x1e20,0x1e20,0x1e20,0x1e20,0x1e49,0x1e4a,0x1e20,0x1e20,0x1e4b,
   0x1e4c,0x1e20,0x1e20,0x1e4d,0x1e4e,0x1e4f,0x1e50,0x1e51,0x1e52,0x1e53,0x1e20,
   0x1e20,0x1e54,0x1e55,0x1e20,0x1e56,0x1e20,0x1e57,0x1e58,0x1e20,0x1e20,0x1e20,
   0x1e59,0x1e5a,0x1e20,0x1e20,0x1e41,0x1e42,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,
   0x1e20,0x1e20,0x1e43,0x1e44,0x1e20,0x1e20,0x1e20,0x1e45,0x1e46,0x1e20,0x1e20,
   0x1e47,0x1e48,0x1e20,0x1e20,0x1e20,0x1e49,0x1e4a,0x1e20,0x1e20,0x1e20,0x1e20,
   0x1e20,0x1e20,0x1e20,0x1e20,0x1e4b,0x1e4c,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,
   0x1e20,0x1e20,0x1e20,0x1e20,0x1e6e,0x1e20,0x1e20,0x1e20,0x1e20,0x1e4d,0x1e4e,
   0x1e20,0x1e20,0x1e4f,0x1e50,0x1e20,0x1e20,0x1e51,0x1e52,0x1e20,0x1e20,0x1e20,
   0x1e20,0x1e20,0x1e20,0x1e20,0x1e53,0x1e54,0x1e20,0x1e20,0x1e20,0x1e55,0x1e56,
   0x1e20,0x1e20,0x1e20,0x1e57,0x1e58,0x1e20,0x1e20,0x1e59,0x1e5a,0x1e20,0x1e20,
   0x1e41,0x1e20,0x1e20,0x1e20,0x1e20,0x1e42,0x1e43,0x1e20,0x1e20,0x1e20,0x1e44,
   0x1e45,0x1e20,0x1e20,0x1e46,0x1e47,0x1e20,0x1e20,0x1e20,0x1e48,0x1e49,0x1e20,
   0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e4a,0x1e4b,0x1e20,0x1e4c,
   0x1e4d,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e63,0x1e20,0x1e20,0x1e20,
   0x1e4d,0x1e4e,0x1e4f,0x1e50,0x1e51,0x1e52,0x1e20,0x1e20,0x1e20,0x1e20,0x1e53,
   0x1e54,0x1e55,0x1e56,0x1e57,0x1e20,0x1e20,0x1e20,0x1e53,0x1e59,0x1e5a,0x1e20,
   0x1e20,0x1e41,0x1e42,0x1e43,0x1e20,0x1e20,0x1e20,0x1e44,0x1e45,0x1e46,0x1e47,
   0x1e20,0x1e20,0x1e20,0x1e20,0x1e48,0x1e49,0x1e4a,0x1e4b,0x1e4c,0x1e20,0x1e20,
   0x1e20,0x1e20,0x1e20,0x1e4d,0x1e4e,0x1e4f,0x1e50,0x1e20,0x1e20,0x1e20,0x1e51,
   0x1e52,0x1e53,0x1e54,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,
   0x1e55,0x1e56,0x1e57,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e6f,
   0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,
   0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,
   0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,
   0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,
   0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,
   0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,
   0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,
   0x1e20,0x1e20,0x1e63,0x1e20,0x1e20,0x1e20,0x1e41,0x1e42,0x1e43,0x1e44,0x1e45,
   0x1e46,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,
   0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,
   0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e47,
   0x1e48,0x1e49,0x1e4a,0x1e4b,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,
   0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,
   0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e4c,0x1e20,0x1e20,0x1e20,0x1e20,
   0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e6b,0x1e20,0x1e20,0x1e20,0x1e20,0x1e4c,
   0x1e4d,0x1e20,0x1e20,0x1e4e,0x1e4f,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,
   0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,
   0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,
   0x1e20,0x1e50,0x1e51,0x1e20,0x1e20,0x1e20,0x1e20,0x1e52,0x1e20,0x1e20,0x1e20,
   0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,
   0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e53,0x1e54,0x1e20,
   0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,
   0x1e20,0x1e20,0x1e55,0x1e56,0x1e20,0x1e20,0x1e57,0x1e58,0x1e20,0x1e20,0x1e20,
   0x1e59,0x1e5a,0x1e41,0x1e42,0x1e43,0x1e20,0x1e20,0x1e20,0x1e44,0x1e45,0x1e46,
   0x1e20,0x1e47,0x1e48,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e49,0x1e4a,0x1e4b,
   0x1e4c,0x1e20,0x1e20,0x1e20,0x1e4d,0x1e4e,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,
   0x1e20,0x1e20,0x1e20,0x1e20,0x1e4f,0x1e50,0x1e51,0x1e52,0x1e20,0x1e20,0x1e20,
   0x1e53,0x1e54,0x1e20,0x1e20,0x1e55,0x1e56,0x1e57,0x1e20,0x1e20,0x1e20,0x1e58,
   0x1e59,0x1e5a,0x1e41,0x1e42,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,
   0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e43,0x1e44,0x1e20,0x1e20,0x1e45,0x1e46,
   0x1e20,0x1e20,0x1e47,0x1e48,0x1e20,0x1e20,0x1e20,0x1e20,0x1e49,0x1e20,0x1e20,
   0x1e4a,0x1e4b,0x1e20,0x1e4c,0x1e20,0x1e4d,0x1e4e,0x1e20,0x1e20,0x1e20,0x1e4f,
   0x1e50,0x1e20,0x1e20,0x1e51,0x1e52,0x1e20,0x1e20,0x1e20,0x1e53,0x1e54,0x1e55,
   0x1e56,0x1e57,0x1e20,0x1e20,0x1e20,0x1e20,0x1e58,0x1e59,0x1e20,0x1e20,0x1e5a,
   0x1e41,0x1e20,0x1e20,0x1e20,0x1e42,0x1e43,0x1e44,0x1e20,0x1e45,0x1e46,0x1e20,
   0x1e20,0x1e20,0x1e20,0x1e47,0x1e48,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,
   0x1e20,0x1e20,0x1e20,0x1e31,0x1e20,0x1e20,0x1e20,0x1e20,0x1e49,0x1e4a,0x1e20,
   0x1e20,0x1e4b,0x1e4c,0x1e20,0x1e20,0x1e4d,0x1e4e,0x1e4f,0x1e50,0x1e51,0x1e52,
   0x1e53,0x1e20,0x1e20,0x1e54,0x1e55,0x1e20,0x1e56,0x1e20,0x1e57,0x1e58,0x1e20,
   0x1e20,0x1e20,0x1e59,0x1e5a,0x1e20,0x1e20,0x1e41,0x1e42,0x1e20,0x1e20,0x1e20,
   0x1e20,0x1e20,0x1e20,0x1e20,0x1e43,0x1e44,0x1e20,0x1e20,0x1e20,0x1e45,0x1e46,
   0x1e20,0x1e20,0x1e47,0x1e48,0x1e20,0x1e20,0x1e20,0x1e49,0x1e4a,0x1e20,0x1e20,
   0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e4b,0x1e4c,0x1e20,0x1e20,0x1e20,
   0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e39,0x1e20,0x1e20,0x1e20,0x1e20,
   0x1e4d,0x1e4e,0x1e20,0x1e20,0x1e4f,0x1e50,0x1e20,0x1e20,0x1e51,0x1e52,0x1e20,
   0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e53,0x1e54,0x1e20,0x1e20,0x1e20,
   0x1e55,0x1e56,0x1e20,0x1e20,0x1e20,0x1e57,0x1e58,0x1e20,0x1e20,0x1e59,0x1e5a,
   0x1e20,0x1e20,0x1e41,0x1e20,0x1e20,0x1e20,0x1e20,0x1e42,0x1e43,0x1e20,0x1e20,
   0x1e20,0x1e44,0x1e45,0x1e20,0x1e20,0x1e46,0x1e47,0x1e20,0x1e20,0x1e20,0x1e48,
   0x1e49,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e4a,0x1e4b,
   0x1e20,0x1e4c,0x1e4d,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e38,0x1e20,
   0x1e20,0x1e20,0x1e4d,0x1e4e,0x1e4f,0x1e50,0x1e51,0x1e52,0x1e20,0x1e20,0x1e20,
   0x1e20,0x1e53,0x1e54,0x1e55,0x1e56,0x1e57,0x1e20,0x1e20,0x1e20,0x1e53,0x1e59,
   0x1e5a,0x1e20,0x1e20,0x1e41,0x1e42,0x1e43,0x1e20,0x1e20,0x1e20,0x1e44,0x1e45,
   0x1e46,0x1e47,0x1e20,0x1e20,0x1e20,0x1e20,0x1e48,0x1e49,0x1e4a,0x1e4b,0x1e4c,
   0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e4d,0x1e4e,0x1e4f,0x1e50,0x1e20,0x1e20,
   0x1e20,0x1e51,0x1e52,0x1e53,0x1e54,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,
   0x1e20,0x1e20,0x1e55,0x1e56,0x1e57,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,0x1e20,
   0x1e20,0x1e39,0x1e20
}
;

/***************************************************
         TYPEDEF
****************************************************/
typedef struct x
{
   struct x *next, *prev;
   int i, j;
}
SWAP;

/***************************************************
      PROTOCOLS FOR PRIVATE FUNCTIONS
****************************************************/
STATIC void _exchange(int *p, SWAP *ptr);
STATIC void _shell(int *p, int n);
STATIC void desort(int *string, unsigned long int calibrate);
STATIC long unsigned int pause(int n);

/***************************************************
      PROTOCOL FOR EXPORT
****************************************************/
void banner(void);

/***************************************************
      GLOBAL VARIABLES
****************************************************/
STATIC SWAP *swap_root;
STATIC SWAP *swap_leaf;

/***************************************************
      PUBLIC FUNCTION DEFINITION
****************************************************/
void
banner()
{
   int far *ptr = (int *) 0xb8000000;
   int i, *ptr1;
   unsigned long int calibrate;                      /* see note to pause() */

   ptr1 = (int *)malloc(sizeof(page));
   if (ptr1 == NULL)
      exit(1);
   for (i = 0; i < (sizeof(page) / sizeof(int)); ++i)
      ptr1[i] =  page[i];
   swap_leaf = swap_root = (SWAP *)malloc(sizeof(SWAP));
   swap_root->prev = swap_root->next = NULL;
   _shell(ptr1, (sizeof(page) / sizeof(int)));
   memcpy(ptr, ptr1, sizeof(page));
   calibrate = pause(30);
   desort(ptr, calibrate);
   pause(50);
}

/***************************************************
         PRIVATE FUNCTION DEFINITIONS
****************************************************/
/*
Undo the sort.  When it was performed, the swaps were recorded
in order in a linked list.  Now run back up the list of swaps
and do them in reverse order.  This desorts the array.

Second arg calibrates the loop used to waste time between
exchanges.  It serves to calibrate for processor speed.
As CPU gets faster, <calibrate> gets larger and the ratio
(calibrate / 84000), which is unity on my machine at 6MHz,
gets larger.  If CPU is slower, ratio is smaller.
*/
STATIC void
desort(int *string, unsigned long int calibrate)
{
   SWAP *ptr;

   for(ptr = swap_leaf; ptr->prev != NULL; ptr = ptr->prev)
   {
      unsigned long int x = (100L * calibrate) / 84000;
      while(--x != 0L);                 /* otherwise things happen too fast */
      _exchange(string, ptr);
   }
   for (ptr = swap_leaf; ptr->prev != NULL;)
   {
      SWAP *temp_ptr = ptr->prev;
      free(ptr);
      ptr = temp_ptr;
   }
}

/*
Local version of the
integer exchange function.
*/
STATIC void
_exchange(int *p, SWAP *ptr)
{
   int temp;

   temp = p[ptr->i];
   p[ptr->i] = p[ptr->j];
   p[ptr->j] = temp;
}

/*
Pause for n clock ticks.  Returns the number of iterations through
a simple loop accomplished during the wait for ticks.  This value
can be used to calibrate roughly the processor speed -- see how it
serves that purpose in desort().
*/
STATIC long unsigned int
pause(int n)
{
   extern volatile long clock_ticks; /* bumped by system tick, 18.2 per sec */
   long unsigned int i = 0L, j = clock_ticks;

   while((clock_ticks - j) < n)
      ++i;
   return i;
}

/*
   Local version of Shell's sort, q.v.
*/
STATIC void
_shell(int *p, int n)
{
   int limit, distance;
   register int i, j;

   distance = n / 2;
   while (distance)
   {
      limit = n - distance;
      for (j = 0; j < limit; ++j)
         for (i = j; i >= 0; i -= distance)
         {
            if (p[i + distance] >= p[i])
               break;
            {
               SWAP *ptr, *ptrx;

               ptr = malloc(sizeof(SWAP));          /* create new structure */
               if (ptr == NULL)
                  exit(2);
               ptr->i = i;                         /* assign i and j values */
               ptr->j = i + distance;
               ptr->next = NULL;    /* last item in list gets NULL next ptr */
               ptrx = swap_leaf;
               ptr->prev = ptrx;        /* add new structure to end of list */
               swap_leaf = ptrx->next = ptr;
               _exchange(p, ptr);
            }
         }
      distance /= 2;
   }
}
