/* quick.c  -- classical quicksort (AKA "partition exchange sort") */

#include "demosort.h"
#define STATIC static

STATIC void q(int *p, int l, int r, int speed_factor);

void
quick(int *p, int n, int slowdown_factor)
{
 	q(p, 0, n - 1, slowdown_factor);
}

STATIC void
q(int *p, int l, int r, int speed_factor)
{
	register int i, j, v;

	if (r > l)
	{
		i = l;
		j = r + 1;
		v = p[l];

		while(1)
		{
			while(p[++i] < v)
				;
			while(p[--j] > v)
				;
			if (i >= j)
				break;
			if (slowdown(speed_factor) == 1)
				return;	/* user hit ctl-break */
			int_exchange(p, i, j);
		}
		if (slowdown(speed_factor) == 1)
			return;	/* user hit ctl-break */
		int_exchange(p, l, j);
		q(p, l, j - 1, speed_factor);
		q(p, j + 1, r, speed_factor);
	}
}
