	TITLE   handler.c
	NAME    handler

HANDLER_TEXT	SEGMENT  WORD PUBLIC 'CODE'
HANDLER_TEXT	ENDS
_DATA	SEGMENT  WORD PUBLIC 'DATA'
_DATA	ENDS
CONST	SEGMENT  WORD PUBLIC 'CONST'
CONST	ENDS
_BSS	SEGMENT  WORD PUBLIC 'BSS'
_BSS	ENDS
DGROUP	GROUP	CONST, _BSS, _DATA
	ASSUME  CS: HANDLER_TEXT, DS: DGROUP, SS: DGROUP
EXTRN	_flag:BYTE
EXTRN	_clock_ticks:DWORD
HANDLER_TEXT      SEGMENT
	ASSUME	CS: HANDLER_TEXT
_ds	DW	00H
HANDLER_TEXT      ENDS
CONST      SEGMENT
TICKS	DW SEG _clock_ticks 
FLAG	DW SEG _flag 
CONST      ENDS
HANDLER_TEXT      SEGMENT
	PUBLIC	_ctl_brk_handler
	PUBLIC	_save_ds
	PUBLIC	_timer_handler

;  Interrupts lose the DS, which we need for our interrupt handling.  So
;  we save DS in the code segment (which IS preserved) by calling save_ds()
;  early in the program.  To restore the DS when we need it, we call -- guess
;  what.

_save_ds	PROC FAR
	mov	ax,DGROUP
	mov	WORD PTR cs:_ds,ax
	retf
_save_ds	ENDP

; Restore saved DS and return its value in AX

; Interrupt handler for CTL-BREAK (address 0x1b).  This handler is
; reserved for BIOS interrupts associated with a CTL-BREAK key combination.
; Its only job is to set a flag which will be polled by the sort routines
; you want to interrupt.

_ctl_brk_handler	PROC FAR
	push	ax
	push	ds
	push	es
	sti				; reenable interrupts
	mov	ax,WORD PTR cs:_ds      ; restore DS
        mov     ds,ax
	mov	es,FLAG
	mov	BYTE PTR es:_flag,1
	pop	es
	pop	ds
	pop	ax
	iret	
_ctl_brk_handler	ENDP

_timer_handler	PROC FAR
	push	ax
	push	ds
	push	es
	sti
	mov	ax,WORD PTR cs:_ds      ; restore DS
        mov     ds,ax
	mov	es,TICKS
	add	WORD PTR es:_clock_ticks,1
	adc	WORD PTR es:_clock_ticks+2,0
	pop	es
	pop	ds
	pop	ax
	iret
_timer_handler	ENDP
HANDLER_TEXT	ENDS
END
