/*
	dim.c -- diminishing increment variant of Shell's sort

	Donald E. Knuth, "The Art of Computer Programming," 5.2.1,
	Algorithm D.  See also CACM 2 (July 1959), 30-32.

*/

#include "demosort.h"

void
dim(char *p, int n, int speed_factor)
{
	register int i, j;
	register int h;
	char c;

	for (h = 8; h >= 1; h /= 2)
		for (j = h + 1; h < j && j < n; ++j)
		{
			i = j - h;
			c = p[2 * j];
			while(c < p[2 * i])
			{
				if (slowdown(speed_factor) == 1)
					return;	/* user hit ctl-break */
				p[2 * (i + h)] = p[2 * i];
				i = i - h;
				if (i < 0)
					break;
			}
			p[2 * (i + h)] = c;
		}
}
