// Header file for DECK.CPP - A card handling class

#ifndef DECKHPP
#define DECKHPP

struct CARD {
	int value;
	int suit;
	int graphic;
	int face;
	char name[18];
};

#define DEALT		1
#define NOT_DEALT	0
#define DECKCOUNT 52

class DECK {
	private:
		CARD *Deck;
		CARD *StartDeck;
		int NextCard;
		int AlreadyDealt;
		int NumOfDecks;
		int NumOfCards;
		int LastCard;
	protected:
		void SetLastCard(int flag) {LastCard=flag;}
		void SetCardsDealt(int dealt) {AlreadyDealt=dealt; }

	public:
		DECK(int num=1);
		~DECK();
		CARD TakeNextCard();
		int CardsDealt() {return(AlreadyDealt); }
		const char * GetCardName(int loc);
		int GetFaceValue(int loc);
		int GetSuit(int loc);
		int GetValue(int loc);
		int GetGraphic(int loc);
		int IsLastCard() {return LastCard; }
		void Shuffle();
		void CutDeck(int loc=26);
};

#endif //DECKHPP
