//  Deck class - A class for handling a deck of cards

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include "deck.hpp"

/////////////////////////////////////////////////////////////////////////////
// DECK() This constructor builds a deck of cards consisting of num decks
// The default is one deck.  There is a crude error message if there isn't
// enough memory to create the request number of decks.  Two sets of CARD
// structs are set up.  This is for the Shuffle() routine.
/////////////////////////////////////////////////////////////////////////////
DECK::DECK(int num)
{
	char *suits[]={"Diamonds","Hearts","Spades","Clubs"};
	char *cardname[]={"","","Deuce","Three","Four","Five","Six","Seven","Eight",
							"Nine","Ten","Jack","Queen","King","Ace"};
	NumOfDecks=num;
	NumOfCards=NumOfDecks*DECKCOUNT;
	Deck=new CARD[NumOfCards];
	StartDeck=new CARD[NumOfCards];
	if(!Deck || !StartDeck)
	{
		puts("Not enough memory for cards!");
		puts("Terminating program.");
		exit(1);
	}
	int ctr=0;
	for(int c=0;c<num;c++)
	{
		for(int i=0;i<4;i++)
		{
			for(int j=2;j<15;j++)
			{
				StartDeck[ctr].value=j;			// Card value
				StartDeck[ctr].suit=i;			// Card suit
				StartDeck[ctr].graphic=ctr;	// Graphic image pointer
				if(j<11)
					StartDeck[ctr].face=j;     // Face value of card
				else
					if(j<14)
						StartDeck[ctr].face=10;
					else
						StartDeck[ctr].face=11;
														// Name of card
				sprintf(StartDeck[ctr++].name,"%s of %s",cardname[j],suits[i]);
			}
		}
	}
	SetCardsDealt(NOT_DEALT);
}
/////////////////////////////////////////////////////////////////////////////
// ~DECK()  The destructor just deletes the memory used by the CARD structs
/////////////////////////////////////////////////////////////////////////////
DECK::~DECK()
{
	delete Deck;
	delete StartDeck;
}

/////////////////////////////////////////////////////////////////////////////
// TakeNextCard() pulls the next card off the deck.  If it is the last card,
// it updates private member int LastCard to TRUE.  This value can be tested
// by calling IsLastCard.  This is good for blackjack games.  It also calls
// Shuffle if needed.
/////////////////////////////////////////////////////////////////////////////
CARD DECK::TakeNextCard()
{
	NextCard++;
	if(NextCard>NumOfCards)
		Shuffle();
	if(NextCard==NumOfCards)
		SetLastCard(1);
	return(Deck[NextCard]);
}

/////////////////////////////////////////////////////////////////////////////
// GetCardName returns a const char(so it can't be modified) of the name of
// the card in the Deck at position loc.
/////////////////////////////////////////////////////////////////////////////
const char * DECK::GetCardName(int loc)
{
	if(loc<0 || loc>51)
		return("");
	else
		return(Deck[loc].name);
}

/////////////////////////////////////////////////////////////////////////////
// GetFaceValue returns the face value of the card at position loc.
/////////////////////////////////////////////////////////////////////////////
int DECK::GetFaceValue(int loc)
{
	if(loc<0 || loc>51)
		return(-1);  //loc out of range
	else
		return(Deck[loc].face);
}

/////////////////////////////////////////////////////////////////////////////
// GetValue returns the value of the card at position loc.
/////////////////////////////////////////////////////////////////////////////
int DECK::GetValue(int loc)
{
	if(loc<0 || loc>51)
		return(-1);   // loc out of range
	else
		return(Deck[loc].value);
}

/////////////////////////////////////////////////////////////////////////////
// GetSuit returns the suit of the card at position loc.
/////////////////////////////////////////////////////////////////////////////
int DECK::GetSuit(int loc)
{
	if(loc<0 || loc>51)
		return(-1);   // loc out of range
	else
		return(Deck[loc].suit);
}

/////////////////////////////////////////////////////////////////////////////
// GetGraphic returns the graphic pointer of the card at position loc.
/////////////////////////////////////////////////////////////////////////////
int DECK::GetGraphic(int loc)
{
	if(loc<0 || loc>51)
		return(-1);    // loc out of range
	else
		return(Deck[loc].graphic);
}

/////////////////////////////////////////////////////////////////////////////
// Shuffle shuffles the Deck of cards by randomly selecting a card from one
// Deck(StartDeck) and placing it in the other.  This routine is based upon
// one I found by Al Stevens in DDJ(I forget which volume and number) that
// was used to shuffle a deck of cards for his blackjack game.
/////////////////////////////////////////////////////////////////////////////
void DECK::Shuffle()
{
	static int FirstTime=1;

	if(FirstTime)
	{
		NextCard=NumOfCards;
		FirstTime=0;
		randomize();
	}
	else
	{
		for(NextCard=0;NextCard<NumOfCards;NextCard++)
			StartDeck[NextCard]=Deck[NextCard];
	}
	while(NextCard)
	{
		int i=random(NextCard);
		NextCard--;
		Deck[NextCard]=StartDeck[i];
		while(i<NextCard)
		{
			StartDeck[i]=StartDeck[i+1];
			i++;
		}
	}
}

/////////////////////////////////////////////////////////////////////////////
// CutDeck allows you to cut the deck starting with position loc.
/////////////////////////////////////////////////////////////////////////////
void DECK::CutDeck(int loc)
{
	if(loc>0 || loc<NumOfCards)
	{
		int ctr=0;
		for(int i=loc;i<NumOfCards;i++)
			StartDeck[ctr++]=Deck[i];
		for(int j=0;j<loc;j++)
			StartDeck[ctr++]=Deck[j];
		for(int k=0;k<NumOfCards;k++)
			Deck[k]=StartDeck[k];
	}
}
