DECLARE SUB Button (text$, row, col, attr)
DECLARE SUB CursorChoice (shape)
DECLARE SUB Mouse (ax%, bx%, cx%, dx%)
DECLARE SUB MousePaws (Squeeks)
DECLARE SUB MouseQuit ()
DECLARE SUB MouseSpeed (speed)
DECLARE SUB MouseStart ()
DECLARE SUB MouseThere ()
DECLARE SUB qwk (text$, row, col, attr)
DECLARE SUB UnButton (text$, row, col, char, attr, battr)
'Example of how to set up  Boxed buttons to give them a 3-D look

' $INCLUDE: 'C:\QB\QB.BI'
' Above statement vital to operation of program; path setting up to you

LOCATE , , 0              'control hard cursor
qwk STRING$(2000, 178), 1, 1, 95   'background setting
MouseQuit                 'erase cursor from any lingering mouse operations
Mouse ax%, bx%, cx%, dx%  'call the mouse
MouseThere                'check to see if mouse present
MouseStart                'if present, start mouse operation
MouseSpeed 15             'mouse movement setting
CursorChoice 20            'select text cursor shape; 20 = ASCII 254


Button "BUTTON 1", 5, 22, 31    'button setups
Button "EXIT ", 5, 52, 31


DO
Mouse 3, bx%, cx%, dx%          'tap into Mouse 3 function
IF bx% > 0 THEN                 'button control
Column = cx% / 8 + 1            'column control
row = dx% / 8 + 1               'row control
END IF
IF row = 5 THEN                 'limit control to row 5
SELECT CASE Column
CASE 21 TO 30                   'limit control to columns 21 to 30
UnButton "BUTTON 1", 5, 22, 178, 31, 95
'                            |    |   |
'ASCII character of background    |   |
'            button color attribute   |
'            background color attribute
END   'code to call other subs would be placed here

CASE 51 TO 57                     'limit control to columns 51 to 57
UnButton "EXIT ", 5, 52, 178, 31, 95
'                         |    |   |
'ASCII character of background |   |
'                              |   |
'         button color attribute   |
'                                  |
'         background color attribute
END
END SELECT
END IF
LOOP UNTIL INKEY$ = CHR$(27)  'escape route



SUB Button (text$, row, col, attr)
qwk "" + STRING$(LEN(text$) + 2, "") + "", row - 1, col, attr
qwk "" + SPACE$(1) + text$ + SPACE$(1) + "", row, col, attr
qwk "" + STRING$(LEN(text$) + 2, "") + "", row + 1, col, attr
qwk STRING$(LEN(text$) + 2, 220), row + 1, col + 1, attr
END SUB

SUB CursorChoice (shape)
SELECT CASE shape
CASE 0: Mouse 10, 0, &H0, &H7700
CASE 1: MouseChar = 4
CASE 2: MouseChar = 8
CASE 3: MouseChar = 15
CASE 4: MouseChar = 23
CASE 5: MouseChar = 24
CASE 6: MouseChar = 25
CASE 7: MouseChar = 26
CASE 8: MouseChar = 27
CASE 9: MouseChar = 35
CASE 10: MouseChar = 36
CASE 11: MouseChar = 48
CASE 12: MouseChar = 63
CASE 13: MouseChar = 88
CASE 14: MouseChar = 178
CASE 15: MouseChar = 197
CASE 16: MouseChar = 220
CASE 17: MouseChar = 237
CASE 18: MouseChar = 239
CASE 19: MouseChar = 251
CASE 20: MouseChar = 254
END SELECT
dx% = &H7000 + MouseChar
Mouse 10, 0, &H0, dx%
END SUB

SUB Mouse (ax%, bx%, cx%, dx%)
DIM inregs AS RegType, outregs AS RegType
inregs.ax = ax%
inregs.bx = bx%
inregs.cx = cx%
inregs.dx = dx%
INTERRUPT &H33, inregs, outregs
ax% = outregs.ax
bx% = outregs.bx
cx% = outregs.cx
dx% = outregs.dx
END SUB

SUB MousePaws (Squeeks)
DEF SEG = 0
FOR I = 1 TO Squeeks
Now = PEEK(&H46C)
DO: LOOP WHILE PEEK(&H46C) = Now
NEXT
END SUB

SUB MouseQuit
Mouse 0, bx%, cx%, dx%
END SUB

SUB MouseSpeed (speed)
cx% = speed
dx% = speed * 2
Mouse 15, 0, cx%, dx%
END SUB

SUB MouseStart
Mouse 1, 0, 0, 0
END SUB

SUB MouseThere
ax% = 0
Mouse ax%, bx%, cx%, dx%
IF NOT ax% THEN
CLS
qwk " Mouse not installed -- Press any key to exit program ", 10, 15, 78
WHILE INKEY$ = "": WEND
SYSTEM
END IF
END SUB

SUB qwk (text$, row, col, attr)
DIM ireg AS RegTypeX, oreg AS RegTypeX
ireg.ax = &H1300
ireg.bx = attr
ireg.cx = LEN(text$)
ireg.dx = (row - 1) * 256 + (col - 1)
ireg.bp = SADD(text$)
ireg.es = VARSEG(text$)
INTERRUPTX &H10, ireg, oreg
END SUB

SUB UnButton (text$, row, col, char, attr, battr)
qwk SPACE$(1) + text$ + SPACE$(1), row, col + 1, 8
qwk "" + STRING$(LEN(text$) + 2, "") + "", row + 1, col, attr
qwk CHR$(char), row + 2, col + LEN(text$) + 4, battr
MousePaws 12
qwk STRING$(LEN(text$) + 2, 220), row + 1, col + 1, attr
qwk SPACE$(1) + text$ + SPACE$(1), row, col + 1, attr
MousePaws 12
END SUB

