
 '============================= MLIBSAM4.BAS ================================
 '             Copyright (C) 1994 Terry Venn. All rights reserved.
 '
 '                  THIS SAMPLE PROGRAM IS PROVIDED AS IS.
 '
 ' You may modify/use this code in any way you wish, provided that you agree
 ' that Terry Venn has no warranties, obligations or liabilities for any code
 ' contained in this sample program.
 '
 ' This sample program shows how to display a menu (in text mode) offering
 ' multiple items to choose from. MLIB's non-event-driven (standard) routine,
 ' GetButtonM(), provides mouse support. The MouseStatus() routine in this
 ' module converts the mouse pointer virtual coordinates to BASIC's row-
 ' column format. For simplicity reasons, error trapping is not included.
 '
 ' QB refers to: QuickBasic 4.5
 ' VBDOS refers to: Visual Basic for DOS
 '
 ' To run this sample program from inside the QB environment, start the QB
 ' editor by typing: QB/L MLIBN
 '
 ' To run this sample program from inside the VBDOS environment, start the
 ' editor by typing: VBDOS/L MLIBF
 '
 ' QuickBasic and Visual Basic are trademarks of Microsoft Corporation.
 '===========================================================================

 DEFINT A-Z
 ' $INCLUDE: 'MLIB.BI'
 
 DECLARE SUB KeyBoardCheck (Kbd$, ChosenItem%)
 DECLARE SUB ShowMenu (Row%, Col%, Title$)
 DECLARE SUB PrintMenuItems ()
 DECLARE SUB DrawBox (R%, C%, Wide%, High%, Title$)
 DECLARE SUB MoveBar (LastItem%, NewItem)
 DECLARE SUB MouseLoop ()
 DECLARE SUB MouseCheck (NewItem, MouseRow%, MouseCol%)
 DECLARE SUB MouseStatus (MousePress%, MouseCol%, MouseRow%)
 DECLARE FUNCTION MouseOnItem% (X%, MouseRow%, MouseCol%)
 TYPE MenuType
      mnuCol     AS INTEGER
      mnuRow     AS INTEGER
 END TYPE
 CONST TRUE = -1, FALSE = 0
 COMMON SHARED /Menu/ Menu()           AS MenuType ' Menu control array.
 COMMON SHARED /Menu/ MenuItem()       AS STRING   ' Menu item array.
 COMMON SHARED /Menu/ MinItem          AS INTEGER  ' First menu item.
 COMMON SHARED /Menu/ MaxItem          AS INTEGER  ' Last menu item.
 COMMON SHARED /Menu/ LongestMenuItem  AS INTEGER  ' Longest menu item.
 COMMON SHARED /Menu/ LastItem         AS INTEGER  ' Last item highlighted.
 COMMON SHARED /Menu/ NewItem          AS INTEGER  ' Current item.
 COMMON SHARED /Menu/ MenuForeColor    AS INTEGER  ' Menu foreground color.
 COMMON SHARED /Menu/ MenuBackColor    AS INTEGER  ' Menu background color.

 COMMON SHARED /Menu/ FrameForeColor       AS INTEGER ' DrawBox()
 COMMON SHARED /Menu/ FrameBackColor       AS INTEGER ' variables.
 COMMON SHARED /Menu/ BoxForeColor         AS INTEGER
 COMMON SHARED /Menu/ BoxBackColor         AS INTEGER
 COMMON SHARED /Menu/ TitleForeColor       AS INTEGER
 COMMON SHARED /Menu/ TitleBackColor       AS INTEGER

 DIM SHARED CurMouseRow AS STRING * 2           ' Current pointer
 DIM SHARED CurMouseCol AS STRING * 2           ' position.

 FrameForeColor = 0
 FrameBackColor = 7
 BoxForeColor = 7
 BoxBackColor = 1
 TitleForeColor = 15
 TitleBackColor = 5

 CLS

 ' Use the whole screen.
 VIEW PRINT

 ' Initialize MLIB and mouse driver.
 CALL InitPointer(IsMouse%)

 ' Place pointer in upper left corner of screen.
 CALL SetPointer(0, 0)

 ' Draw main background box.
 CALL DrawBox(1, 1, 80, 24, "MLIB: Mouse Library Menu Demo")

 COLOR 0, 3
 HelpBar$ = " <Arrow Keys=Scroll Menu Items> <Enter=Choose Menu Item> <Esc=Quit Demo>       "
 LOCATE 25, 1: PRINT HelpBar$;

 FrameForeColor = 0: FrameBackColor = 3
 BoxForeColor = 7: BoxBackColor = 0

 MenuForeColor = BoxForeColor: MenuBackColor = BoxBackColor
 COLOR MenuForeColor, MenuBackColor
 CALL DrawBox(15, 22, 37, 5, "Menu Item Chosen:")

 ' Show the mouse pointer
 CALL ShowPointer

 ' Define the items that will appear on the menu.
 TotalItem% = 6   ' Total number of menu items.

 REDIM MenuItem(1 TO TotalItem%) AS STRING ' Array to hold menu items.

 MenuItem(1) = "           Menu Item  #1           "
 MenuItem(2) = "           Menu Item  #2           "
 MenuItem(3) = "           Menu Item  #3           "
 MenuItem(4) = "           Menu Item  #4           "
 MenuItem(5) = "           Menu Item  #5           "
 MenuItem(6) = "           Quit Demo               "

 ' Upper left corner of menu.
 Row% = 5: Col% = 22
 Title$ = "Menu"
 CALL ShowMenu(Row%, Col%, Title$)
 
 ' Mouse and keyboard code...
 DO
    DO ' Loop until a mouse button or a key is pressed.
       CALL MouseStatus(MousePress%, MouseCol%, MouseRow%)
      
       ' Show pointer position.
       IF MouseRow% <> OldMouseRow% OR MouseCol% <> OldMouseCol% THEN
          CurMouseRow = LTRIM$(STR$(MouseRow%))
          CurMouseCol = LTRIM$(STR$(MouseCol%))
          COLOR 0, 3: CALL HidePointer
          LOCATE 25, 75: PRINT CurMouseRow; ":"; CurMouseCol;
          CALL ShowPointer: COLOR BoxForeColor, BoxBackColor
          OldMouseRow% = MouseRow%
          OldMouseCol% = MouseCol%
       END IF

       KeyPress$ = INKEY$
    LOOP UNTIL MousePress% AND 1 OR LEN(KeyPress$)

    ' Clear Menu Chosen Item box.
    CALL HidePointer: LOCATE 17, 23: PRINT SPACE$(LEN(MenuItem(MinItem))): ShowPointer

    ' Check for a mouse event first.
    IF MousePress% AND 1 THEN
       CALL MouseCheck(ChosenItem%, MouseRow%, MouseCol%)
    END IF

    ' Check for a key press.
    IF KeyPress$ <> "" THEN
       CALL KeyBoardCheck(KeyPress$, ChosenItem%)
    END IF
  
    IF ChosenItem% THEN
       ReturnedItem$ = LTRIM$(RTRIM$(MenuItem(ChosenItem%)))
       SELECT CASE ReturnedItem$
          CASE "Menu Item  #1":    ' Place your code to branch here
          CASE "Menu Item  #2":    ' (or CHAIN another program)according
          CASE "Menu Item  #3":    ' to chosen item.
          CASE "Menu Item  #4":
          CASE "Menu Item  #5":
          CASE "Quit Demo": EXIT DO
       END SELECT
     
       ' Update Menu Chosen Item box.
       CALL HidePointer: LOCATE 17, 23: PRINT MenuItem(ChosenItem%): ShowPointer
    ELSE
       ReturnedItem$ = ""
    END IF
   
 LOOP UNTIL KeyPress$ = CHR$(27)

 ' We done...
 CALL HidePointer
 COLOR 7, 0
 CLS
 END

'
' Some simple code to get a box on the screen.
' R - Row
' C - Col
'
SUB DrawBox (R%, C%, Wide%, High%, Title$)

 CALL HidePointer
   
 ' Draw frame.
 COLOR FrameForeColor, FrameBackColor ' Frame color.
    
 LOCATE R%, C%: PRINT "ڴ";
 LOCATE R%, C% + Wide% - 2: PRINT "ÿ";

 FOR RR% = R% + 1 TO R% + High% - 2
    LOCATE RR%, C%: PRINT "";
    LOCATE RR%, C% + Wide% - 1: PRINT "";
 NEXT RR%
    
 LOCATE R% + High% - 1, C%:
 PRINT ""; STRING$(Wide% - 2, ""); "";
    
 ' Calculate title stuff.
 TitleBarWidth% = Wide% - 4
 TitleBarCenter% = (TitleBarWidth%) \ 2

 Text$ = Title$
 TitleLen% = LEN(Text$)

 ' Draw title bar background.
 COLOR TitleForeColor, TitleBackColor
 LOCATE R%, C% + 2: PRINT SPACE$(TitleBarWidth%)

 ' Clip title if needed.
 IF TitleLen% > TitleBarWidth% THEN
    Text$ = LEFT$(Text$, TitleBarWidth%)
    TitleLen% = LEN(Text$)
 END IF

 ' Center and print title.
 LOCATE R%, C% + TitleBarCenter% - (TitleLen% \ 2) + 2
 PRINT Text$
    
 ' Fill in frame.
 COLOR BoxForeColor, BoxBackColor ' Frame fill color.
 FOR RR% = R% + 1 TO R% + High% - 2
     LOCATE RR%, C% + 1: PRINT SPACE$(Wide% - 2);
 NEXT RR%
   
 ' Shade color.
 COLOR 8, 0

 ' Draw shading (vertical).
 FOR RR% = R% + 1 TO R% + High%
   
    ' Clip shading if needed.
    IF RR% <= 25 AND C% + Wide% <= 80 THEN
       S% = SCREEN(RR%, C% + Wide%)
       LOCATE RR%, C% + Wide%: PRINT CHR$(S%);
    END IF
 NEXT RR%
    
 FOR CC% = C% + 1 TO C% + Wide%
   
    ' Clip shading if needed.
    IF R% + High% <= 25 AND CC% <= 80 THEN
       S% = SCREEN(R% + High%, CC%)
       LOCATE R% + High%, CC%: PRINT CHR$(S%);
    END IF
 NEXT CC%

 CALL ShowPointer

END SUB

'
' Keyboard support for menu.
'
' Scroll selection (highlight) bar using the arrow keys.
'
' ChosenItem% - returns the chosen item's element value.
'
SUB KeyBoardCheck (Kbd$, ChosenItem%)

 ChosenItem% = FALSE

 SELECT CASE Kbd$
    
     CASE CHR$(0) + "H", CHR$(0) + "K"  ' Up and right arrow.
        NewItem = LastItem - 1
        ChangeBar% = TRUE
    
     CASE CHR$(0) + "P", CHR$(0) + "M"  ' Down and left arrow.
        NewItem = LastItem + 1
        ChangeBar% = TRUE

     CASE CHR$(0) + "G", CHR$(0) + "I"  ' Home and page up.
        NewItem = MinItem
        ChangeBar% = TRUE
    
     CASE CHR$(0) + "O", CHR$(0) + "Q"  ' End and page down.
        NewItem = MaxItem
        ChangeBar% = TRUE

     CASE CHR$(13)                      ' Enter.
        NewItem = LastItem
       
        ' Return chosen menu item.
        ChosenItem% = NewItem
       
 END SELECT

 ' Show item highlighted.
 IF ChangeBar% = TRUE THEN
    CALL MoveBar(LastItem, NewItem)
    LastItem = NewItem
 END IF
END SUB

'
' Mouse support for menu.
'
SUB MouseCheck (NewItem, MouseRow%, MouseCol%)
 
 ' Check if cursor is on a menu item.
 IF MouseOnItem(NewItem, MouseRow%, MouseCol%) THEN
    OnItem% = TRUE

    DO ' Use the mouse pointer position that was passed to us first.
      
       IF MouseOnItem(NewItem, MouseRow%, MouseCol%) THEN
          OnItem% = TRUE
       ELSE
          OnItem% = FALSE
       END IF

       'Show item highlighted.
       IF OnItem% = TRUE AND LastItem <> NewItem THEN
          CALL MoveBar(LastItem, NewItem)
          LastItem = NewItem
       END IF
      
       CALL MouseStatus(MousePress%, MouseCol%, MouseRow%)
      
       ' When using mouse events, we should check for a LButtonUp
       ' event and see if pointer is still on an item.
       IF NOT MousePress% AND 1 THEN    ' This menu item has been chosen,
          EXIT SUB                      ' NewItem - returns the item's
       END IF                           ' element value.
      
       OnItem% = FALSE
   
    LOOP WHILE MousePress% AND 1
 END IF

 'We checked the entire array, no match of cursor to menu item.
 NewItem = FALSE
  
 ' Mouse was pressed off the menu, loop while mouse button is down.
 ' Not needed when called by the MLIBSAM6.BAS modual.
 'CALL MouseLoop

END SUB

'
' Loop while mouse button is down.
'
SUB MouseLoop
 DO ' Check for mouse event.
    CALL GetButtonM(MousePress%, D%, D%)
 LOOP WHILE MousePress%
END SUB

'
' Checks if mouse pointer is on a menu item.
'
FUNCTION MouseOnItem (X%, MouseRow%, MouseCol%)
   
 FOR X% = MinItem TO MaxItem
 
     IF MouseRow% = Menu(X%).mnuRow THEN

           SELECT CASE MouseCol%
              CASE Menu(X%).mnuCol TO Menu(X%).mnuCol + LongestMenuItem - 1
                 MouseOnItem = TRUE
                 EXIT FUNCTION
           END SELECT
     END IF
 NEXT X%

 ' No match found.
 X% = FALSE

 MouseOnItem = FALSE

END FUNCTION

'
' Returns mouse button presses and coordinates of pointer.
'
' By default, the mouse coordinating system works on a virtual screen of 640
' by 200 (8 * number-of-text-rows) pixels.
'
' To convert the virtual mouse position to text mode's row/column format, the
' x and y variables must be swapped.
'
' For example:
'
'               For graphics  - CALL GetButtonM(MousePress%, X%, Y%)
'
'               X% = Horizontal coordinates.
'               Y% = Vertical coordinates.
'
'               For text mode - CALL GetButtonM(MousePress%, Y%, X%)
'
'               X% = Row coordinates.
'               Y% = Column coordinates.
'
SUB MouseStatus (MousePress%, MouseCol%, MouseRow%)
 CALL GetButtonM(MousePress%, MouseCol%, MouseRow%)

 ' Convert virtual mouse position to BASIC's 1-based row/column format.
 MouseCol% = MouseCol% \ 8 + 1  ' Divide by width of current character.
 MouseRow% = MouseRow% \ 8 + 1  ' Divide by height of current character.
END SUB

'
' Highlights a selected menu item.
'
SUB MoveBar (LastItem, NewItem)

 ' *** Keep pointers within range. ***
                                               ' Un-REM these two IF - THENs
 ' Selection bar stops at top and bottom.      ' to stop selection bar from
 'IF NewItem > MaxItem THEN NewItem = MaxItem  ' continuously looping. Make
 'IF NewItem < MinItem THEN NewItem = MinItem  ' sure the next two IF - THENs
                                               ' are REM-ed.
 '' Selection bar moves continuously.
 IF NewItem > MaxItem THEN NewItem = MinItem
 IF NewItem < MinItem THEN NewItem = MaxItem
 ' ***********************************

 IF LastItem <> NewItem THEN
   
    CALL HidePointer
   
    ' Turn off highlight on the last selected menu item.
    COLOR MenuForeColor, MenuBackColor
    LOCATE Menu(LastItem).mnuRow, Menu(LastItem).mnuCol
    PRINT MenuItem(LastItem)
   
    ' Highlight new selected menu item by reversing colors.
    COLOR MenuBackColor, MenuForeColor  ' Reverse colors.
    LOCATE Menu(NewItem).mnuRow, Menu(NewItem).mnuCol
    PRINT MenuItem(NewItem)
    COLOR MenuForeColor, MenuBackColor  ' Restore colors.
    CALL ShowPointer
  END IF

END SUB

'
' Print all menu items using the menu control array coordinates.
'
SUB PrintMenuItems
 
 COLOR MenuForeColor, MenuBackColor

 CALL HidePointer
 ' Print menu items.
 FOR X% = MinItem TO MaxItem
    LOCATE Menu(X%).mnuRow, Menu(X%).mnuCol
    PRINT MenuItem(X%)
 NEXT X%
 CALL ShowPointer
END SUB

'
' Initializes menu control array and draws menu on the screen.
' Length of the longest menu item determines the width of the menu box.
'
SUB ShowMenu (Row%, Col%, Title$)

 MinItem = LBOUND(MenuItem, 1)
 MaxItem = UBOUND(MenuItem, 1)
 REDIM Menu(MinItem TO MaxItem)  AS MenuType

 ' Make sure we start at zero length.
 LongestMenuItem = 0

 ' Use a copy.
 R% = Row%

 ' Initialize menu control array.
 FOR X% = MinItem TO MaxItem
    R% = R% + 1
    Menu(X%).mnuCol = Col% + 1
    Menu(X%).mnuRow = R%
   
    ' Find the longest menu item.
    NewLen% = LEN(MenuItem(X%))
    IF NewLen% > LongestMenuItem THEN
       LongestMenuItem = NewLen%
    END IF

 NEXT X%

 CALL HidePointer

 ' Draw a menu backgound box 2 columns wider than the longest item.
 High% = MaxItem - MinItem + 3
 Wide% = LongestMenuItem + 2
 CALL DrawBox(Row%, Col%, Wide%, High%, Title$)

 ' Print menu items on screen and show first selection highlighted.
 CALL PrintMenuItems
 CALL MoveBar(MaxItem, MinItem)
 LastItem = MinItem: NewItem = MinItem
 CALL ShowPointer

END SUB

