 DEFINT A-Z
 '============================== MLIBDATA.BAS================================
 '                  THIS SAMPLE PROGRAM IS PROVIDED AS IS.
 '
 ' You may modify/use this code in any way you wish, provided that you agree
 ' that Terry Venn has no warranties, obligations or liabilities for any code
 ' contained in this sample program.
 '
 ' MLIBDATA.BAS is a sample program that converts raw binary pointer shape
 ' information into BASIC's DATA statements, which can be used in your code
 ' for changing shapes.
 '
 ' QB refers to: QuickBasic 4.5
 ' VBDOS refers to: Visual Basic for DOS
 '
 ' To run this sample program from inside the QB environment, start the QB
 ' editor by typing: QB/L MLIBN
 '
 ' To run this sample program from inside the VBDOS environment, start the
 ' editor by typing: VBDOS/L MLIBF
 '
 ' QuickBasic and Visual Basic are trademarks of Microsoft Corporation.
 '===========================================================================

 ' $INCLUDE: 'MLIB.BI'

DECLARE SUB ReadData ()
DECLARE SUB Target ()
DECLARE SUB GetInput (SHP$, DAT$, RNum%)
DECLARE SUB Cvt2Data (SHP$, DAT$, RNum%)

'============================================================================
                                                 '
SCREEN 12: CLS : CALL InitPointer(NumBut%)       '
                                                 '
IF NumBut% = 0 THEN SCREEN 0: END                'No mouse.
                                                 '
CALL GetInput(SHP$, DAT$, RNum%)                 'User input.
                                                 '
CALL Cvt2Data(SHP$, DAT$, RNum%)                 'Convert to DATA statements.
                                                 '
CALL ReadData                                    'Convert DATA into a shape.
                                                 '
CLS : CALL Target                                'Draw a background.
                                                 '
PRINT "  <DATA created pointer shape shown.>";   '
                                                 '
PRINT "                <Press a key to end.>"    '
                                                 '
CALL ShowPointer                                 '
                                                 '
DO: LOOP UNTIL LEN(INKEY$)                       '
                                                 '
SCREEN 0: END                                    '
                                                 '
'============================================================================

'=======================< Example output of this program >===================

'The first 2 data constants (in each block) contain the hot spot x,y values.
'You must copy and paste your own to display other shapes.
'Just run this demo, next ALT+F+L oad DATA filename, copy and paste it here.
'Subroutine ReadData() converts this DATA back into a pointer shape.

'Arrow pointer, in SOLID format.
'REM this DATA block to show next shape.

'Source      : MLIBSAM.SHP
'Destination : DATA.DAT
'Record      : 1
'Format      : SOLID
DATA &H0,&H0,&H3FFF,&HFFF,&H3FF,&HFF,&H3F,&HF,&H3
DATA &H1,&H3F,&H81F,&H1C0F,&H3E07,&H7F03,&HFF83,&HFFC7,&HFFFF
DATA &H0,&H4000,&H7000,&H7C00,&H7F00,&H7FC0,&H7FF0,&H7F00,&H6780
DATA &H43C0,&H1E0,&HF0,&H78,&H38,&H0,&H0

'Arrow pointer, in TRANSparent format.

'Source      : MLIBSAM.SHP
'Destination : DATA.DAT
'Record      : 19
'Format      : TRANS
DATA &H0,&H0,&HFFFF,&HFFFF,&HFFFF,&HFFFF,&HFFFF,&HFFFF,&HFFFF
DATA &HFFFF,&HFFFF,&HFFFF,&HFFFF,&HFFFF,&HFFFF,&HFFFF,&HFFFF,&HFFFF
DATA &HC000,&HF000,&HFC00,&HFF00,&HFFC0,&HFFF0,&HFFFC,&HFFFE,&HFFC0
DATA &HF7E0,&HE3F0,&HC1F8,&H80FC,&H7C,&H38,&H0

'============================================================================

SUB Cvt2Data (SHP$, DAT$, RNum%)

FH1% = FREEFILE: OPEN SHP$ FOR BINARY AS #FH1%   '
FH2% = FREEFILE: OPEN DAT$ FOR OUTPUT AS #FH2%   'Sequential output.
EndData% = RNum% * 80 - 1                        'Calculate end of data, work
StartData% = EndData% - 62                       'backwards.Why? Because.
Xoff% = StartData% - 14                          'Hot spot X offset.
Yoff% = Xoff% + 2                                'Hot spot Y offset.
                                                 '
DIM Format AS STRING * 10: CLS                     '
                                                 '
RNum% = RNum% - 1                                'Get actual record.
GET #FH1%, Xoff%, HotX%                          'Get the hot spots.
GET #FH1%, Yoff%, HotY%                          '
GET #FH1%, Yoff% + 2, Format                     'Solid or Transparent shape.
                                                 '
PRINT #FH2%, "'Source      : "; SHP$             'Print to file.
PRINT #FH2%, "'Destination : "; DAT$
PRINT #FH2%, "'Record      :"; RNum%
PRINT #FH2%, "'Format      : "; Format
PRINT #FH2%, "DATA "; "&H"; HEX$(HotX%); ","; "&H"; HEX$(HotY%);

PRINT "'Source      : "; SHP$                    'Print to screen.
PRINT "'Destination : "; DAT$
PRINT "'Record      :"; RNum%
PRINT "'Format      : "; Format
PRINT "DATA "; "&H"; HEX$(HotX%); ","; "&H"; HEX$(HotY%);
Cntr% = 2

FOR OffSet% = StartData% TO EndData% STEP 2      '64 bytes.

  Cntr% = Cntr% + 1
  GET #FH1%, OffSet%, Get2Byte%
  SHPDAT$ = SHPDAT$ + MKI$(Get2Byte%)

  SELECT CASE Cntr%
     CASE IS = 1
        PRINT #FH2%, "DATA "; "&H"; HEX$(Get2Byte%);
        PRINT "DATA "; "&H"; HEX$(Get2Byte%);
     CASE IS <= 8
        PRINT #FH2%, ","; ; "&H"; HEX$(Get2Byte%);
        PRINT ","; "&H"; HEX$(Get2Byte%);
     CASE IS > 8
        PRINT #FH2%, ","; ; "&H"; HEX$(Get2Byte%)
        PRINT ","; "&H"; HEX$(Get2Byte%)
        Cntr% = 0
  END SELECT

NEXT OffSet%

CLOSE
PRINT : PRINT : PRINT "Converted pointer shape shown."
PRINT : PRINT : PRINT "Press a key to continue."

ShowPointer                                      'Show the shape that was
CALL ChangePointer(SHPDAT$, HotX%, HotY%)        'just converted to DATA
Hold$ = INPUT$(1): HidePointer                   'statements.

END SUB

SUB GetInput (SHP$, DAT$, RNum%)

TryAgain1:

PRINT "               Ŀ"
PRINT "                                                                  "
PRINT "                      Source: Name of the [XXX.SHP] file that     "
PRINT "                              contains the shape information      "
PRINT "                              to convert to DATA statements.      "
PRINT "                                                                  "
PRINT "                              NOTE! You must supply the complete  "
PRINT "                              filename.                           "
PRINT "                                                                  "
PRINT "                 Destination: Name of the output file that will   "
PRINT "                              hold the DATA statements.           "
PRINT "                                                                  "
PRINT "                                                                  "
PRINT "                Shape number: Number of the desired shape.        "
PRINT "                              (Run MLIBVIEW.BAS to get number)    "
PRINT "                                                                  "
PRINT "               "


INPUT "Source       <ENTER=[MLIBSAM.SHP]> : "; SHP$ 'File to open.
INPUT "Destination  <ENTER=[DATA.DAT]> : "; DAT$ 'Data output file.
                                                 '
IF LEN(SHP$) = 0 THEN SHP$ = "MLIBSAM.SHP"       '
IF LEN(DAT$) = 0 THEN DAT$ = "DATA.DAT"          '
                                                 '
FH% = FREEFILE                                   '
OPEN SHP$ FOR INPUT AS #FH%                      '
                                                 '
MaxRec% = (LOF(FH%) \ 80) - 1: CLOSE             'Calculate number of records,
                                                 'minus 1, header not counted.
TryAgain:                                        '
                                                 '
PRINT "Shape number < 1 -"; MaxRec%; ">  : ";    'Get which record...
                                                 '
INPUT RNum%                                      '
                                                 '
IF RNum% <= 0 THEN                               '
   PRINT "Bad shape number.  Redo..."            '
   GOTO TryAgain                                 '
ELSEIF RNum > MaxRec% THEN                       'Passed end of file.
   PRINT "Bad shape number.  Redo..."            '
   GOTO TryAgain                                 '
END IF                                           '
                                                 '
RNum% = RNum% + 1                                'Skip over header.
                                                 '
END SUB                                          '

'
'****************************************************************************
'*                                                                          *
'* Read the shape DATA into SHPDAT$, then tell the Changepointer            *
'* routine to change the mouse cursor to the new shape.                     *
'*                                                                          *
'****************************************************************************
'
SUB ReadData

'============================================================================

READ HotX%, HotY%                                'First 2 statements are
                                                 'X and Y hot spots.
FOR xdata = 1 TO 32                              '
   READ SHPdata%                                 '
   SHPDAT$ = SHPDAT$ + MKI$(SHPdata%)            'Build data string.
NEXT xdata                                       '
                                                 '
CALL ChangePointer(SHPDAT$, HotX%, HotY%)        'Change it.
                                                 '
'============================================================================

END SUB

SUB Target

LINE (15, 16)-(615, 465), 15, BF
                                               
Colr% = 0
FOR Size% = 220 TO 20 STEP -20

   Colr% = Colr% + 1
   CIRCLE (320, 240), Size%, Colr%
   PAINT (320, 240), Colr%, Colr%

NEXT

END SUB

