DECLARE FUNCTION MATCH% (MatchStr$, Text$, BYVAL MatchPoint AS INTEGER)

DEFINT A-Z
'
'Copyright (C) 1991 Brian J. McMahon - Johnson City, NY (607) 770-7043
'(rights NOT reserved).
'
'
'MATCH provides extensive pattern matching including support for the
'following: "!" - a letter  "&" - a letter or number "?" - any character
'           "#" - a number  "\" - an escape character to match with any
'                                 reserved wildcards.
'
'MATCH allows you to specify where in the string to start the matching process.
'
'MATCH returns the position in the string where the first match occurred or
'      0 if no match.
'
'Examples:  MATCH ("#!ABC", "1 ABC 2AABC", 1) (=6)
'           MATCH ("\#\#\#", "123###4567###", 7) (=11)
'
FUNCTION MATCH% (MatchStr$, Text$, BYVAL MatchPoint AS INTEGER)
    CONST FALSE = 0
    STATIC TotMatchChars, TextLen, LookAt, CheckedChars, K, B, Wild$
    TotMatchChars = LEN(MatchStr$)
    TextLen = LEN(Text$)
    IF TotMatchChars = 0 OR TextLen = 0 OR MatchPoint < 1 THEN
        MATCH = FALSE
        EXIT FUNCTION
    END IF
    LookAt = MatchPoint - 1
    CheckedChars = 0
    FOR MatchChar = 1 TO TotMatchChars
        CheckedChars = CheckedChars + 1
        LookAt = LookAt + 1
        Wild$ = MID$(MatchStr$, MatchChar, 1)
        DO ' a phony loop so we can EXIT DO rather than GOTO LABEL
            SELECT CASE Wild$
                CASE IS = "?"
                    IF TextLen >= LookAt THEN
                        MatchedAt = LookAt
                        EXIT DO
                    END IF
                    MATCH = FALSE
                    EXIT FUNCTION
                CASE IS = "#"
                    FOR K = LookAt TO TextLen
                        B = ASC(MID$(Text$, K))
                        IF B > 47 AND B < 58 THEN
                            MatchedAt = K
                            EXIT DO
                        END IF
                    NEXT
                    MATCH = FALSE
                    EXIT FUNCTION
                CASE IS = "!"
                    FOR K = LookAt TO TextLen
                        B = ASC(MID$(Text$, K))
                        IF B > 64 AND B < 91 OR (B > 96 AND B < 123) THEN
                            MatchedAt = K
                            EXIT DO
                        END IF
                    NEXT
                    MATCH = FALSE
                    EXIT FUNCTION
                CASE IS = "&"
                    FOR K = LookAt TO TextLen
                        B = ASC(MID$(Text$, K))
                        IF B > 47 AND B < 58 OR (B > 64 AND B < 91) OR (B > 96 AND B < 123) THEN
                            MatchedAt = K
                            EXIT DO
                        END IF
                    NEXT
                    MATCH = FALSE
                    EXIT FUNCTION
                CASE IS = "\"
                    IF MatchChar < TotMatchChars THEN
                        MatchChar = MatchChar + 1
                        MatchedAt = INSTR(LookAt, Text$, MID$(MatchStr$, MatchChar))
                    ELSE
                        MatchedAt = INSTR(LookAt, Text$, Wild$)
                    END IF
                CASE ELSE
                    MatchedAt = INSTR(LookAt, Text$, Wild$)
            END SELECT
            IF MatchedAt = 0 THEN
                MATCH = FALSE
                EXIT FUNCTION
            END IF
            EXIT DO
        LOOP
        IF MatchedAt > LookAt THEN
            IF CheckedChars = 1 THEN
                LookAt = MatchedAt
                MatchPoint = MatchedAt
            ELSE
                LookAt = MatchedAt - CheckedChars
                MatchChar = 0
                CheckedChars = 0
                MatchPoint = LookAt + 1
            END IF
        END IF
    NEXT
    MATCH = MatchPoint
END FUNCTION

