DECLARE FUNCTION MATCH% (MatchStr$, Text$, BYVAL MatchPoint AS INTEGER)
DECLARE FUNCTION MhASCIIMid% (A$, BYVAL Position%)
DECLARE FUNCTION MhFwdInstrChar% (BYVAL Start%, BYVAL Char%, Target$)

DEFINT A-Z
'
'Copyright (C) 1991 Brian J. McMahon - Johnson City, NY (607) 770-7043
'(rights NOT reserved).
'
'MATCH uses MicroHelp Muscle functions MhASCIIMid and MhFwdInstrChar
'           (copyright MicroHelp Inc.) for additional speed.
'
'MATCH provides extensive pattern matching including support for the
'following: "!" - a letter  "&" - a letter or number "?" - any character
'           "#" - a number  "\" - an escape character to match with any
'                                 reserved wildcards.
'
'MATCH allows you to specify where in the string to start the matching process.
'
'MATCH returns the position in the string where the first match occurred or
'      0 if no match.
'
'Examples:  MATCH ("#!ABC", "1 ABC 2AABC", 1) (=6)
'           MATCH ("\#\#\#", "123###4567###", 7) (=11)
'
FUNCTION MATCH% (MatchStr$, Text$, BYVAL MatchPoint AS INTEGER)
    CONST FALSE = 0
    STATIC TotMatchChars, TextLen, LookAt, CheckedChars, WildCard, K, B
    TotMatchChars = LEN(MatchStr$)
    TextLen = LEN(Text$)
    IF TotMatchChars = 0 OR TextLen = 0 OR MatchPoint < 1 THEN
        MATCH = FALSE
        EXIT FUNCTION
    END IF
    LookAt = MatchPoint - 1
    CheckedChars = 0
    FOR MatchChar = 1 TO TotMatchChars
        CheckedChars = CheckedChars + 1
        LookAt = LookAt + 1
        WildCard = MhASCIIMid%(MatchStr$, MatchChar)
        DO ' a phony loop so we can EXIT DO rather than GOTO LABEL
            SELECT CASE WildCard
                CASE 63
                    '"?"
                    IF TextLen >= LookAt THEN
                        MatchedAt = LookAt
                        EXIT DO
                    END IF
                    MATCH = FALSE
                    EXIT FUNCTION
                CASE 35
                    '"#"
                    FOR K = LookAt TO TextLen
                        B = MhASCIIMid%(Text$, K)
                        IF B > 47 AND B < 58 THEN
                            MatchedAt = K
                            EXIT DO
                        END IF
                    NEXT
                    MATCH = FALSE
                    EXIT FUNCTION
                CASE 33
                    '"!"
                    FOR K = LookAt TO TextLen
                        B = MhASCIIMid%(Text$, K)
                        IF B > 64 AND B < 91 OR (B > 96 AND B < 123) THEN
                            MatchedAt = K
                            EXIT DO
                        END IF
                    NEXT
                    MATCH = FALSE
                    EXIT FUNCTION
                CASE 38
                    '"&"
                    FOR K = LookAt TO TextLen
                        B = MhASCIIMid%(Text$, K)
                        IF B > 47 AND B < 58 OR (B > 64 AND B < 91) OR (B > 96 AND B < 123) THEN
                            MatchedAt = K
                            EXIT DO
                        END IF
                    NEXT
                    MATCH = FALSE
                    EXIT FUNCTION
                CASE 92
                    '"\"
                    IF MatchChar < TotMatchChars THEN
                        MatchChar = MatchChar + 1
                        MatchedAt = MhFwdInstrChar%(LookAt, MhASCIIMid%(MatchStr$, MatchChar), Text$)
                    ELSE
                        MatchedAt = MhFwdInstrChar%(LookAt, WildCard, Text$)
                    END IF
                CASE ELSE
                    MatchedAt = MhFwdInstrChar%(LookAt, WildCard, Text$)
            END SELECT
            IF MatchedAt = 0 THEN
                MATCH = FALSE
                EXIT FUNCTION
            END IF
            EXIT DO
        LOOP
        IF MatchedAt > LookAt THEN
            IF CheckedChars = 1 THEN
                LookAt = MatchedAt
                MatchPoint = MatchedAt
            ELSE
                LookAt = MatchedAt - CheckedChars
                MatchChar = 0
                CheckedChars = 0
                MatchPoint = LookAt + 1
            END IF
        END IF
    NEXT
    MATCH = MatchPoint
END FUNCTION

