DECLARE FUNCTION keywaiting%
DIM clock AS STRING * 8

SCREEN 12      'vga 640x480 mode
               'set up variables
DIM hours AS INTEGER, hourcheck AS INTEGER, shour AS STRING * 2
DIM minutes AS INTEGER, minutecheck AS INTEGER
DIM seconds AS INTEGER, secondcheck AS INTEGER

WINDOW (-100, 100)-(100, -100)     'make coordinates easier to reference
COLOR 15          'set up color for numbers

mincolor% = 10        'color for minute and hour hands
seccolor% = 12        'color for second hand
                     
                      'print numbers around clock
                   ' ------------------------------------
LOCATE 1, 40: PRINT "12";
LOCATE 30, 41: PRINT "6";
LOCATE 28, 25: PRINT "7                              5";
LOCATE 23, 14: PRINT "8                                                   4";
LOCATE 15, 11: PRINT "9                                                          3";
LOCATE 8, 14: PRINT "10                                                  2";
LOCATE 3, 25: PRINT "11                             1";

                   ' make lines around clock and fill
                  ' ---------------------------------------
LINE (-75, 100)-(75, 100), 9
LINE -(100, -100), 9
LINE -(-100, -100), 9
LINE -(-75, 100), 9
PAINT (-100, 100), 9
PAINT (100, 100), 9

                     
                      'draw dots around clock
                   ' ----------------------------
FOR x = 0 TO 6.28 STEP .104666#
PSET (COS(x) * 92 * .75, SIN(x) * 92), 15   '.75 =480/640   ratio of x to y
NEXT

COLOR 13                   'set up color for digital time string


'--------------------------------------------------------------------------

DO              'main loop

        DO
                IF NOT INKEY$ = "" THEN END     'press a key to quit
                clock$ = TIME$                  'get time into local variable
                shour$ = clock$      'get hour string with 2 byte string
                seconds = VAL(RIGHT$(clock$, 2))
  LOOP UNTIL secondcheck XOR seconds     'exit loop once every second

        hours = VAL(shour$)
        IF hours > 12 THEN hours = hours - 12   'convert hours to 12 hour time

        minutes = VAL(MID$(clock$, 4, 2))
        
       
        IF minutecheck XOR minutes OR seconds = 15 OR seconds = 30 OR seconds = 45 THEN
                        'update minute hand every 15 seconds     

                LINE (0, 0)-(COS(thetam) * 90 * .75, SIN(thetam) * 90), 0
                        'remove old minute hand
                thetam = ((minutes - 15) * 3.14 / -30) - (seconds * .0017)
                        'update angle for minute hand
                minutecheck = minutes
      

                LINE (0, 0)-(COS(thetaH) * 60 * .75, SIN(thetaH) * 60), 0
                        'remove old hour hand
                thetaH = ((hours * 5 - 15) * 3.14 / -30) - (minutes * .0087)
                        'update angle for hour hand
                hourcheck = hours

        END IF
       
        LINE (0, 0)-(COS(thetam) * 90 * .75, SIN(thetam) * 90), mincolor%
                'draw minute hand
        LINE (0, 0)-(COS(thetaH) * 60 * .75, SIN(thetaH) * 60), mincolor%
                'draw hour hand



        LINE (0, 0)-(COS(theta) * 90 * .75, SIN(theta) * 90), 0
                'remove old second hand
        theta = (seconds - 15) * 3.14 / -30   'update angle for second hand
        LINE (0, 0)-(COS(theta) * 90 * .75, SIN(theta) * 90), seccolor%
                'draw second hand
        secondcheck = seconds


        LOCATE 6, 37: PRINT TIME$;
        LOCATE 25, 36: PRINT "DM-RESEARCH";



LOOP
                'DM RESEARCH CO
                'po box 745
                'Fall Riner ,Ma
                '   02722

