;************************************************************
; New PrintScreen handler - Assembled as a .COM file        *
;   MASM NoPrint.ASM;                                       *
;   LINK NoPrint;                                           *
;   EXE2BIN NoPrint.EXE NoPrint.COM                         *
; By Mario Giannini                                         *
;************************************************************
TSR          EQU   31h
SetVect      EQU   25h
PrtScrn      EQU    5h
GetVideoMode EQU   0Fh
SetCursPos   EQU   02h
PrintChar    EQU   0Eh
GetKey       EQU   00h
VideoMode    EQU   0Fh
Pos2Save     EQU   80     ;How many screen position to save

        ASSUME CS:MyCode, DS:MyCode
;************************************************************
; Single Code segment (and data if needed) used for a .COM file
MyCode  SEGMENT
          ORG	100h	;Skips the PSP
START:
          JMP Init
Screen    DW  Pos2Save DUP (?)  ;
Message   DB  "You Can't press PrtScrn anymore!   ",0
OldCurPos DW  ?
VideoSeg  DW  0B800h  ;Default to color
RunStat   DB  0
;---------------------------------------------------------------
;  This is our new interrupt handler
;
NewInt5:
        CMP     CS:RunStat,0    ;These few lines stop interrupt from running over
        JZ      RunOK        ;itself if PrntScrn is pressed twice in a row.
        IRET
RunOK:
        MOV     CS:RunStat,1
        PUSH    AX
        PUSH    BX
        PUSH    CX
        PUSH    DX
        PUSH    SI
        PUSH    DI
        PUSH    ES
        PUSH    DS
        PUSH    BP

        MOV     AX,CS    ;Save our screen (just first line)
        MOV     ES,AX
        MOV     DS,AX
        CLD
        LEA     DI,Screen
        MOV     SI,0
        MOV     DS,VideoSeg
        MOV     CX,Pos2Save
        REP     MOVSW

        MOV     AX,CS		;Now Save our old cursor position
        MOV     DS,AX
        MOV     AH,3
        MOV     BH,0
        INT     10H
        MOV     OldCurPos,DX

        MOV     AH,SetCursPos
        MOV     BH,0
        MOV     DX,0     ;Set location to 0,0 or upper left corner
        INT     10H

        MOV     AH,PrintChar
        MOV     BH,0
        LEA     SI,Message
PrntLoop:                ;Print string loop (uses ROM BIOS but not color)
        MOV     AL,[SI]
        CMP     AL,0
        JZ      Time2Wait
        INT     10H
        INC     SI
        JMP     PrntLoop
        
Time2Wait:
        MOV     AH,GetKey   ;Wait for a keystroke
        INT     16H

        MOV     AX,VideoSeg    ;Restore our screen 
        MOV     ES,AX
        CLD
        LEA     SI,Screen
        MOV     DI,0
        MOV     CX,Pos2Save
        REP     MOVSW

        MOV     AH,SetCursPos   ;Restore our old cursor position
        MOV     BH,0
        MOV     DX,OldCurPos
        INT     10H
        
        POP     BP
        POP     DS
        POP     ES
        POP     DI
        POP     SI
        POP     DX
        POP     CX
        POP     BX
        POP     AX
        MOV     CS:RunStat,0
        IRET                      ;And I am outta here.
;---------------------------------------------------------------
Init:
        MOV   AX,CS     ;Setup the DS register
        MOV   DS,AX

        MOV	AH,VideoMode  ;Get Video Segment for later
        INT 10H
        CMP AL,7
        JNZ NoChange
        MOV VideoSeg,0B000H
NoChange:    
        MOV   AH,SetVect     ;Set the new vector for new handler
        MOV   AL,PrtScrn
        LEA   DX,NewInt5
        INT   21H   
        
        MOV   AH,TSR     ;MS-DOS Terminate and Stay Resident DOS function (031h)
        MOV   AL,0
;
; This gets size of program to save - Works for .COM file only I believe
;
        MOV   DX,CodeSize       ;Reserve 1 Paragraph (16 bytes) for program
        MOV   CL,4
        SHR   DX,CL
        ADD   DX,10H            ;Extra space
        INT   21H
;---------------------------------------------------------------
CodeSize  EQU $-START  ;$ (or current offset) - Start equals program size
;---------------------------------------------------------------
MyCode  ENDS
        END START

