pushall macro
        push    ax
        push    bx
        push    cx
        push    dx
        #em
popall  macro
        pop     dx
        pop     cx
        pop     bx
        pop     ax
        #em
print_word      macro
        mov     ah,9
        int     21h
        #em
code_seg        segment
        assume  cs:code_seg
        org     100h
        jmp     dis_play_files
;------------------------------------------------
source          equ     0b0h
tell            db      '<- bytes free $'
bufspace        db      10 dup (0)
tempx           db      0
tempy           db      0
prompt_b        db      ' drive b:$'
prompt_a        db      ' drive a:$'
prompt_c        db      ' drive c:$'
nfile           db      '<- files$'
pause           db      'press any key when ready.....$'
wild_cards      db      '*.*',0
disp_flag       db      0
full_flag       db      0
source_path_end dw      ?
marked  db      ?
attrib  db      7
cursor_x        db      ?
cursor_y        db      ?
file_count      db      0
ascii_str       db      7 dup ('$')
;------------------------------------------------
cursor_off      proc    near
        mov     ah,1
        mov     ch,15
        mov     cl,15
        int     10h
        ret
cursor_off      endp
;------------------------------------------------
cursor_on       proc    near
        mov     ah,1
        mov     ch,11
        mov     cl,12
        int     10h
        ret
cursor_on       endp
;------------------------------------------------
clear_screen    proc    near
        mov     ah,0
        mov     al,2
        int     10h
        ret
clear_screen    endp
;------------------------------------------------
dis_play_files    proc    near
   call    clear_screen
   mov     file_count,0
   mov     di,source
   mov     si,082h
   mov     source_path_end,source
   mov     bx,080h
   call    cursor_off
   call    drive_number
   mov     ah,2
   mov     bh,0
   mov     dh,3
   mov     dl,0
   int     10h
   call    print_line
   mov     cursor_x,3
   mov     cursor_y,4
   call    setcursor
   mov     ah,04eh
   mov     cx,4
   mov     di,source_path_end
   mov     si,offset wild_cards
rep     movsb
   mov     dx,source
   int     21h
   jc      ender
   mov     dh,4
   mov     dl,3
   mov     ah,2
   int     10h
   call    printm
   mov     cx,100
looper:
   mov     ah,04fh
   int     21h
   jc      ender
   mov     disp_flag,0ffh
   call    inc_cursor
   mov     disp_flag,0
   call    printm
   mov     dx,offset wild_cards
   loop    looper
ender:
   mov     ah,3
   mov     bh,0
   int     10h
   inc     dh
   mov     dl,0
   mov     ah,2
   int     10h
   call    print_line
   call    convert
   mov     ah,3
   mov     bh,0
   int     10h
   mov     dh,24
   mov     dl,0
   mov     ah,2
   int     10h
   call    cursor_on
   mov     ah,9
   mov     dx,offset pause
   int     21h
   mov     ah,0
   int     16h
   mov     ax,4c00h
   int     21h
dis_play_files   endp
;------------------------------------------------
drive_number    proc    near
   push    ax
   push    dx
   mov     al,00
   mov     ah,19h
   int     21h
   mov     dx,ax
   push    ax
   add     dx,01
   call    drive_space
   pop     ax
   cmp     al,1
   je      drive_b
   cmp     al,0
   je      drive_a
   cmp     al,2
   je      drive_c
drive_a:
   call    put_there
   lea     dx,prompt_a
   print_word
   jmp     exit_here
drive_b:
   call    put_there
   lea     dx,prompt_b
   print_word
   jmp     exit_here
drive_c:
   call    put_there
   lea     dx,prompt_c
   print_word
   jmp     exit_here
exit_here:
   pop     dx
   pop     ax
   ret
drive_number    endp
;-------------------------------------
print_line      proc    near
        mov     ah,9
        mov     al,0cdh
        mov     bh,0
        mov     bl,7
        mov     cx,80
        int     10h
        ret
print_line      endp
;-------------------------------------
put_there       proc    near
   call    cursor_off
   mov     ah,2
   mov     bh,0
   mov     dh,0
   mov     dl,1
   int     10h
   ret
put_there       endp
;-------------------------------------
get_file_name   proc    near
   push    cx
   push    si
   push    word ptr cursor_x
   mov     ah,8
   mov     bx,0
   mov     cx,14
loop_b:
   mov     ah,8
   int     10h
   inc     cursor_x
   call    setcursor
   mov     ds:[si],al
   inc     si
   loop    loop_b
   mov     byte ptr ds:[si],0
   pop     word ptr cursor_x
   pop     si
   call    setcursor
   pop     cx
   ret
get_file_name   endp
;-------------------------------------
inc_cursor      proc    near
   push    cx  
   mov     dl,cursor_x
   mov     dh,cursor_y
   mov     tempx,dl
   mov     tempy,dh
   add     dl,15
   cmp     dl,75
   jl      fin
   mov     dl,3
   inc     dh
fin:
   mov     cursor_x,dl
   mov     cursor_y,dh
   mov     dx,0
   call    setcursor
   cmp     disp_flag,0
   jne     set_it
   mov     si,source_path_end
   call    get_file_name
   cmp     byte ptr ds:[si],' '
   ja      set_it
   sub     cursor_x,13
   cmp     cursor_x,3
   jg      leav
   mov     dl,tempx
   mov     cursor_x,dl
   mov     dh,tempy
   mov     cursor_y,dh
leav:
   call    setcursor
   mov     dx,0ffh
set_it:
   pop     cx
   ret
inc_cursor      endp
;-------------------------------------
setcursor      proc    near
   push    ax
   mov     dl,cursor_x
   mov     dh,cursor_y
   mov     ah,2
   int     10h
   pop     ax
   ret
setcursor      endp
;-------------------------------------
printm     proc    near
   push    cx
   mov     dx,080h+30
   mov     bx,dx
   mov     cx,15
loop_a:
   cmp     byte ptr [bx],0
   je      found
   inc     bx
   loop    loop_a
found:
   mov     byte ptr ds:[bx+1],'$'
   print_word
all_fin:
   inc     file_count
   pop     cx
   ret
printm     endp
;-------------------------------------
drive_space     proc    near
        pushall
        push    si
        push    di
        cld
        mov     bx,offset bufspace
        mov     cx,5
flusher:mov     byte ptr [bx],020h
        inc     bx
        loop    flusher
        mov     cx,5
zero:   mov     byte ptr [bx],0
        inc     bx
        loop    zero
        std
        cld
        mov     ah,36h
        mov     dl,0
        int     21h
        mul     cx
        mul     bx
        clc
        xchg    dx,ax
        mov     di,offset bufspace
        add     di,8
        mov     bx,0ah
        std
        call    sg_1a93
        cld
        mov     tempx,1
        mov     tempy,1
        mov     si,offset bufspace+3
        call    sg_1787
        mov     dh,1
        mov     dl,9
        mov     ah,2
        mov     bh,0
        int     10h
        mov     dx,offset tell
        print_word
        pop     di
        pop     si
        popall
        ret
drive_space     endp
;-------------------------------------
sg_1a93 proc    near
backerz:mov     cx,dx
        xor     dx,dx
        div     bx
        xchg    cx,ax
        div     bx
        xchg    dx,ax
        add     al,030h
        stosb
        mov     ax,cx
        or      cx,dx
        jnz     backerz
        ret
sg_1a93 endp
;-------------------------------------
sg_1787 proc    near
        call    sg_179c
agiin:  lodsb
        call    sg_179c
        cmp     al,0
        jz      donit
        call    sg_1795
        jmp     agiin
donit:  ret
sg_1787 endp
;-------------------------------------
sg_1795 proc    near
        push    si
        push    bx
        push    cx
        mov     ah,9
        mov     bh,0
        mov     bl,7
        mov     cx,1
        int     10h
        pop     cx
        pop     bx
        pop     si
        ret
sg_1795 endp
;-------------------------------------
sg_179c proc    near
        push    si
        push    dx
        xor     bh,bh
        mov     ah,2
        mov     dh,tempx
        mov     dl,tempy
        int     10h
        inc     tempy
        pop     dx
        pop     si
        ret
sg_179c endp
;-------------------------------------
convert proc    near
        cld
        mov     cx,7
        mov     bx,offset ascii_str
cl_buf: mov     byte ptr [bx],'$'
        inc     bx
        loop    cl_buf
        mov     si,offset ascii_str
        mov     ah,0
        mov     al,file_count
        mov     bx,10
        mov     cx,0
theloop:mov     dx,0
        div     bx
        push    dx
        inc     cx
        cmp     ax,0
        jne     theloop
poploop:pop     ax
        add     al,'0'
        mov     [si],al
        inc     si
        loop    poploop
        mov     dh,2
        mov     dl,2
        mov     ah,2
        mov     bh,0
        int     10h
        mov     dx,offset ascii_str
        mov     ah,9
        int     21h
        mov     dh,2
        mov     dl,5
        mov     ah,2
        mov     bh,0
        int     10h
        lea     dx,nfile
        mov     ah,9
        int     21h
        ret
convert endp
;-------------------------------------
code_seg        ends

