
code_seg        segment
        assume  cs:code_seg
        org     100h
        jmp     load_keeper
;----------------------------------
port_add                dw      0
seg_mt                  dw      0
bottom_row              db      12
top_row                 db      11
full_flag               dw      0
old_head                dw      0
disable_flg             db      0
;----------------------------------
;####################################################################
old_keyboard_int       equ 5ch
;####################################################################
keeper  proc    near
        push    ax
        push    bx
        push    cx
        push    dx
        push    di
        push    si
        push    ds
        push    es
        pushf
        call    far cs:old_keyboard_int
        cli
        mov     bx,40h
        mov     ds,bx
        mov     bx,ds:1ch
        cmp     bx,ds:1ah
        je      bye
        mov     dx,ds:1ah
        sub     dx,2
        cmp     dx,1eh
        jnb     nowrap
        mov     dx,3eh
        sub     dx,2
nowrap: cmp     dx,ds:1ch
        jne     notfull
        cs:
        cmp     full_flag,1
        je      bye
        cs:
        mov     full_flag,1
        jmp     chk
notfull:cs:
        mov     full_flag,0
chk:    cs:
        mov     dx,old_head
        cmp     dx,ds:1ah
        jne     cont
        cs:
        mov     old_head,0
bye:    jmp     out@
cont:   mov     dx,ds:1ah
        cs:
        mov     old_head,dx
subt:   sub     bx,2
        cmp     bx,1eh
        jnb     no_wrap
        mov     bx,3eh
        sub     bx,2
no_wrap:mov     dx,[bx]
        call    chk_vidio 
;--------------------------
quiter: cmp     dx,7b00h
        jne     upcurs
        not     cs:disable_flg
        jmp     out2@
;--------------------------
upcurs: cmp     dx,7800h
        jne     downcur
        mov     cs:top_row,0
        mov     cs:bottom_row,13
        jmp     out@
;--------------------------
downcur:cmp     dx,7900h
        jne     cursoff
        mov     cs:top_row,11
        mov     cs:bottom_row,12
        jmp     out@
;--------------------------
cursoff:cmp     dx,7a00h
        jne     out@
        mov     cs:top_row,15
        mov     cs:bottom_row,15
;--------------------------
out@:   cmp     cs:disable_flg,0
        jne     out2@
;--------------------------
        mov     dx,cs:port_add
        mov     al,10
        out     dx,al
        mov     al,cs:top_row
        inc     dx
        out     dx,al
        mov     al,11
        dec     dx
        out     dx,al
        mov     al,cs:bottom_row
        inc     dx
        out     dx,al
out2@:  sti
        pop     es
        pop     ds
        pop     si
        pop     di
        pop     dx
        pop     cx
        pop     bx
        pop     ax
        iret
keeper  endp
;-------------------------------------
chk_vidio       proc    near
        push    dx
        mov     ah,15
        int     10h
        cmp     al,7
        je      out_vid
        mov     cs:seg_mt,0b800h
        mov     cs:port_add,03d4h
        jmp     v_out
out_vid:mov     cs:seg_mt,0b000h
        mov     cs:port_add,03b4h
v_out:  pop     dx
        ret
chk_vidio       endp
;-------------------------------------------
load_keeper       proc    near
         mov ax,3509h                   ;9 is keyboard interrupt
         int 21h                        ;get old int vector
         mov word ptr cs:[old_keyboard_int],bx    ;and save it
         mov word ptr cs:[old_keyboard_int+2],es

         mov dx,offset keeper
         mov ax,2509h                   ;set new int vector with ds:dx
         int 21h    

        push    ds
        mov     ax,40h
        mov     ds,ax
        mov     bx,1eh
        mov     ds:1ah,bx
        mov     ds:1ch,bx
        pop     ds

        call    note

        mov     dx,offset load_keeper
        int     27h
load_keeper         endp
;----------------------------------------------
note    proc    near
        mov     ah,9
        mov     dx,offset message
        int     21h
        ret
note    endp
;----------------------------------------------
message db      'chgcurs.com - installed.',0dh,0ah
        db      'b/c software',0dh,0ah
        db      'copyright 1990',0dh,0ah
        db      'william cravener',0dh,0ah
        db      '520 north stateline rd.',0dh,0ah
        db      'sharon | pa. 16146',0dh,0ah,0dh,0ah
        db      'alt-1 = cursor up',0dh,0ah
        db      'alt-2 = cursor down',0dh,0ah
        db      'alt-3 = cursor off',0dh,0ah,'$'
        db      'alt-4 = disable chgcurs',0dh,0ah,'$'
;----------------------------------------------
code_seg        ends

