pushall macro
        push    ax
        push    bx
        push    cx
        push    dx
        push    si
        #em
popall  macro
        pop     si
        pop     dx
        pop     cx
        pop     bx
        pop     ax
        #em
;QREAD.asm - program to display ascii files
;   allowing the display to be displayed backward
 
code    segment
        assume  cs:code
        org     100h
        jmp     mainq
;-----------------------------------------------------------------------------
titl            db      0dh,0ah,' ---  QREAD.COM  ---',0dh,0ah,0DH,0AH,'$'
mes1            db      '      ',019h,' - PgDn = forward | ',018h
                db      ' - PgUp = backward | Home | End | <Esc> = exit      $'
fname           db      50 dup (0)
nofile          db      ' Syntax is QREAD/? [filename.ext]',0DH,0AH,0dh,0ah
                db      ' Where - ? = a letter - B or b - R or r - Y or y',0dh,0ah,0dh,0ah
                db      ' CGA - this sets text color to Blue Red or Yellow ',0dh,0ah
                db      ' Monochrome - this sets text color to Underlined - Normal or Intense',0dh,0ah
                db      ' The default colors are White on blue for CGA - Normal for Monochrome',0dh,0ah,'$'
notfnd          db      ' - Not Found ',0DH,0AH,'$'
error           db      '  ERROR !',0DH,0AH,'$'
filesz          dw      0
bigfile         db      ' - is to Large',0DH,0AH,'$'
readms          db      0dh,0ah,'Reading in - $'
reader          db      '  Disk Read Error ',0DH,0AH,'$'
thanks          db      0dh,0ah,' Thank You !',0dh,0ah
                db      ' for using QREAD.COM',0dh,0ah
                db      ' B/C Software',0dh,0ah
                db      ' Copyright (C) 1989',0dh,0ah
                db      ' William Cravener',0dh,0ah
                db      ' 520 North Stateline Rd.',0dh,0ah
                db      ' Sharon | Pa. 16146',0dh,0ah,'$'
seg_mt          dw      0
stat            dw      0
endof_file      dw      0
countline       db      0
beenthere1      db      0
beenthere2      db      0
colorflag       db      0
color           db      0
color2          db      0
tempt           db      0
temps           db      0
tempx           db      0
tempy           db      0
storer          db      0
mem_p           dw      0
topadd          dw      0
setup           dw      0
;-----------------------------------------------------------------------------
mainq   proc    near
        call    chk_vidio
        call    cursor_off
        mov     dx,offset titl
        call    writem
        call    get_file
        jnz     main1
        mov     dx,offset nofile
        call    writem
        jmp     doneq4
main1:  mov     dx,offset fname
        mov     si,dx
        call    openfl
        jc      bad
        jmp     main2
bad:    call    string0
        mov     dx,offset notfnd
        call    writem
        jmp     doneq2
main2:  mov     bx,ax
        call    fsize
        jz      main3
mainbg: call    closefl
        call    string0
        mov     dx,offset bigfile
        call    writem
        jmp     doneq2
main3:  push    si
        mov     si,offset buffr
        add     si,ax
        mov     byte ptr [si],1ah
        mov     endof_file,si
        pop     si
        mov     di,offset buffr
        mov     cx,0feffh
        sub     cx,di
        cmp     cx,ax
        jc      mainbg
        call    readin
        jc      doneq3
        mov     setup,0600h
        call    clears
        call    lineout
        mov     dh,24
        mov     dl,0
        mov     si,offset mes1
        call    printstr
        sub     dx,dx
        call    cursor
        mov     si,offset buffr
        sub     si,1
        mov     byte ptr [si],0afh
        mov     bx,offset buffr 
        sub     bx,1
        mov     mem_p,bx
        mov     topadd,bx
        mov     al,0
        mov     tempx,0
        mov     countline,1
        call    foward1
doneq: 
        mov     setup,0600h
        call    clears
doneq4: mov     dx,offset thanks
        call    writem
        mov     ah,1
        mov     ch,11
        mov     cl,12
        int     10h
        mov     ax,4c00h
        int     21h
doneq2:
        call    kill_time
        jmp     doneq
doneq3:
        mov     dx,offset error
        call    writem
        call    kill_time
        jmp     doneq
mainq   endp
;------------------------------------------end of mainq
show_it proc    near
        cmp     ah,51h
        je      foward
        cmp     ah,49h
        je      backwd
        cmp     ah,50h
        je      foward2
        cmp     ah,48h
        je      backwd2
        cmp     ah,47h
        je      homer
        cmp     ah,4fh
        je      toend
        call    boop
        jmp     shomore
backwd: cmp     beenthere1,0
        jnz     shobel
        call    reverse
        mov     beenthere2,0
        jmp     foward1
backwd2:cmp     beenthere1,0
        jnz     shobel
        call    reverse2
        mov     beenthere2,0
        jmp     foward1
foward2:cmp     beenthere2,0
        jnz     shobel
        call    forwd
        mov     beenthere1,0
        jmp     foward1
foward: cmp     beenthere2,0
        jnz     shobel
        mov     countline,2
        mov     beenthere1,0
        jmp     foward1
shobel: call    boop
        jmp     shomore     
homer:  cmp     beenthere1,0
        jne     shobel
        mov     si,offset buffr
        sub     si,1
        mov     mem_p,si
        mov     beenthere1,1
        mov     beenthere2,0
        jmp     foward1
toend:  cmp     beenthere2,0
        jne     shobel
        mov     si,endof_file
        mov     topadd,si
        call    reverse
        mov     beenthere2,1
        mov     beenthere1,0
        jmp     foward1
show_it endp
;-----------------------------------------
foward1         proc    near
        mov     bx,mem_p
        mov     al,[bx]
        cmp     al,1ah
        jnz     showok
        mov     beenthere2,1
        jmp     shobel
showok: mov     topadd,bx
        mov     tempx,0
        mov     tempy,0
        mov     cx,23
pagelp: push    cx
        sub     cx,cx
        mov     dl,1ah
        mov     dh,0ah
linelp: inc     bx
        inc     cx
        mov     al,[bx]
        cmp     al,dl
        jz      showln
        cmp     al,dh
        jnz     linelp
showln: push    bx
        mov     dx,mem_p
        inc     dx
        mov     si,dx
        call    print
        pop     bx
        mov     mem_p,bx
        cmp     al,1ah
        pop     cx
        loopnz  pagelp
shomore:sub     dx,dx
        call    cursor_off
        mov     ah,0
        int     16h
        cmp     ah,1
        jz      x_it
        jmp     short show_it
x_it:   ret
foward1 endp
;------------------------------------------
read_file       proc    near
        push    ax
        push    bx
        mov     si,dx
backlp: 
        mov     al,[si]
        mov     ah,0eh
        mov     bh,0
        int     10h
        inc     si
        loop    backlp
        pop     bx
        pop     ax
        ret
read_file       endp
;------------------------------------------- 
get_file proc   near
        mov     si,80h
        mov     cl,[si]
        cmp     cl,0
        jz      gt_ex
        inc     si
        mov     cl,[si]
        cmp     cl,2fh
        jnz     nochg
        inc     si
        mov     cl,[si]
        cmp     cl,42h
        je      makblue
        cmp     cl,62h
        je      makblue
        cmp     cl,52h
        je      makred
        cmp     cl,72h
        je      makred
        mov     color,14
        jmp     short here
makblue:mov     color,9
        jmp     short here
makred: mov     color,4
here:   mov     si,80h
        mov     cl,[si]
        dec     cl
        dec     cl
        dec     cl
        sub     ch,ch
        inc     si
        inc     si
        inc     si
        inc     si
donow:  mov     di,offset fname
        cld
rep     movsb
        mov     al,0
        stosb
gt_ex:  ret
nochg:
        cmp     seg_mt,0b800h
        jne     overit
        mov     ah,0bh
        mov     bh,0
        mov     bl,1
        int     10h
overit: mov     si,80h
        mov     cl,[si]
        dec     cl
        sub     ch,ch
        inc     si
        inc     si
        jmp     short donow
get_file        endp
;------------------------------------------- 
lineout proc    near
        mov     cx,80
        mov     dh,23
        sub     dl,dl
lloop:  call    cursor
        mov     al,0cdh
        call    dirout
        inc     dl
        loop    lloop
        ret
lineout endp
;------------------------------------------- 
readin  proc    near
        mov     dx,offset readms
        call    writem
        call    string0
        mov     cx,filesz
        mov     dx,offset buffr
        call    readfl
        jnc     reda
        mov     dx,offset reader
        call    writem
        jmp     redx
reda:   call    closefl
redx:   ret
readin  endp
;------------------------------------------- 
cursor  proc    near
        push    ax
        push    bx
        mov     ah,2
        mov     bh,0
        int     10h
        pop     bx
        pop     ax
        ret
cursor  endp
;------------------------------------------- 
clears  proc    near
        push    ax
        push    bx
        push    cx
        sub     cx,cx
        mov     dh,24
        mov     dl,79
        mov     ax,setup
        mov     bh,color
        int     10h
        pop     cx
        pop     bx
        pop     ax
        ret
clears  endp
;------------------------------------------- 
openfl  proc    near
        mov     ax,03d00h
        int     21h
        ret
openfl  endp
;------------------------------------------- 
fsize   proc    near
        push    dx
        push    cx
        sub     cx,cx
        sub     dx,dx
        mov     ax,04202h
        int     21h
        cmp     dx,0
        jnz     fszex
        push    ax
        mov     filesz,ax
        mov     ax,04200h
        int     21h
        pop     ax
fszex:  pop     cx
        pop     dx
        ret
fsize   endp
;------------------------------------------- 
closefl proc    near
        mov     ax,03e00h
        int     21h
        ret
closefl endp
;------------------------------------------- 
readfl  proc    near
        mov     ax,03f00h
        int     21h
        ret
readfl  endp
;------------------------------------------- 
writem  proc    near
        push    ax
        mov     ah,9
        int     21h
        pop     ax
        ret
writem  endp
;------------------------------------------- 
dirout  proc    near
        push    ax
        push    bx
        push    cx
        push    dx
        mov     ah,9
        mov     bh,0
        mov     bl,color
        mov     cx,1
        int     10h
        pop     dx
        pop     cx
        pop     bx
        pop     ax
        ret
dirout  endp
;------------------------------------------- 
string0 proc    near
        lodsb
        cmp     al,0
        jz      strex
        mov     ah,0eh
        mov     bh,0
        int     10h
        jmp     string0
strex:  ret
string0 endp
;------------------------------------------- 
keyin   proc    near
        mov     ah,0
        int     16h
        ret
keyin   endp
;------------------------------------------- 
print       proc    near
        push    ax
        push    bx
        push    dx
        push    di
        push    es
        xor     di,di
        xor     bx,bx
        mov     ax,seg_mt
        mov     es,ax
        mov     dh,tempx
        mov     dl,tempy
        mov     al,dh
        mov     dh,0
        mov     di,dx
        mov     bl,80
        mul     bx
        add     di,ax
        shl     di,1
        mov     al,color
        mov     storer,al
        xor     bp,bp
        mov     dx,stat
        cli
nexty:
        inc     bp
        mov     al,[si]
        cmp     al,1ah
        je      all_finn
        cmp     al,0dh
        je      allfinn
        mov     ah,storer
        cmp     colorflag,1
        jne     nocolor
        push    ax
waith:  in      al,dx
        test    al,1
        jnz     waith
waitl:  in      al,dx
        test    al,1
        jz      waitl
        pop     ax
nocolor:mov     es:[di],al
        inc     di
        cmp     colorflag,1
        jne     noclor2
        push    ax
waith2: in      al,dx
        test    al,1
        jnz     waith2
waitl2: in      al,dx
        test    al,1
        jz      waitl2
        pop     ax
noclor2:mov     es:[di],ah
        inc     di
        inc     si
        loop    nexty
all_finn:
        sti
        inc     tempx
        pop     es
        pop     di
        pop     dx
        pop     bx
        pop     ax
        ret
allfinn:cmp     bp,79
        jge     all_finn
        mov     cx,81
        sub     cx,bp
        mov     al,20h
        mov     ah,storer
loopline:
        cmp     colorflag,1
        jne     noclor3
        push    ax
w_hi1:  in      al,dx
        test    al,1
        jnz     w_hi1
w_hi2:  in      al,dx
        test    al,1
        jz      w_hi2
        pop     ax
noclor3:mov     es:[di],al
        inc     di
        cmp     colorflag,1
        jne     noclor4
        push    ax
w_hi3:  in      al,dx
        test    al,1
        jnz     w_hi3
w_hi4:  in      al,dx
        test    al,1
        jz      w_hi4
        pop     ax
noclor4:mov     es:[di],ah
        inc     di
        loop    loopline
        jmp     short all_finn
print       endp
;------------------------------------------- 
cursor_off      proc    near
   mov            dx,3b4h   ; now remove mono cursor
   mov            al,0ah
   out            dx,al
   mov            dx,3b5h
   mov            al,0fh
   out            dx,al
   mov            dx,3d4h   ; now remove color cursor
   mov            al,0ah
   out            dx,al
   mov            dx,3d5h
   mov            al,0fh
   out            dx,al
   ret
cursor_off      endp
;------------------------------------------- 
printstr       proc    near
   pushall
backerv: 
   mov     ah,2
   mov     bh,0
   int     10h
   mov     ah,9
   mov     al,[si]
   cmp     al,'$'
   je      atlast
   mov     bh,0
   mov     bl,color2
   mov     cx,1
   int     10h
   inc     si
   inc     dl
   jmp     backerv
atlast:
   popall
   ret
printstr       endp
;------------------------------------------- 
reverse proc    near
        mov     si,topadd
        mov     cx,24
        std
rev1:   lodsb
        cmp     al,0afh
        je      setup1
        cmp     al,0ah
        jne     rev1
        loop    rev1
setup2: inc     si
        mov     mem_p,si
rev_ex: cld
        ret
setup1: mov     countline,1
        mov     beenthere1,1
        jmp     short setup2
reverse endp
;------------------------------------------- 
reverse2 proc    near
        mov     si,topadd
        mov     cx,2
        std
rev12:  lodsb
        cmp     al,0afh
        je      setup6
        cmp     al,0ah
        jne     rev12
        loop    rev12
setup7: inc     si
        mov     mem_p,si
rev_ex2:cld
        ret
setup6: mov     countline,1
        mov     beenthere1,1
        jmp     short setup7
reverse2 endp
;------------------------------------------- 
forwd proc    near
        mov     si,topadd
        mov     cl,countline
        cld
revx:   lodsb
        cmp     al,1ah
        je      setupx
        cmp     al,0ah
        jne     revx
        loop    revx
setupx: dec     si
        mov     mem_p,si
        mov     countline,2
        ret
setupt: mov     beenthere2,1
        jmp     short setupx
forwd endp
;------------------------------------------- 
chk_vidio       proc    near
        mov     ah,15
        int     10h
        cmp     al,7
        je      out_vid
        mov     seg_mt,0b800h
        mov     color,1fh
        mov     color2,4eh
        mov     stat,03dah
        mov     colorflag,1
        jmp     v_out
out_vid:
        mov     seg_mt,0b000h
        mov     color,7
        mov     color2,070h
        mov     colorflag,0
        mov     stat,03bah
v_out:  ret
chk_vidio       endp
;------------------------------------------- 
boop          proc          near
        push         ax
        push         bx
        push         cx
        in           al,61h
        push         ax
        mov          bx,2818
        call         warbcom
        mov          cx,2b4bh
delay7:
        loop         delay7
        pop          ax
        out          61h,al
        pop          cx
        pop          bx
        pop          ax
        ret
boop          endp
;-------------------------------------------
warbcom          proc          near
          mov          al,0b6h
          out          43h,al
          mov          ax,bx
          out          42h,al
          mov          al,ah
          out          42h,al
          in          al,61h
          or          al,03
          out          61h,al
          ret
warbcom          endp
;------------------------------------------- 
kill_time       proc    near
      pushall
      mov     ah,0
      int     01ah
      add     dx,100
      mov     bx,dx
delay_it:
      int     01ah
      cmp     dx,bx
      jne     delay_it
      popall
      ret
kill_time       endp
;------------------------------------------- 
datbuff db      4004 dup (0)
buffr   db      0
code_seg        ends
        end     mainq

