comment 

CMOS data dump program (public domain)

 Location     Purpose
 00           The count of seconds in binary coded decimal.  Minutes, hours,
              day of month, month and year are BCD also.
 02           The count of minutes
 04           The hour
 07           The day of month
 08           The month
 09           The last two digits of the year
 0a           7       = 1 update in progress
              6 - 4   = divider identifying the time based frequency to use
              3 - 0   = rate selection bits that define output
                        frequency and periodic interrupt rate

 0b           7       = 0 run (update cycle)
                      = 1 abort any update cycle in progress
              6       = 1 enable periodic interrupt
              5       = 1 enable alarm interrupt
              4       = 1 enable update-ended interrupt
              3       = 1 enable square wave frequency set in status reg a
              2       = 1 calendar is in binary format
                      = 0 calendar is bcd format
              1       = 1 24-hour clock
                      = 0 12-hour clock
              0       = 1 enable daylight savings time

 0c           7 - 4   = irqf, pf, af, and uf flags - only valid if
                        alarm interrupt, update-ended interrupt, or
                        periodic interrupt is enabled
              3 - 0     reserved

 0d           7       = 1 real time clock has power
              6 - 0     reserved

 0e           7       = 1 real time clock lost power
              6       = 1 cmos checksum bad
              5       = 1 invalid configuration info found at POST
              4       = 1 memory size compare error detected at POST
              3       = 1 fixed disk or adapter fails init
              2       = 1 cmos time found invalid
              1       = 1 reserved
              0       = 1 reserved

 0f           7 - 0   = 0 power on or soft reset
                      = 1 memory size test pass
                      = 2 memory test pass
                      = 3 memory test fail
                      = 4 post end - boot system
                      = 5 jump dword pointer (40:67) with EOI
                      = 6 protected mode tests pass
                      = 7 protected mode tests fail
                      = 8 memory size fail
                      = 9 int 15h block mode
                      = 10 jump dword pointer (40:67) without EOI
                      = 11 used by 386 (I think OS/2 and windows 3.0
                           use this to reload system from disk)

 10           The first digit is the type of drive A: and the second digit is
              the drive B: type.  (0 = not installed, 1 = 360K, 2 = 1.2M, 3 =
              720K, 4 = 1.44M)
 12           These are hex digits that indicate the drive type for each of the
              two fixed disks in the system (0 = not installed, 1 = type 1,
              ..., E = type 14).  If the digit is F (type 15 is reserved by
              IBM), then location 19 indicates the drive type for fixed disk 0
              and location 1A indicates the drive type for fixed disk 1.
 15             base memory in 1k, low byte
 16             base memory in 1k, high byte
 17             expansion memory in 1k, low byte
 18             expansion memory in 1k, high byte
 19             (see above for location 12)
 1a             (see above for location 12)
 1b - 2d        reserved (used in PS/2 machines for SLOT ids, pos register data)

 2e             high byte of checksum for locations 10h to 2dh
 2f             low byte of checksum for locations 10h to 2dh
 30             low byte of actual expansion memory size
 31             high byte of actual expansion memory size
 32             century (in bcd)
 33             information flag
 34 to 3f       reserved (used in PS/2 for power on password/checksum storage)

 Any locations subsequent to 3f (if available) presumably have meaning only for
 the particular machine that uses them.

 


code            segment
                assume  cs:code
                org     100h

entry:          call    crlf
                call    space
                mov     cx,16

header:         call    space
                call    space
                call    space
                mov     dx,16
                sub     dx,cx
                call    outdigit
                loop    header

                call    crlf
                sub     ax,ax
                mov     cl,4

nextbyte:       push    ax
                cmp     ax,128
                je      alldone
                call    cmosread
                mov     dx,ax
                pop     ax
                test    ax,0fh
                jnz     spaces
                call    crlf
                push    ax
                push    dx
                mov     dx,ax
                shr     dl,cl
                call    outdigit
                pop     dx
                pop     ax

spaces:         call    space
                call    space
                call    outhex
                inc     ax
                jmp     short nextbyte

alldone:        call    crlf
                int     20h

cmosread        proc    near
                out     70h,al
                jmp     short $+2
                in      al,71h
                ret
cmosread        endp

cmoswrite       proc    near
                out     70h,al
                jmp     short $+2
                mov     al,ah
                out     71h,al
                ret
cmoswrite       endp

crlf            proc    near
                push    ax
                push    dx
                mov     ah,2
                mov     dl,13
                int     21h
                mov     dl,10
                int     21h
                pop     dx
                pop     ax
                ret
crlf            endp

space           proc    near
                push    ax
                push    dx
                mov     ah,2
                mov     dl,' '
                int     21h
                pop     dx
                pop     ax
                ret
space           endp

outhex          proc    near
                push    ax
                push    dx
                and     dl,0f0h
                shr     dl,cl
                call    outdigit
                pop     dx
                and     dl,0fh
                call    outdigit
                pop     ax
                ret
outhex          endp

outdigit        proc    near
                mov     ah,2
                cmp     dl,9
                ja      letter
                add     dl,'0'
                jmp     short od_exit
letter:         add     dl,'A' - 10
od_exit:        int     21h
                ret
outdigit        endp

code            ends
                end     entry
