create procedure sp_vbColCount @Table varchar(30), @Owner varchar(30)
as 
 select count(col.name) 
   from sysobjects obj, syscolumns col, sysusers u 
  where obj.name = @Table
    and u.name = @Owner
    and (obj.uid = u.uid)
    and (obj.id = col.id)


create procedure sp_vbColDef @Table varchar(30), @Owner varchar(30)
as 
 select substring(col.name,1, 30), col.type, col.length 
   from sysobjects obj, syscolumns col, sysusers u 
  where obj.name = @Table
    and u.name = @Owner
    and (obj.uid = u.uid)
    and (obj.id = col.id)
  order by col.colid


create procedure sp_vbDBUsers
as 
  select name from sysusers 
   where ((suid != 0) and 
          (suid != -1) and
          (name != 'public'))


create procedure sp_vbReturnSelectables
as
create table #temp
(
Owner char(30),
TableName char(30),
Type char(2),
id int
)

/*  Get tables/views granted select to public or current user  */
insert into #temp
    select user_name(o.uid), o.name, o.type, o.id
        from sysobjects o, sysprotects p
        where p.protecttype = 205 and
              p.action = 193 and
              ( user_name(p.uid) = user_name() or p.uid = 0 ) and
              p.id = o.id and
              o.type IN ('U ','V ','S ')

/*  Get tables/views owned by user  */
insert into #temp
    select user_name(o.uid), o.name, o.type, o.id
        from sysobjects o
        where user_name(o.uid) = user_name() and
            o.type IN ('U ','V ','S ')

/*  Display the results after dropping revoked tables/views  */
select distinct Owner=rtrim(Owner), TableName=rtrim(TableName), Type
    from #temp
    where id not in (select p.id
                     from sysprotects p
                     where p.protecttype = 206 and
                           p.action = 193 and
                           convert(tinyint,substring(isnull(p.columns,0x1),1,1)) & 0x1 = 0x1 and
                           user_name(p.uid) = user_name() )
    order by 1, 2

drop table #temp


create procedure sp_vbUserSelectables @User varchar(30)
as
create table #temp
(
TableName char(30),
Type char(2),
id int
)

/*  Get tables/views granted select to public or current user  */
insert into #temp
    select o.name, o.type, o.id
        from sysobjects o, sysprotects p
        where (p.protecttype = 205) and
              (p.action = 193) and
              ((user_name(p.uid) = user_name()) or 
               (p.uid = 0)) and
              (o.uid = user_id(@User)) and
              (p.id = o.id) and
              (o.type IN ('U ','V ','S '))

/*  Get tables/views owned by user  */
if (select user_name()) = @User 
begin
  insert into #temp
    select o.name, o.type, o.id
        from sysobjects o
        where user_name(o.uid) = user_name() and
            o.type IN ('U ','V ','S ')
end

/*  Display the results after dropping revoked tables/views  */
select distinct TableName=rtrim(TableName), Type
    from #temp
    where id not in (select p.id
                     from sysprotects p
                     where p.protecttype = 206 and
                           p.action = 193 and
                           convert(tinyint,substring(isnull(p.columns,0x1),1,1)) & 0x1 = 0x1 and
                           user_name(p.uid) = user_name() )
    order by 1, 2

drop table #temp
