Rem Global declarations for Thunder to DB-Library translation dll.
Rem Used by all apps linking with the WBSQL DLL.

Rem Global return values for all RETCODE type functions
Global Const SUCCEED% = 1
Global Const FAIL% = 0

Rem return values permitted in error handlers
Global Const INTEXIT% = 0
Global Const INTCONTINUE% = 1
Global Const INTCANCEL% = 2

Global Const MOREROWS = -1
Global Const NOMOREROWS = -2
Global Const REGROW = -1
Global Const BUFFULL = -3

Rem Status code for dbresults(). Possible return values are
Rem SUCCEED, FAIL, and NO_MORE_RESULTS.

Global Const NOMORERESULTS = 2



Rem option values permitted in option setting/querying/clearing
Rem used by SqlSetOpt%(), SqlIsOpt%(), and SqlClrOpt%().

Global Const SQLBUFFER% = 0
Global Const SQLROWCOUNT% = 2
Global Const SQLSTAT% = 3
Global Const SQLTEXTLIMIT% = 4
Global Const SQLTEXTSIZE% = 5
Global Const SQLARITHABORT% = 6
Global Const SQLARITHIGNORE% = 7
Global Const SQLNOAUTOFREE% = 8
Global Const SQLNOCOUNT% = 9
Global Const SQLNOEXEC% = 10
Global Const SQLPARSEONLY% = 11
Global Const SQLSHOWPLAN% = 12
Global Const SQLSTORPROCID% = 13

Rem Data type token values.  Used for datatype determination for a column.

Global Const SQLTEXT% = &H23
Global Const SQLARRAY% = &H24
Global Const SQLVARBINARY% = &H25
Global Const SQLINTN% = &H26
Global Const SQLVARCHAR% = &H27
Global Const SQLBINARY% = &H2D
Global Const SQLIMAGE% = &H22
Global Const SQLCHAR% = &H2F
Global Const SQLINT1% = &H30
Global Const SQLBIT% = &H32
Global Const SQLINT2% = &H34
Global Const SQLINT4% = &H38
Global Const SQLMONEY% = &H3C
Global Const SQLDATETIME% = &H3D
Global Const SQLFLT8% = &H3E
Global Const SQLFLTN% = &H6D
Global Const SQLMONEYN% = &H6E
Global Const SQLDATETIMN% = &H6F
Global Const SQLAOPCNT% = &H4B
Global Const SQLAOPSUM% = &H4D
Global Const SQLAOPAVG% = &H4F
Global Const SQLAOPMIN% = &H51
Global Const SQLAOPMAX% = &H52
Global Const SQLAOPANY% = &H53
Global Const SQLAOPNOOP% = &H56



Rem error numbers BSQL error codes that are passed to local error
Rem handler

Global Const SQLEMEM% = 10000
Global Const SQLENULL% = 10001
Global Const SQLENLOG% = 10002
Global Const SQLEPWD% = 10003
Global Const SQLECONN% = 10004
Global Const SQLEDDNE% = 10005
Global Const SQLNULLO% = 10006
Global Const SQLESMSG% = 10007
Global Const SQLEBTOK% = 10008
Global Const SQLENSPE% = 10009
Global Const SQLEREAD% = 10010
Global Const SQLECNOR% = 10011
Global Const SQLETSIT% = 10012
Global Const SQLEPARM% = 10013
Global Const SQLEAUTN% = 10014
Global Const SQLECOFL% = 10015
Global Const SQLERDCN% = 10016
Global Const SQLEICN% = 10017
Global Const SQLECLOS% = 10018
Global Const SQLENTXT% = 10019
Global Const SQLEDNTI% = 10020
Global Const SQLETMTD% = 10021
Global Const SQLEASEC% = 10022
Global Const SQLENTLL% = 10023
Global Const SQLETIME% = 10024
Global Const SQLEWRIT% = 10025
Global Const SQLEMODE% = 10026
Global Const SQLEOOB% = 10027
Global Const SQLEITIM% = 10028
Global Const SQLEDBPS% = 10029
Global Const SQLEIOPT% = 10030
Global Const SQLEASNL% = 10031
Global Const SQLEASUL% = 10032
Global Const SQLENPRM% = 10033
Global Const SQLEDBOP% = 10034
Global Const SQLENSIP% = 10035
Global Const SQLECNULL% = 10036
Global Const SQLESEOF% = 10037
Global Const SQLERPND% = 10038
Global Const SQLECSYN% = 10039
Global Const SQLENONET% = 10040
Global Const SQLEBTYP% = 10041
Global Const SQLEABNC% = 10042
Global Const SQLEABMT% = 10043
Global Const SQLEABNP% = 10044
Global Const SQLEBNCR% = 10045
Global Const SQLEAAMT% = 10046
Global Const SQLENXID% = 10047

Rem The severity levels are defined here for error handlers

Global Const EXINFO% = 1
Global Const EXUSER% = 2
Global Const EXNONFATAL% = 3
Global Const EXCONVERSION% = 4
Global Const EXSERVER% = 5
Global Const EXTIME% = 6
Global Const EXPROGRAM% = 7
Global Const EXRESOURCE% = 8
Global Const EXCOMM% = 9
Global Const EXFATAL% = 10
Global Const EXCONSISTENCY% = 11

Rem Length of text timestamp and text pointer
Global Const SQLTXTSLEN% = 8          ' length of text timestamp
Global Const SQLTXPLEN% = 16          ' length of text pointer

Global Const OFF_SELECT% = &H16D
Global Const OFF_FROM% = &H14F
Global Const OFF_ORDER% = &H165
Global Const OFF_COMPUTE% = &H139
Global Const OFF_TABLE% = &H173
Global Const OFF_PROCEDURE% = &H16A
Global Const OFF_STATEMENT% = &H1CB
Global Const OFF_PARAM% = &H1C4
Global Const OFF_EXEC% = &H12C

Rem Bulk Copy Definitions (bcp)

Global Const DBIN% = 1              ' transfer from client to server
Global Const DBOUT% = 2            ' transfer from server to client

Global Const BCPMAXERRS% = 1        ' SqlBcpControl parameter
Global Const BCPFIRST% = 2          ' SqlBcpControl parameter
Global Const BCPLAST% = 3           ' SqlBcpControl parameter
Global Const BCPBATCH% = 4          ' SqlBcpControl parameter

Rem User defined data type for SqlGetColumnInfo
Type ColumnData
   ColType As Integer
   ColLen As Long
   ColName As String * 30
   ColSqlType As String * 30
End Type

Rem User defined data type for SqlGetAltColInfo
Type AltColumnData
   ColID As Integer
   DataType As Integer
   MaxLen As Long
   AggType As Integer
   AggOpName As String * 30
End Type

Rem User defined data type for SqlBcpColumnFormat
Type BcpColData
    FType As Integer
    FPLen As Integer
    fColLen As Long
    FTerm As String * 30
    FTLen As Integer
    TCol As Integer
End Type

Rem Function/Sub declarations for Thunder App Global module
Declare Function SqlInit Lib "VBSQL.VBX" () As String
Declare Sub SqlWinExit Lib "VBSQL.VBX" ()
Declare Function SqlLogin Lib "VBSQL.VBX" () As Integer
Declare Function SqlSetLUser Lib "VBSQL.VBX" (ByVal Login As Integer, USER As String) As Integer
Declare Function SqlSetLPwd Lib "VBSQL.VBX" (ByVal Login As Integer, USER As String) As Integer
Declare Function SqlSetLApp Lib "VBSQL.VBX" (ByVal Login As Integer, USER As String) As Integer
Declare Function SqlSetLHost Lib "VBSQL.VBX" (ByVal Login As Integer, USER As String) As Integer
Declare Function SqlOpen Lib "VBSQL.VBX" (ByVal Login As Integer, SERVER As String) As Integer
Declare Sub SqlClose Lib "VBSQL.VBX" (ByVal SqlConn As Integer)
Declare Sub SqlFreeLogin Lib "VBSQL.VBX" (ByVal Login As Integer)
Declare Function SqlCmd Lib "VBSQL.VBX" (ByVal SqlConn As Integer, Cmd As String) As Integer
Declare Function SqlExec Lib "VBSQL.VBX" (ByVal SqlConn As Integer) As Integer
Declare Function SqlResults Lib "VBSQL.VBX" (ByVal SqlConn As Integer) As Integer
Declare Function SqlNextRow Lib "VBSQL.VBX" (ByVal SqlConn As Integer) As Integer
Declare Function SqlNumCols Lib "VBSQL.VBX" (ByVal SqlConn As Integer) As Integer
Declare Function SqlColName Lib "VBSQL.VBX" (ByVal SqlConn As Integer, ByVal Column As Integer) As String
Declare Function SqlColType Lib "VBSQL.VBX" (ByVal SqlConn As Integer, ByVal Column As Integer) As Integer
Declare Function SqlColLen Lib "VBSQL.VBX" (ByVal SqlConn As Integer, ByVal Column As Integer) As Integer
Declare Function SqlDatLen Lib "VBSQL.VBX" (ByVal SqlConn As Integer, ByVal Column As Integer) As Long
Declare Function SqlData Lib "VBSQL.VBX" (ByVal SqlConn As Integer, ByVal Column As Integer) As String
Declare Function SqlDataReady Lib "VBSQL.VBX" (ByVal SqlConn As Integer) As Integer
Declare Sub SqlExit Lib "VBSQL.VBX" ()
Declare Function SqlSetLoginTime Lib "VBSQL.VBX" (ByVal Seconds As Integer) As Integer
Declare Function SqlSetTime Lib "VBSQL.VBX" (ByVal Seconds As Integer) As Integer
Declare Function SqlSend Lib "VBSQL.VBX" (ByVal SqlConn As Integer) As Integer
Declare Function SqlOk Lib "VBSQL.VBX" (ByVal SqlConn As Integer) As Integer
Declare Function SqlGetChar Lib "VBSQL.VBX" (ByVal SqlConn As Integer, ByVal CharNum As Integer) As String
Declare Function SqlStrCpy Lib "VBSQL.VBX" (ByVal SqlConn As Integer, ByVal Start As Integer, ByVal NumBytes As Integer, CmdString As String) As Integer
Declare Function SqlStrLen Lib "VBSQL.VBX" (ByVal SqlConn As Integer) As Integer
Declare Function SqlSetOpt Lib "VBSQL.VBX" (ByVal SqlConn As Integer, ByVal Opt As Integer, Param As String) As Integer
Declare Function SqlClrOpt Lib "VBSQL.VBX" (ByVal SqlConn As Integer, ByVal Opt As Integer, Param As String) As Integer
Declare Function SqlIsOpt Lib "VBSQL.VBX" (ByVal SqlConn As Integer, ByVal Opt As Integer, Param As String) As Integer
Declare Sub SqlFreeBuf Lib "VBSQL.VBX" (ByVal SqlConn As Integer)
Declare Function SqlCancel Lib "VBSQL.VBX" (ByVal SqlConn As Integer) As Integer
Declare Function SqlCanQuery Lib "VBSQL.VBX" (ByVal SqlConn As Integer) As Integer
Declare Function SqlGetRow Lib "VBSQL.VBX" (ByVal SqlConn As Integer, ByVal RowNum As Long) As Integer
Declare Sub SqlClrBuf Lib "VBSQL.VBX" (ByVal SqlConn As Integer, ByVal RowNum As Long)
Declare Function SqlColBrowse Lib "VBSQL.VBX" (ByVal SqlConn As Integer, ByVal Column As Integer) As Integer
Declare Function SqlColSource Lib "VBSQL.VBX" (ByVal SqlConn As Integer, ByVal TabNum As Integer) As String
Declare Function SqlQual Lib "VBSQL.VBX" (ByVal SqlConn As Integer, ByVal TabNum As Integer, TableName As String) As String
Declare Function SqlTabBrowse Lib "VBSQL.VBX" (ByVal SqlConn As Integer, ByVal TabNum As Integer) As Integer
Declare Function SqlTabCount Lib "VBSQL.VBX" (ByVal SqlConn As Integer) As Integer
Declare Function SqlTabName Lib "VBSQL.VBX" (ByVal SqlConn As Integer, ByVal TabNum As Integer) As String
Declare Function SqlTabSource Lib "VBSQL.VBX" (ByVal SqlConn As Integer, ByVal ColNum As Integer, TabNum As Integer) As String
Declare Function SqlTsNewLen Lib "VBSQL.VBX" (ByVal SqlConn As Integer) As Integer
Declare Function SqlTsNewVal Lib "VBSQL.VBX" (ByVal SqlConn As Integer) As String
Declare Function SqlTsPut Lib "VBSQL.VBX" (ByVal SqlConn As Integer, TsVal As String, ByVal NewTsLen As Integer, ByVal TsLen As Integer, TabName As String) As Integer
Declare Function SqlMoreText Lib "VBSQL.VBX" (ByVal SqlConn As Integer, ByVal Size As Long, Text As String) As Integer
Declare Function SqlTxPtr Lib "VBSQL.VBX" (ByVal SqlConn As Integer, ByVal Column As Integer) As String
Declare Function SqlTxTimeStamp Lib "VBSQL.VBX" (ByVal SqlConn As Integer, ByVal Column As Integer) As String
Declare Function SqlTxTsNewVal Lib "VBSQL.VBX" (ByVal SqlConn As Integer) As String
Declare Function SqlTxTsPut Lib "VBSQL.VBX" (ByVal SqlConn As Integer, NewTxTsVal As String, ByVal Column As Integer) As Integer
Declare Function SqlWriteText Lib "VBSQL.VBX" (ByVal SqlConn As Integer, ObjName As String, TextPtr As String, ByVal TextPtrLen As Integer, TimeStamp As String, ByVal Logging As Integer, ByVal Size As Long, Text As String) As Integer
Declare Function SqlCmdRow Lib "VBSQL.VBX" (ByVal SqlConn As Integer) As Integer
Declare Function SqlCount Lib "VBSQL.VBX" (ByVal SqlConn As Integer) As Long
Declare Function SqlCurCmd Lib "VBSQL.VBX" (ByVal SqlConn As Integer) As Integer
Declare Function SqlCurRow Lib "VBSQL.VBX" (ByVal SqlConn As Integer) As Long
Declare Function SqlDead Lib "VBSQL.VBX" (ByVal SqlConn As Integer) As Integer
Declare Function SqlFirstRow Lib "VBSQL.VBX" (ByVal SqlConn As Integer) As Long
Declare Function SqlGetTime Lib "VBSQL.VBX" (ByVal SqlConn As Integer) As Integer
Declare Function SqlIsAvail Lib "VBSQL.VBX" (ByVal SqlConn As Integer) As Integer
Declare Function SqlLastRow Lib "VBSQL.VBX" (ByVal SqlConn As Integer) As Long
Declare Function SqlMoreCmds Lib "VBSQL.VBX" (ByVal SqlConn As Integer) As Integer
Declare Function SqlNumOrders Lib "VBSQL.VBX" (ByVal SqlConn As Integer) As Integer
Declare Function SqlRows Lib "VBSQL.VBX" (ByVal SqlConn As Integer) As Integer
Declare Function SqlRowType Lib "VBSQL.VBX" (ByVal SqlConn As Integer) As Integer
Declare Function SqlNumAlts Lib "VBSQL.VBX" (ByVal SqlConn As Integer, ByVal ComputeId As Integer) As Integer
Declare Function SqlAltType Lib "VBSQL.VBX" (ByVal SqlConn As Integer, ByVal ComputeId As Integer, ByVal Column As Integer) As Integer
Declare Function SqlAltLen Lib "VBSQL.VBX" (ByVal SqlConn As Integer, ByVal ComputeId As Integer, ByVal Column As Integer) As Integer
Declare Function SqlADLen Lib "VBSQL.VBX" (ByVal SqlConn As Integer, ByVal ComputeId As Integer, ByVal Column As Integer) As Long
Declare Function SqlAData Lib "VBSQL.VBX" (ByVal SqlConn As Integer, ByVal ComputeId As Integer, ByVal Column As Integer) As String
Declare Function SqlAltColId Lib "VBSQL.VBX" (ByVal SqlConn As Integer, ByVal ComputeId As Integer, ByVal Column As Integer) As Integer
Declare Function SqlAltOp Lib "VBSQL.VBX" (ByVal SqlConn As Integer, ByVal ComputeId As Integer, ByVal Column As Integer) As Integer
Declare Function SqlByList Lib "VBSQL.VBX" (ByVal SqlConn As Integer, ByVal ComputeId As Integer) As String
Declare Function SqlNumCompute Lib "VBSQL.VBX" (ByVal SqlConn As Integer) As Integer
Declare Function SqlUse Lib "VBSQL.VBX" (ByVal SqlConn As Integer, DataBase As String) As Integer
Declare Function SqlGetOff Lib "VBSQL.VBX" (ByVal SqlConn As Integer, ByVal OffType As Integer, ByVal StartFrom As Integer) As Integer
Declare Function SqlOrderCol Lib "VBSQL.VBX" (ByVal SqlConn As Integer, ByVal Order As Integer) As Integer
Declare Function SqlChange Lib "VBSQL.VBX" (ByVal SqlConn As Integer) As String
Declare Function SqlGetMaxProcs Lib "VBSQL.VBX" () As Integer
Declare Function SqlName Lib "VBSQL.VBX" (ByVal SqlConn As Integer) As String
Declare Function SqlPrType Lib "VBSQL.VBX" (ByVal Token As Integer) As String
Declare Sub SqlSetAvail Lib "VBSQL.VBX" (ByVal SqlConn As Integer)
Declare Function SqlSetMaxProcs Lib "VBSQL.VBX" (ByVal MaxProcs As Integer) As Integer
Declare Function SqlBCPColfmt Lib "VBSQL.VBX" (ByVal SqlConn As Integer, ByVal FColumn As Integer, ByVal FType As Integer, ByVal FPLen As Integer, ByVal FCLen As Long, FTerm As String, ByVal FTLen As Integer, ByVal TCol As Integer) As Integer
Declare Function SqlBCPColumns Lib "VBSQL.VBX" (ByVal SqlConn As Integer, ByVal ColCount As Integer) As Integer
Declare Function SqlBCPControl Lib "VBSQL.VBX" (ByVal SqlConn As Integer, ByVal Param As Integer, ByVal Value As Long) As Integer
Declare Function SqlBCPExec Lib "VBSQL.VBX" (ByVal SqlConn As Integer, RowsCopied As Long) As Integer
Declare Function SqlBCPInit Lib "VBSQL.VBX" (ByVal SqlConn As Integer, TblName As String, HFile As String, ErrFile As String, ByVal Direction As Integer) As Integer
Declare Function SqlBCPSetL Lib "VBSQL.VBX" (ByVal Loginrec As Integer, ByVal Enable As Integer) As Integer
Declare Function SqlBCPDone Lib "VBSQL.VBX" (ByVal SqlConn As Integer) As Integer
Declare Function SqlSendCmd Lib "VBSQL.VBX" (ByVal SqlConn As Integer, Cmd As String) As Integer
Declare Function SqlGetColumnInfo Lib "VBSQL.VBX" (ByVal SqlConn As Integer, Col As ColumnData, ByVal Column As Integer) As Integer
Declare Function SqlGetAltColInfo Lib "VBSQL.VBX" (ByVal SqlConn As Integer, AltCol As AltColumnData, ByVal ComputeId As Integer, ByVal AltColumn As Integer) As Integer
Declare Function SqlOpenConnection Lib "VBSQL.VBX" (SERVER As String, LoginID As String, Pwd As String, WorkStation As String, Application As String) As Integer
Declare Function SqlTextUpdate1Row Lib "VBSQL.VBX" (ByVal SqlConn As Integer, ObjName As String, ByVal Column As Integer, Text As String) As Integer
Declare Function SqlTextUpdateManyRows Lib "VBSQL.VBX" (ByVal QSqlConn As Integer, ByVal USqlConn As Integer, ObjName As String, ByVal Column As Integer, Text As String) As Long
Declare Function SqlBCPColumnFormat Lib "VBSQL.VBX" (ByVal SqlConn As Integer, Col As BcpColData, ByVal numcols As Integer) As Integer
Declare Function SqlTsUpdate Lib "VBSQL.VBX" (ByVal QSqlConn As Integer, ByVal USqlConn As Integer, ByVal TabNum As Integer, TabName As String) As Integer



'============================================================================'
'                                                                            '
' Visual Basic global constant file.  This file can be loaded into the       '
' global module.                                                             '
'                                                                            '
' Some constants are commented out because they have duplicates (for         '
' example, NONE appears in several places).                                  '
'                                                                            '
'============================================================================'

'========='
'         '
' General '
'         '
'========='

' Booleans
Global Const TRUE = -1
Global Const FALSE = 0

'=================='
'                  '
' Event parameters '
'                  '
'=================='

' Button and Shift (KeyDown, KeyUp, MouseDown, MouseMove, MouseUp)
Global Const SHIFT_MASK = 1
Global Const CTRL_MASK = 2
Global Const ALT_MASK = 4
Global Const LEFT_BUTTON = 1
Global Const RIGHT_BUTTON = 2
Global Const MIDDLE_BUTTON = 4

' ErrNum (LinkError)
Global Const WRONG_FORMAT = 1
Global Const REQUEST_WITHOUT_INIT = 2
Global Const DDE_WITHOUT_INIT = 3
Global Const ADVISE_WITHOUT_INIT = 4
Global Const POKE_WITHOUT_INIT = 5
Global Const DDE_SERVER_CLOSED = 6
Global Const TOO_MANY_LINKS = 7
Global Const STRING_TOO_LONG = 8
Global Const INVALID_CONTROL_ARRAY_REFERENCE = 9
Global Const UNEXPECTED_DDE = 10
Global Const OUT_OF_MEMORY = 11
Global Const SERVER_ATTEMPTED_CLIENT_OPERATION = 12

' KeyCode (KeyDown, KeyUp)
Global Const KEY_LBUTTON = &H1
Global Const KEY_RBUTTON = &H2
Global Const KEY_CANCEL = &H3
Global Const KEY_MBUTTON = &H4         ' NOT contiguous with L & RBUTTON
Global Const KEY_BACK = &H8
Global Const KEY_TAB = &H9
Global Const KEY_CLEAR = &HC
Global Const KEY_RETURN = &HD
Global Const KEY_SHIFT = &H10
Global Const KEY_CONTROL = &H11
Global Const KEY_MENU = &H12
Global Const KEY_PAUSE = &H13
Global Const KEY_CAPITAL = &H14
Global Const KEY_ESCAPE = &H1B
Global Const KEY_SPACE = &H20
Global Const KEY_PRIOR = &H21
Global Const KEY_NEXT = &H22
Global Const KEY_END = &H23
Global Const KEY_HOME = &H24
Global Const KEY_LEFT = &H25
Global Const KEY_UP = &H26
Global Const KEY_RIGHT = &H27
Global Const KEY_DOWN = &H28
Global Const KEY_SELECT = &H29
Global Const KEY_PRINT = &H2A
Global Const KEY_EXECUTE = &H2B
Global Const KEY_SNAPSHOT = &H2C
Global Const KEY_INSERT = &H2D
Global Const KEY_DELETE = &H2E
Global Const KEY_HELP = &H2F

' KEY_A thru KEY_Z are the same as their ASCII equivalents: 'A' thru 'Z'
' KEY_0 thru KEY_9 are the same as their ASCII equivalents: '0' thru '9'

Global Const KEY_NUMPAD0 = &H60
Global Const KEY_NUMPAD1 = &H61
Global Const KEY_NUMPAD2 = &H62
Global Const KEY_NUMPAD3 = &H63
Global Const KEY_NUMPAD4 = &H64
Global Const KEY_NUMPAD5 = &H65
Global Const KEY_NUMPAD6 = &H66
Global Const KEY_NUMPAD7 = &H67
Global Const KEY_NUMPAD8 = &H68
Global Const KEY_NUMPAD9 = &H69
Global Const KEY_MULTIPLY = &H6A
Global Const KEY_ADD = &H6B
Global Const KEY_SEPARATOR = &H6C
Global Const KEY_SUBTRACT = &H6D
Global Const KEY_DECIMAL = &H6E
Global Const KEY_DIVIDE = &H6F
Global Const KEY_F1 = &H70
Global Const KEY_F2 = &H71
Global Const KEY_F3 = &H72
Global Const KEY_F4 = &H73
Global Const KEY_F5 = &H74
Global Const KEY_F6 = &H75
Global Const KEY_F7 = &H76
Global Const KEY_F8 = &H77
Global Const KEY_F9 = &H78
Global Const KEY_F10 = &H79
Global Const KEY_F11 = &H7A
Global Const KEY_F12 = &H7B
Global Const KEY_F13 = &H7C
Global Const KEY_F14 = &H7D
Global Const KEY_F15 = &H7E
Global Const KEY_F16 = &H7F
Global Const KEY_NUMLOCK = &H90

' State (DragOver)
Global Const ENTER = 0
Global Const LEAVE = 1
Global Const OVER = 2

'====================='
'                     '
' Function parameters '
'                     '
'====================='

' MsgBox parameters
Global Const MB_OK = 0                 ' OK button only
Global Const MB_OKCANCEL = 1           ' OK and Cancel buttons
Global Const MB_ABORTRETRYIGNORE = 2   ' Abort, Retry, and Ignore buttons
Global Const MB_YESNOCANCEL = 3        ' Yes, No, and Cancel buttons
Global Const MB_YESNO = 4              ' Yes and No buttons
Global Const MB_RETRYCANCEL = 5        ' Retry and Cancel buttons

Global Const MB_ICONSTOP = 16          ' Critical message
Global Const MB_ICONQUESTION = 32      ' Warning query
Global Const MB_ICONEXCLAMATION = 48   ' Warning message
Global Const MB_ICONINFORMATION = 64   ' Information message

Global Const MB_DEFBUTTON1 = 0         ' First button is default
Global Const MB_DEFBUTTON2 = 256       ' Second button is default
Global Const MB_DEFBUTTON3 = 512       ' Third button is default

' MsgBox return values
Global Const IDOK = 1                  ' OK button pressed
Global Const IDCANCEL = 2              ' Cancel button pressed
Global Const IDABORT = 3               ' Abort button pressed
Global Const IDRETRY = 4               ' Retry button pressed
Global Const IDIGNORE = 5              ' Ignore button pressed
Global Const IDYES = 6                 ' Yes button pressed
Global Const IDNO = 7                  ' No button pressed


'==================='
'                   '
' Method parameters '
'                   '
'==================='

' Drag (controls)
Global Const CANCEL = 0
Global Const BEGIN_DRAG = 1
Global Const END_DRAG = 2

' GetData, GetFormat, SetData (Clipboard)
Global Const CF_LINK = &HBF00
Global Const CF_TEXT = 1
Global Const CF_BITMAP = 2
Global Const CF_METAFILE = 3
Global Const CF_DIB = 8

' Show (form)
Global Const MODAL = 1
Global Const MODELESS = 0

'================='
'                 '
' Property values '
'                 '
'================='

' Alignment (label)
Global Const LEFT_JUSTIFY = 0          ' 0 - Left Justify
Global Const RIGHT_JUSTIFY = 1         ' 1 - Right Justify
Global Const CENTER = 2                ' 2 - Center

' BackColor, ForeColor, FillColor (standard RGB colors: form, controls)
Global Const BLACK = &H0&
Global Const RED = &HFF&
Global Const GREEN = &HFF00&
Global Const YELLOW = &HFFFF&
Global Const BLUE = &HFF0000
Global Const MAGENTA = &HFF00FF
Global Const CYAN = &HFFFF00
Global Const WHITE = &HFFFFFF

' BackColor, ForeColor, FillColor (system colors: form, controls)
Global Const SCROLL_BARS = &H80000000           ' Scroll-bars gray area.
Global Const DESKTOP = &H80000001               ' Desktop.
Global Const ACTIVE_TITLE_BAR = &H80000002      ' Active window caption.
Global Const INACTIVE_TITLE_BAR = &H80000003    ' Inactive window caption.
Global Const MENU_BAR = &H80000004              ' Menu background.
Global Const WINDOW_BACKGROUND = &H80000005     ' Window background.
Global Const WINDOW_FRAME = &H80000006          ' Window frame.
Global Const MENU_TEXT = &H80000007             ' Text in menus.
Global Const WINDOW_TEXT = &H80000008           ' Text in windows.
Global Const TITLE_BAR_TEXT = &H80000009        ' Text in caption, size box, scroll-bar arrow box..
Global Const ACTIVE_BORDER = &H8000000A         ' Active window border.
Global Const INACTIVE_BORDER = &H8000000B       ' Inactive window border.
Global Const APPLICATION_WORKSPACE = &H8000000C ' Background color of multiple document interface (MDI) applications.
Global Const HIGHLIGHT = &H8000000D             ' Items selected item in a control.
Global Const HIGHLIGHT_TEXT = &H8000000E        ' Text of item selected in a control.
Global Const BUTTON_FACE = &H8000000F           ' Face shading on command buttons.
Global Const BUTTON_SHADOW = &H80000010         ' Edge shading on command buttons.
Global Const GRAY_TEXT = &H80000011             ' Grayed (disabled) text.  This color is set to 0 if the current display driver does not support a solid gray color.
Global Const BUTTON_TEXT = &H80000012           ' Text on push buttons.

' BorderStyle (form, label, picture box, text box)
Global Const NONE = 0                  ' 0 - None
Global Const FIXED_SINGLE = 1          ' 1 - Fixed Single
Global Const SIZABLE = 2               ' 2 - Sizable (Forms only)
Global Const FIXED_DOUBLE = 3          ' 3 - Fixed Double (Forms only)

' DragMode (controls)
Global Const MANUAL = 0                ' 0 - Manual
Global Const AUTOMATIC = 1             ' 1 - Automatic

' DrawMode (form, picture box, Printer)
Global Const BLACKNESS = 1             ' 1 - Blackness
Global Const NOT_MERGE_PEN = 2         ' 2 - Not Merge Pen
Global Const MASK_NOT_PEN = 3          ' 3 - Mask Not Pen
Global Const NOT_COPY_PEN = 4          ' 4 - Not Copy Pen
Global Const MASK_PEN_NOT = 5          ' 5 - Mask Pen Not
Global Const INVERT = 6                ' 6 - Invert
Global Const XOR_PEN = 7               ' 7 - Xor Pen
Global Const NOT_MASK_PEN = 8          ' 8 - Not Mask Pen
Global Const MASK_PEN = 9              ' 9 - Mask Pen
Global Const NOT_XOR_PEN = 10          ' 10 - Not Xor Pen
Global Const NOP = 11                  ' 11 - Nop
Global Const MERGE_NOT_PEN = 12        ' 12 - Merge Not Pen
Global Const COPY_PEN = 13             ' 13 - Copy Pen
Global Const MERGE_PEN_NOT = 14        ' 14 - Merge Pen Not
Global Const MERGE_PEN = 15            ' 15 - Merge Pen
Global Const WHITENESS = 16            ' 16 - Whiteness

' DrawStyle (form, picture box, Printer)
Global Const SOLID = 0                 ' 0 - Solid
Global Const DASH = 1                  ' 1 - Dash
Global Const DOT = 2                   ' 2 - Dot
Global Const DASH_DOT = 3              ' 3 - Dash-Dot
Global Const DASH_DOT_DOT = 4          ' 4 - Dash-Dot-Dot
Global Const INVISIBLE = 5             ' 5 - Invisible
Global Const INSIDE_SOLID = 6          ' 6 - Inside Solid

' FillStyle (form, picture box, Printer)
' Global Const SOLID = 0               ' 0 - Solid
Global Const TRANSPARENT = 1           ' 1 - Transparent
Global Const HORIZONTAL_LINE = 2       ' 2 - Horizontal Line
Global Const VERTICAL_LINE = 3         ' 3 - Vertical Line
Global Const UPWARD_DIAGONAL = 4       ' 4 - Upward Diagonal
Global Const DOWNWARD_DIAGONAL = 5     ' 5 - Downward Diagonal
Global Const CROSS = 6                 ' 6 - Cross
Global Const DIAGONAL_CROSS = 7        ' 7 - Diagonal Cross

' LinkMode (controls)
' Global Const NONE = 0                ' 0 - None
Global Const HOT = 1                   ' 1 - Hot
Global Const COLD = 2                  ' 2 - Cold

' LinkMode (form)
' Global Const NONE = 0                ' 0 - None
Global Const SERVER = 1                ' 1 - Server

' MousePointer (form, controls)
Global Const DEFAULT = 0               ' 0 - Default
Global Const ARROW = 1                 ' 1 - Arrow
Global Const CROSSHAIR = 2             ' 2 - Cross
Global Const IBEAM = 3                 ' 3 - I-Beam
Global Const ICON_POINTER = 4          ' 4 - Icon
Global Const SIZE_POINTER = 5          ' 5 - Size
Global Const SIZE_NE_SW = 6            ' 6 - Size NE SW
Global Const SIZE_N_S = 7              ' 7 - Size N S
Global Const SIZE_NW_SE = 8            ' 8 - Size NW SE
Global Const SIZE_W_E = 9              ' 9 - Size W E
Global Const UP_ARROW = 10             ' 10 - Up Arrow
Global Const HOURGLASS = 11            ' 11 - Hourglass
Global Const NO_DROP = 12              ' 12 - No drop

' ScaleMode (form, picture box, Printer)
Global Const USER = 0                  ' 0 - User
Global Const TWIPS = 1                 ' 1 - Twip
Global Const POINTS = 2                ' 2 - Point
Global Const PIXELS = 3                ' 3 - Pixel
Global Const CHARACTERS = 4            ' 4 - Character
Global Const INCHES = 5                ' 5 - Inch
Global Const MILLIMETERS = 6           ' 6 - Millimeter
Global Const CENTIMETERS = 7           ' 7 - Centimeter

' ScrollBar (text box)
' Global Const NONE = 0                ' 0 - None
Global Const HORIZONTAL = 1            ' 1 - Horizontal
Global Const VERTICAL = 2              ' 2 - Vertical
Global Const BOTH = 3                  ' 3 - Both

' Value (check box)
Global Const UNCHECKED = 0             ' 0 - Unchecked
Global Const CHECKED = 1               ' 1 - Checked
Global Const GRAYED = 2                ' 2 - Grayed

' WindowState (form)
Global Const NORMAL = 0                ' 0 - Normal
Global Const MINIMIZED = 1             ' 1 - Minimized
Global Const MAXIMIZED = 2             ' 2 - Maximized

' *****************************************************
' ************** Bobby's stuff ************************
' *****************************************************
Global Const WM_USER = &H400
Global Const EM_SETPASSWORDCHAR = WM_USER + 28
Global Const ES_PASSWORD = &H20
Global Const GWL_STYLE = -16
Global Const WS_VSCROLL = &H200000
Global Const WS_HSCROLL = &H100000

Global Const LB_RESETCONTENT = WM_USER + 5
Global Const LB_GETTOPINDEX = WM_USER + 15
Global Const LB_FINDSTRING = WM_USER + 16
Global Const LB_SETTABSTOPS = WM_USER + 19

Global Const CB_RESETCONTENT = WM_USER + 11
Global Const CB_FINDSTRING = WM_USER + 12
Global Const CB_SELECTSTRING = WM_USER + 13

Declare Function GetFocus% Lib "user" ()
Declare Function SendMessage% Lib "user" (ByVal hWnd%, ByVal Msg%, ByVal wParm%, ByVal lParm As Any)
Declare Function GetWindowLong Lib "user" (ByVal hWnd%, ByVal nIndex%) As Long
Declare Function SetWindowLong Lib "user" (ByVal hWnd%, ByVal nIndex%, ByVal dwNewLong&) As Long
Declare Function PutFocus Lib "user" Alias "SetFocus" (ByVal hWnd As Integer) As Integer
Declare Function ControlHwnd% Lib "ctlhwnd.dll" (A As Control)

Global SqlConn%, WrkConn%, SqlLogRec%
Global Server_name$, Login_ID$, Password$, DatabaseName$
Global NOROWSLEFT%, numcols%, numrows%, BuffSize%, FilterOK%
Global CRLF As String * 2

Type ColDef
  Name As String * 30
  Type As Integer
  Length As Integer
End Type

Global TableCols() As ColDef

