{***************************************************************************}
{** Program : CAPLPT                                                      **}
{***************************************************************************}
{** Version : 1.0             ** Started :           ** Ended :           **}
{***************************************************************************}
{******************************** Description ******************************}
{***************************************************************************}
{** This will redirect LPT1 port to the first available print             **}
{** queue on the default file server. Anything that is then written to    **}
{** LPT1 is redirected to the print queue on the server.                  **}
{**                                                                       **}
{** For direct printing to a print queue see CAPQUEUE.                    **}
{**                                                                       **}
{**                                                                       **}
{**                                                                       **}
{***************************************************************************}
{******************************** Information ******************************}
{***************************************************************************}
{**                                                                       **}
{**                                                                       **}
{**                                                                       **}
{**                                                                       **}
{***************************************************************************}

{$X+}

program CAPLPT;

uses

  nwvar,
  nwerror,
  nwbindry,
  nwprint,
  nwwrkstn,
  nwmisc,
  objects,
  printer;

var

  Bindery    : BinderyOBJ;
  Print      : PrintOBJ;
  WorkStat   : WorkStationOBJ;
  Misc       : MiscFuncOBJ;
  CapFlags   : Capture_Flags;
  QueueID    : OT_BinderyID;
  Queues     : PStringCollection;
  NoOfQueues : word;

begin

  Bindery.Init (true);
  Print.Init (true);
  WorkStat.Init (true);
  Misc.Init (true);
  Queues := new (PStringCollection, Init (5, 10));

  Misc.GetAllObjects ('*', OT_PrintQueue, Queues, NoOfQueues);
  Bindery.GetBinderyObjectID (PString (Queues^.At (0))^, OT_PrintQueue, QueueID);
  Print.GetDefaultCaptureFlags (CapFlags);
  Print.SetCapturePrintQueue (0, WorkStat.GetDefaultConnectionID, QueueID);
  Print.StartLPTCapture;

  {do all your printing to lpt1 here}

  rewrite (LST);
  writeln (LST, 'THIS IS A TEST');

  Print.EndLPTCapture;
  dispose (Queues, Done);
  Bindery.Done;
  Misc.Done;
  Print.Done;
  WorkStat.Done;

end.

