{***************************************************************************}
{** Program : GWSINFO                                                     **}
{***************************************************************************}
{** Version : 1.0             ** Started :           ** Ended :           **}
{***************************************************************************}
{******************************** Description ******************************}
{***************************************************************************}
{** Program to get selected information about the object                  **}
{**                                                                       **}
{**                                                                       **}
{**                                                                       **}
{**                                                                       **}
{**                                                                       **}
{**                                                                       **}
{**                                                                       **}
{***************************************************************************}
{******************************** Information ******************************}
{***************************************************************************}
{**                                                                       **}
{**                                                                       **}
{**                                                                       **}
{**                                                                       **}
{**                                                                       **}
{**                                                                       **}
{***************************************************************************}

{$X+}

program GWSINFO;

uses

  {$IFDEF WINDOWS}
  wincrt,
  {$ELSE}
  crt,
  {$ENDIF}
  nwvar,
  nwerror,
  nwbindry,
  nwconn,
  nwmisc
  ;

var

  BS : BinderyOBJ;
  CS : ConnectionOBJ;
  MS : MiscFuncOBJ;

procedure Initialise;

begin

  BS.Init (true);
  CS.Init (false);
  MS.Init (true);

end; {initialise}

{***}

procedure Done;

begin

  BS.Done;
  CS.Done;
  MS.Done;

end; {Done}

{***}

procedure DisplayInfo;

var

  ObjName  : TObjectName;
  ObjType  : OT_BinderyType;
  ObjID    : OT_BinderyID;
  ObjLT    : TByte7Array;
  StatAddr : TByte6Array;
  NetNum   : TByte4Array;
  SockNum  : word;

begin

  clrscr;
  writeln;
  with CS, MS do
    begin

      GetConnectionInformation (GetConnectionNumber, ObjName, ObjType, ObjID, ObjLT);
      if ObjName = '' then
        ObjName := 'NOT-LOGGED-IN';
      writeln ('You are connection number ', GetConnectionNumber, ' on ', GetDefaultFileServerName);
      writeln ('Your login name is ', ObjName);
      GetInternetAddress (GetConnectionNumber, NetNum, StatAddr, SockNum);
      writeln ('Internet address : ', ConvertNetworkNumber (NetNum), ':',
               ConvertNodeAddress (StatAddr), ':', HexString (SockNum, 4));

    end;

end; {DisplayInfo}

{***}

begin

  Initialise;
  DisplayInfo;
  Done;

end.