   DEFINT A-Z

   '----- Copyright (c) 1991 Carlos San Miguel
   '----- Copyright (c) 1991 ProSoft

   '----- fell free to use this subs in any form you wish
   '----- compile with bc netware;
   '----- link with link netware,,,netware.lib;

   '----- declare netware subs so you don't have to use CALL ....

   DECLARE SUB GetConnectionNumber(Numero)
   DECLARE SUB GetConnectionInfo(A,B,C,D)
   DECLARE SUB LogOut()
   DECLARE SUB GetDefaultCaptureFlags (Longitud, Segmento, Direccion)
   DECLARE SUB SetDefaultCaptureFlags (Longitud, Segmento, Direccion)
   DECLARE SUB StartCapture()
   DECLARE SUB EndCapture()
   DECLARE SUB CancelCapture()
   DECLARE SUB GetEffectiveDirRights (SegRepBuf, AdrRepBuf, SegReqBuf, AdrReqBuf, ErCode)

   '----- this program shows how to use the subs contained in Netware.lib

   '----- first we are going to get the connection number

   GetConnectionNumber ConNumber
   PRINT "The connection number is ";ConNumber

   '----- now we are going to get the user's info with the same connection number we
   '----- just received

   TYPE RequestBuffer
        ReqBufLen AS INTEGER      
        Phantom   AS STRING * 1
        ConNumber AS STRING * 1
   END TYPE

   TYPE ReplyBuffer
        RepBufLen AS INTEGER      
        ObjId     AS STRING * 4
        ObjType   AS STRING * 2
        ObjName   AS STRING * 48
        LogYear   AS STRING * 1
        LogMonth  AS STRING * 1
        LogDay    AS STRING * 1
        LogHour   AS STRING * 1
        LogMinute AS STRING * 1
        LogSecond AS STRING * 1
        LogWDay   AS STRING * 1
   END TYPE

   DIM ReqBuf AS RequestBuffer
   DIM RepBuf AS ReplyBuffer

   ReqBuf.ReqBufLen = LEN(ReqBuf) - 2
   ReqBuf.Phantom   = CHR$(&H16)
   ReqBuf.ConNumber = CHR$(ConNumber)
   RepBuf.RepBufLen = LEN(RepBuf) - 2

   GetConnectionInfo VARPTR(ReqBuf), VARSEG(ReqBuf), VARPTR(RepBuf), VARSEG(RepBuf)

   PRINT "User name is      :";RepBuf.ObjName
   PRINT "Login Year is     :";ASC(RepBuf.LogYear)
   PRINT "Login month is    :";ASC(RepBuf.LogMonth)
   PRINT "Login day is      :";ASC(RepBuf.LogDay)
   PRINT "Login hour is     :";ASC(RepBuf.LogHour)
   PRINT "Login minute is   :";ASC(RepBuf.LogMinute)
   PRINT "Login second is   :";ASC(RepBuf.LogSecond)
   PRINT "Login week day is :";ASC(RepBuf.LogWDay)

   '----- now we are going to use the printer specific subs.

   TYPE PrnReplyBuffer
        Status    AS STRING * 1    'byte
        Flags     AS STRING * 1    'byte
        TabSize   AS STRING * 1    'byte(spaces per tab)
        ServerPrn AS STRING * 1    'byte(0-4)
        Copies    AS STRING * 1    'byte
        FormType  AS STRING * 1    'byte
        Reserved1 AS STRING * 1    
        BannerTxt AS STRING * 13   'byte(13) asciiz must end with CHR$(0)
        Reserved2 AS STRING * 1    
        LocalPrn  AS STRING * 1    
        FCTO      AS INTEGER
        FCODC     AS STRING * 1
        MaxLines  AS INTEGER
        MaxChars  AS INTEGER
        FormName  AS STRING * 13
        LptCapFlg AS STRING * 1
        FilCapFlg AS STRING * 1
        TimingOut AS STRING * 1
        Addr1     AS STRING * 1
        Addr2     AS STRING * 1
        CIQPJ     AS STRING * 1
        CIP       AS STRING * 1
        PQF       AS STRING * 1
        PJV       AS STRING * 1
        PQID      AS STRING * 4
        PJN       AS STRING * 4
   END TYPE
    
   DIM PrnTempBuf AS PrnReplyBuffer    'this will hold the original settings
   DIM PrnRepBuf AS PrnReplyBuffer     'use this to set the new capture flags

   '----- first we get the current setting and save them in PrnTempBuf

   GetDefaultCaptureFlags LEN(PrnTempBuf), VARSEG(PrnTempBuf), VARPTR(PrnTempBuf)

   '----- now we get them again so that most of the fields will be filled by Netware, that
   '----- way we only change the ones we are insterested in.

   GetDefaultCaptureFlags LEN(PrnRepBuf), VARSEG(PrnRepBuf), VARPTR(PrnRepBuf)

   PrnRepBuf.Status     = CHR$(0)        'enable print flags

   '----- the print flags are set as follows 
   '----- set bit 2 if you want the print job released to the queue if the 
   '----- server connection is lost
   '----- set bit 3 if you want to supress form feeds
   '----- set bit 6 if you want to expand tabs. You can specify the tab size with 
   '----- the PrnRepBuf.TabSize var.
   '----- set bit 7 if you want a banner printed before your job. The banner name 
   '----- can be specified with the PrnRepBuf.BannerTxt var. remember to end 
   '----- the banner with a CHR$(0) that is, if you want the banner name to be
   '----- "BASIC", then you would set up the var to be :
   '-----                         PrnRepBuf.BannerTxt = "BASIC" + CHR$(0)
   '----- remember that bits are zero based, with the leas significant bit on the right
   '----- setting a bit means, assigning a value of one to it.

   PrnRepBuf.Flags      = CHR$(&H28)     'delete after printing and no form feed
   PrnRepBuf.FormType   = CHR$(0)        'form type 0
   PrnRepBuf.ServerPrn  = CHR$(0)        'network printer 0
   PrnRepBuf.Copies     = CHR$(1)        'one copy

   '----- here we set the capture flags

   SetDefaultCaptureFlags LEN(PrnRepBuf), VARSEG(PrnRepBuf), VARPTR(PrnRepBuf)

   '----- now we start the capture

   StartCapture

   '----- and we send something to the network printer

   LPRINT "Hello world"
   LPRINT "We are printing on the network printer"

   '----- we end capture and queue the job

   EndCapture

   '----- and we restore the capture flags to their original values

   SetDefaultCaptureFlags LEN(PrnTempBuf), VARSEG(PrnTempBuf), VARPTR(PrnTempBuf)

   '----- the next sub has not been tested yet, so please let me know if anything
   '----- goes wrong. Since I do not have a Network at home I could not test it.
   '----- I just wrote it because Ross Chaplin was asking for this specific sub.
   '----- Hope it works.

   TYPE DirRequestBuffer
        BufLen    AS INTEGER         'request buffer length - 2
        Constant  AS STRING * 1
        DirHandle AS STRING * 1
        PathLen   AS STRING * 1
        Path      AS STRING * 255
   END TYPE

   TYPE DirReplyBuffer
        BufLen    AS INTEGER         'repply buffer length - 2
        Rights    AS STRING * 1
   END TYPE
   
   DIM DirRepBuf AS DirReplyBuffer
   DIM DirReqBuf AS DirRequestBuffer
   
   DirReqBuf.BufLen    = 258
   DirReqBuf.DirHandle = CHR$(0)     'set to 0 when we use the path only and no handle
   DirReqBuf.PathLen   = CHR$(14)
   DirReqBuf.Path      = "SYS:PUBLIC\DOS"

   GetEffectiveDirRights VARSEG(DirRepBuf), VARPTR(DirRepBuf), VARSEG(DirReqBuf), VARPTR(DirReqBuf), ErCode

   SELECT CASE ErCode
       CASE 0
            PRINT "The efective rights are :"
            FOR X = 0 TO 7
                IF ASC(DirRepBuf.Rights) AND 2 ^ X THEN
                   SELECT CASE X
                       CASE 0
                            PRINT "User can read files"
                       CASE 1
                            PRINT "User can write to files"
                       CASE 2
                            PRINT "User can open files"
                       CASE 3
                            PRINT "User can create files"
                       CASE 4
                            PRINT "User can delete files"
                       CASE 5
                            PRINT "User has parental rights"
                       CASE 6
                            PRINT "User can search directory"
                       CASE 7
                            PRINT "User can modify file attributes"
                   END SELECT
                END IF
            NEXT X
       CASE &H98
            PRINT "Volume does not exist"
       CASE &H9B
            PRINT "Bad directory handle"
       CASE ELSE
            PRINT "Error :";ErCode;" was returned."
   END SELECT

   END
