#include <stdio.h>
#include <direct.h>
#include <stdlib.h>
#include <dos.h>
#include <time.h>
#define KEYWIDTH 10
#define NUMKEYS 18
#define MAXLEN 64
#define TRUE 1
#define FALSE 0
main(argc,argv)
char *argv[];
int argc;
{
        char data[MAXLEN];
        char data2[MAXLEN];
        static char keywords[NUMKEYS][KEYWIDTH] =
                        { "CR",         /* 0 */
                          "DAY",        /* 1 */
                          "DIR",        /* 2 */
                          "DRIVE",      /* 3 */
                          "HOUR",       /* 4 */
                          "MIN",        /* 5 */
                          "MONTH",      /* 6 */
                          "NCR",        /* 7 */
                          "SEC",        /* 8 */
                          "TIME",       /* 9 */
                          "TIMEALL",    /* 10 */
                          "WDAY",       /* 11 */
                          "YEAR",       /* 12 */
                          "VER",        /* 13 */
                          "DSIZE",      /* 14 */
                          "DFREE",      /* 15 */
                          "DSIZEK",     /* 16 */
                          "DFREEK"   }; /* 17 */
        int i;
        int k;
        int match;
        int sendcr;
        int answer;
        unsigned drive;
        time_t aclock;
        char timedata[26];

        unsigned long bytes_per_cluster;
        unsigned long size;
        struct diskfree_t diskinfo;


   if (argc > 1)
      {
       /* get full time and place in timedata */
       time(&aclock);  /* get time in seconds */
       /* convert to structure and store in string */
       strcpy(timedata,asctime(localtime(&aclock)));
       /* timedata format is DAY MON DY HH:MM:SS YEAR\n */

       _dos_getdiskfree(0,&diskinfo);
       bytes_per_cluster = diskinfo.sectors_per_cluster *
                           diskinfo.bytes_per_sector;

       sendcr = TRUE;  /* default is to send CR at end of output */
       for (i=1; i < argc; i++)
         {
         match = -1;
         for (k=0; k <= NUMKEYS-1; k++)
              {
                answer = strcmpi(&keywords[k][0],argv[i]);
                if (answer==0)
                        {
                         match = k;
                        }
              }

        if (match != -1)
                {
                switch(match) {
                case 0 : /* write a carriage return */
                         data[0] = '\n';
                         data[1] = '\0';
                         break;
                case 2 : /* get the current directory */
                         getcwd(data2,MAXLEN);
                         strcpy(data,data2+2);
                         break;
                case 3 : /* get the current drive */
                         _dos_getdrive(&drive);
                         data[0] = 'A'+drive-1;
                         data[1] = ':';
                         data[2] = '\0';
                         break;
                case 7 : /* Don't write a carriage return at end*/
                         sendcr = FALSE;
                         data[0] = '\0';
                         break;
                case 9 : /* Get the timeofday */
                         data[0] = timedata[11];
                         data[1] = timedata[12];
                         data[2] = timedata[13];
                         data[3] = timedata[14];
                         data[4] = timedata[15];
                         data[5] = '\0';
                         break;
                case 10 : /* Get the full time */
                         strcpy(data,timedata);
                         data[24] = '\0';  /* kill the newline*/
                         break;
                case 12: /* Get the year */
                         data[0] = timedata[20];
                         data[1] = timedata[21];
                         data[2] = timedata[22];
                         data[3] = timedata[23];
                         data[4] = '\0';
                         break;
                case 11 : /* Get the WEEKDAY day of week (Mon,Tue etc) */
                         data[0] = timedata[0];
                         data[1] = timedata[1];
                         data[2] = timedata[2];
                         data[3] = '\0';
                         break;
                case 4 : /* Get the hour (24 hour format) */
                         data[0] = timedata[11];
                         data[1] = timedata[12];
                         data[2] = '\0';
                         break;
                case 5 : /* Get the minutes */
                         data[0] = timedata[14];
                         data[1] = timedata[15];
                         data[2] = '\0';
                         break;
                case 8 : /* Get the seconds */
                         data[0] = timedata[17];
                         data[1] = timedata[18];
                         data[2] = '\0';
                         break;
                case 6 : /* Get the month (Jan, Feb etc) */
                         data[0] = timedata[4];
                         data[1] = timedata[5];
                         data[2] = timedata[6];
                         data[3] = '\0';
                         break;
                case 1 : /* Get the day of month */
                         data[0] = timedata[8];
                         data[1] = timedata[9];
                         data[2] = '\0';
                         break;
                case 13 : /* Get DOS version number */
                         itoa(_osmajor,data,10);
                         itoa(_osminor,data2,10);
                         strcat(data,".");
                         strcat(data,data2);
                         break;
                case 14 : /* Get size of the current drive */
                         size = diskinfo.total_clusters * bytes_per_cluster;
                         ultoa(size,data,10);
                         break;
                case 15 : /* Get available space on the current drive */
                         size = diskinfo.avail_clusters * bytes_per_cluster;
                         ultoa(size,data,10);
                         break;
                case 16 : /* Get size of the current drive  in K*/
                         size = diskinfo.total_clusters * bytes_per_cluster / 1024;
                         ultoa(size,data,10);
                         break;
                case 17 : /* Get available space on the current drive in K*/
                         size = diskinfo.avail_clusters * bytes_per_cluster /1024;
                         ultoa(size,data,10);
                         break;
                }
                printf("%s",data);
             }
        else
                printf("%s",argv[i]);
         }

     if (sendcr == TRUE) printf("\n");

  } /* end of if argc > 0 */

 else
   {
    printf("                 EchoPlus Version 1.0\n");
    printf("   A program to write handy information to Stdout. \n");
    printf("\n");
    printf("   Command Summary:\n");
    printf("           ECHOPLUS <item <item...>> \n");
    printf(" Where: <item> is either a string or one of the keywords below.\n");
    printf("        Strings should be enclosed in double quotes (\"). \n");
    printf(" Keywords :\n");
    printf("    DIR     - current DIRectory      CR    - Carriage Return (LF+CR) \n");
    printf("    DRIVE   - current DRIVE          NCR   - Don't place CR at end \n");
    printf("    VER     - DOS version                                          \n");
    printf("    DSIZE   - disk size (bytes)      DFREE - Available bytes \n");
    printf("    DSIZEK  - disk size (kbytes)     DFREEK- Available kbytes \n");
    printf("    TIMEALL - Full time and date \n");
    printf("    TIME    - TIME of day (HH:MM)    DAY   - DAY of month\n");
    printf("    HOUR    - HOUR of day (24 hr)    WDAY  - WeekDay (Mon, Tue, etc)\n");
    printf("    MIN     - MINutes                MONTH - MONTH name (Jan, Feb,etc)\n");
    printf("    SEC     - SEConds                YEAR  - Year (4 digits)\n");
    printf("\n");
    printf("Example:    ECHOPLUS drive CR \"cd \" dir >goback.bat \n");
    printf("      Would create a batch file to return to the current directory.\n");
    printf("      Read ECHOPLUS.DOC for more complete information.\n");
    printf("                Copywrite 1989, C. Venter & J. Seaman\n");

   }
}

