{==============================================================}
{     Saved as: MATCHVOL.PAS                                   }
{     By Pat Anderson                                          }
{     Last modified: Sun  12-25-1988                           }
{     Turbo Pascal 4/5                                         }
{==============================================================}

{$V-}
PROGRAM MatchVolume;

USES
  Dos;

VAR
  DirInfo : SearchRec;
  MatchName : string;
  DriveSpec : string;
  Dot : byte;

FUNCTION ToUpper (s : string) : string;
  VAR Count : word;
  BEGIN
    FOR Count := 1 to Length (s) DO
      s[count] := UpCase (s[count]);
    ToUpper := s;
  END;

BEGIN
  IF ParamCount < 1 THEN
    BEGIN
      WriteLn ('You must specify a volume label on the command line.');
      WriteLn ('  e.g., MatchVol MS_Word');
      WriteLn ('This checks the volume label on the current drive.');
      WriteLn ('You may optionally specify a drive.');
      WriteLn ('  e.g., MatchVol MS_Word a:');
      WriteLn ('This checks the volume label on the specified drive.');
      WriteLn;
      WriteLn ('The program returns ErrorLevels as follows:');
      WriteLn ('  0 = Disk has a volume label, label specified matches');
      WriteLn ('  1 = Disk has a volume label, label specified does not match');
      WriteLn ('  2 = Disk does not have a volume label');
      WriteLn ('  3 = Error accessing specified drive');
      Halt;
    END;

  {retrieve label specified on comnmand line}
  MatchName := ParamStr (1);
  MatchName := ToUpper (MatchName);

  {retrieve the drive letter, if there is one, get current drive if not}
  IF ParamStr (2) <> '' THEN
    IF Length (ParamStr (2)) = 1 THEN           {handle case of no ':'}
        DriveSpec := ParamStr (2) + ':'
    ELSE
      DriveSpec := ParamStr (2)
  ELSE
    BEGIN
      GetDir (0, DriveSpec);
      DriveSpec := Copy (DriveSpec,1,2);
    END;

  {Retrieve volume label from correct drive}
  FindFirst (DriveSpec + '*.*', VolumeID, DirInfo);
  IF DosError = 0 THEN
    BEGIN
      DirInfo.Name := ToUpper (DirInfo.Name);
      Dot := Pos ('.',DirInfo.Name);            {purge the '.'}
      IF Dot > 0 THEN
        Delete (DirInfo.Name, Dot, 1);
    END
  ELSE
    IF DosError = 18 THEN     {No matching files found}
      BEGIN
        WriteLn;
        WriteLn ('Drive ',DriveSpec,' has no volume label!');
        Halt (2);
      END
  ELSE
    BEGIN
      WriteLn;
      WriteLn ('Error in accessing specified drive!');
      Halt (3)
    END;

  WriteLn;
  Write ('The current label and the specified label ');
  IF DirInfo.Name = MatchName THEN
    BEGIN
      WriteLn ('MATCH!');
      Halt (0);
    END
  ELSE
    BEGIN
      WriteLn ('do NOT match!');
      Halt (1);
    END;

END.

