PROGRAM BATCHCPY; {Routine that copies .BAT routines from a single
                       collective file into separate routines on RAMDISK}

VAR

   BatchList,OutList                     : TEXT;
   RamDrive                              : STRING[2];
   Line                                  : STRING;
   Target                                : STRING[14];

BEGIN

  {$I-}
  ASSIGN(BatchList,'C:\DOS\BATCH\BATCH.LST');
  RESET(BatchList);

  IF IOResult <> 0 THEN
    BEGIN
      WRITELN('LIST OF BATCH FILES, "BATCH.LST", DOES NOT EXIST');
      WRITELN('IN SUBDIRECTORY "C:\DOS\BATCH\"');

      EXIT
    END;


  READLN(BatchList,RamDrive);

  IF RamDrive[2] <> ':' THEN
    BEGIN
      WRITELN('RAMDRIVE DESIGNATION MUST BE ON FIRST LINE OF "BATCH.LST"');
      WRITELN('AND MUST BE IN FORM "X:", WHERE "X" IS DRIVE DESIGNATION');

      EXIT
    END;

  READLN(BatchList,Line);

  IF Line[1] <> '*' THEN
    BEGIN
      WRITELN('SECOND LINE OF "BATCH.LST" MUST BE NAME OF FIRST BATCH FILE');
      WRITELN('IN FORM "*xxxxxxxx.BAT"');

      EXIT
    END;

  Target := RamDrive+COPY(Line,2,12);

  READLN(BatchList,Line);

  WHILE NOT EOF(BatchList) DO

    BEGIN

      ASSIGN(OutList,Target);
      REWRITE(OutList);

      WHILE NOT EOF(BatchList) AND (Line[1] <> '*') DO

        BEGIN

          WRITELN(OutList,Line);
          READLN(BatchList,Line)
        END;

      IF NOT EOF(BatchList) THEN

        BEGIN

          FLUSH(OutList);
          CLOSE(OutList);

          Target := RamDrive+COPY(Line,2,12);

          READLN(BatchList,Line)
        END
    END;

  FLUSH(OutList);
  CLOSE(OutList);
  CLOSE(BatchList)
END.