/***************************************************************

   Copyright 1993  Northeast Data Corp.  All Rights Reserved

****************************************************************/

/***************************************************************


   NetCom.h

   Public definitions for applications that use the NetCom 
   control.

    - Messages
    - Notification codes.
    - Control Styles.

****************************************************************/
   
   // Useful constants
#define MAXNETNAME      16       // Max netbios name length

   // Messages the application can send to the control
#define NCM_SETCOMMAND           (WM_USER+1)
#define NCM_SETNAME              (WM_USER+2)
#define NCM_SETDATA              (WM_USER+3)
#define NCM_SETREMOTENAME        (WM_USER+5)
#define NCM_SETTRACE             (WM_USER+6)
#define NCM_SETSESSION           (WM_USER+7)
#define NCM_SETADAPTER           (WM_USER+8)
#define NCM_SETSENDTIMEOUT       (WM_USER+9)
#define NCM_SETRECTIMEOUT        (WM_USER+10)

   // Commands specified in wParam of the NCM_SETCOMMAND message
   // Commands
#define NCC_INIT              1
#define NCC_REGISTERNAME      2
#define NCC_REGISTERGROUP     3
#define NCC_SENDDATAGRAM      4
#define NCC_RECEIVEDATAGRAM   5
#define NCC_CALL              6
#define NCC_LISTEN            7
#define NCC_SEND              8
#define NCC_RECEIVE           9
#define NCC_HANGUPONREC       10
#define NCC_HANGUPONSEND      11
#define NCC_CANCELALL         12
#define NCC_RESET             13
#define NCC_DELETENAME        14
#define NCC_RECEIVEANY        15
#define NCC_ADAPTERSTATUS     16
#define NCC_LISTNAMES         17
#define NCC_RECSESSSTATUS     18
#define NCC_SENDSESSSTATUS    19
#define NCC_RECEIVEBROADCAST  20
#define NCC_SENDBROADCAST     21
#define NCC_RECEIVEANYFORANY  22

   // wParam arguments for the NCM_SETSESSION and NCM_GETSESSION messages
#define RECEIVESESSION        0
#define SENDSESSION           1

   // Notifications sent to the application
#define NCN_RECEIVEDDATAGRAM        1
#define NCN_RECEIVEDDATA            2
#define NCN_SENDCOMPLETE            3
#define NCN_NEWSENDSESSION          4
#define NCN_NETNAME                 5
#define NCN_NEWRECSESSION           6
#define NCN_SESSIONCLOSED           7
#define NCN_TIMEOUT                 8

   // The one callable function to force the DLL to load
void FAR PASCAL registerNetCom(void);

   // C Error codes
#define ERR_NONETBIOS         -1
#define ERR_ADDGROUP          -2
#define ERR_ADDNAME           -3
#define ERR_SENDDATAGRAM      -4
#define ERR_SETUPRECEIVE      -5
#define ERR_NONAME            -6
#define ERR_NETINIT           -7
#define ERR_DUPNAME           -8
#define ERR_ADAPTERRESET      -9
#define ERR_HANGUP            -10
#define ERR_CALL              -11
#define ERR_DELETENAME        -12
#define ERR_LISTEN            -13
#define ERR_SEND              -14
#define ERR_ADAPTERSTATUS     -15
#define ERR_MEMALLOC          -16
#define ERR_SESSIONSTATUS     -17
#define ERR_SESSIONNOTFOUND   -18
#define ERR_INVALIDTIMEOUT    -19

   // VB Error codes
#define VBERRB                   32000
#define VBERR_ADDGROUP           (VBERRB)
#define VBERR_ADDNAME            (VBERRB+1)
#define VBERR_UNK                (VBERRB+2)     // Unknown error code
#define VBERR_INITFAIL           (VBERRB+3)
#define VBERR_DUPNAME            (VBERRB+4)
#define VBERR_BADRESET           (VBERRB+5)
#define VBERR_MEMALLOC           (VBERRB+6)
#define VBERR_SESSSTATUS         (VBERRB+7)
#define VBERR_TIMEOUT            (VBERRB+8)

   // Data types

   // Data received information block
typedef struct
{
   LPSTR     lpData;
   WORD      nLen;
   char      szFrom[MAXNETNAME+1];
} RECINFOSTRUCT, FAR *LPRECINFOSTRUCT;

   // Session information block
typedef struct
{
   WORD      nSessionNumber;
   WORD      nSessionState;
   char      szLocalName[MAXNETNAME+1];
   char      szRemoteName[MAXNETNAME+1];
} SESSIONINFOSTRUCT, FAR *LPSESSIONINFOSTRUCT; 

   // The net names callback function
typedef BOOL (FAR PASCAL* NAMECALLBACK)(LPSTR,int);

   // Session information callback function
typedef BOOL (FAR PASCAL* SESSIONCALLBACK)(LPSESSIONINFOSTRUCT);


    
