; SPORT Multi-Media Message Utility Control File
;
; <- A semi-colon in the first column indicates a comment line.
; See the SPORT documentation for details of SPORTMM operations.
;
; To process inbound Multi-Media packets run "SPORTMM P".
; To read and manage packets run "SPORTMM".
; SPORTMM and its control file should be located in your SPORT directory.
; The utility LHA.EXE must be available either in your SPORT directory
; or somewhere on your DOS path.
;
; Multi-media packets always bear the extension '.MM'.  They are created
; using the utility LHA.  When creating a multi-media packet please note
; that the order in which the files are compressed into the packet are
; important.  That is the order in which they are displayed to the user
; when they are read using SPORTMM.  If there is a Flash Message (*.FLS)
; included in the packet (which there should ALWAYS be for the sake of
; the reader), it will be extracted by "SPORTMM P".  The packet will
; then be moved from the inbound area to the "MM" directory (see below)
; and its name will be changed to the day, hour, minute and second it
; was received, plus the extension ".MM".  For example, suppose you
; receive a packet named "FORYOU.MM" in your SPORT inbound mail area.
; If you run "SPORTMM P" as part of your post-mail processing (before
; using "SPORT S"), any Flash Messages will be extracted from the packet
; and it will then be moved to your "MM" directory in which it will bear
; a new file name indicating the day and time it was received.  You will
; then be able to read and manage this packet using "SPORTMM" from the
; DOS command line.
;
; Now for the configuration requirements...
;
; Declare your SPORT directory (full path)
FLASHAREA D:\SPORT
;
; Declare your inbound mail area (full path)
INBOUND D:\SPORT\INCOMING
;
; Declare your working directory.  This directory will be used by
; SPORTMM at will and therefore anything in it is subject to being
; deleted.  It should only be used for SPORTMM operations.
WORKING D:\SPORT\WORK
;
; Declare your Multi-Media directory.
MM D:\SPORT\MM
;
;
; Now comes a list of TOOLs to be used by SPORTMM.  Each tool is designed
; to allow you to read and/or display a specific type of file which may
; be included in a SPORTMM packet.  The TOOLs are defined as follows:
;
; TOOL,file_extension;tool_path
;
; Note the syntax!  The keyword "TOOL" is immediately followed by a comma
; which is immediately followed by the file_extension, which is immediately
; followed by a semi-colon which is immediately followed by the tool_path.
; There are NO SPACES allowed in a TOOL line.  The file extension MUST be
; no more than three characters (DOS valid) and the tool_path must be a
; complete DOS path as you would use to call the program from the DOS
; command line.  The name of the file to be processed will be appended
; to the tool_path, so that program or utility must be capable of
; processing a file name as an argument.
;
; You may declare up to 50 TOOL lines.
;
;
; First something to read any message files generated by SPORT:
TOOL,FLS;C:\Utils\List
TOOL,HLO;C:\Utils\List
;
; Now any other type of plain ASCII files which can be listed:
TOOL,DOC;C:\Utils\List
TOOL,TXT;C:\Utils\List
;
; Now something to view ANSI screens (just TYPE if using ANSI.SYS):
TOOL,ANS;Type
;
; Something for graphics files:
TOOL,PIC;CView
TOOL,GIF;CView
;
;
; For spreadsheets:
TOOL,WKS;D:\QPro\Q
TOOL,WK1;D:\QPro\Q
TOOL,WQ1;D:\QPro\Q
;
; Finally we need a "catch all" utility which will handle extensions
; which are not specified.  SPORTMM will automatically use the generic
; tool "LIST" if you do not declare a MASTERTOOL.  Note that this keyword
; has a different format than the TOOL keyword.  Just use the keyword
; "MASTERTOOL, followed immediately by a command, followed immediately
; by the name of the tool to use.  An extension is not needed because
; this tool will be used for any file not matching the extensions listed
; above in the "TOOL" statements.
;
MASTERTOOL,LIST
;

