/* program to copy a file while in use by another program... */
#include <stdio.h>
#include <fcntl.h>
#include <sys\types.h>
#include <sys\stat.h>
#include <share.h>
#include <io.h>
#include <malloc.h>

main(argc, argv)
int argc;
char *argv[];
{
	long qo, qi;
	unsigned int i;
	int k, fhi, fho;

	char c, *mp;

	if (argc != 3) {
		fprintf(stderr, "SCOPY: Copyright 1989 by Kevin Porter\n");
		fprintf(stderr, "syntax: scopy <source> <destination>\n");
		fprintf(stderr, "Don't use wildcards!\n");
		return (2);
	}

	if ((fhi=sopen(argv[1], O_RDONLY | O_BINARY, SH_DENYNO)) == -1) {
		fprintf(stderr, "Can't open input!\n");
		return (1);
	}

	if ((fho=open(argv[2], O_WRONLY | O_TRUNC | O_CREAT | O_BINARY, S_IREAD | S_IWRITE)) == -1) {
		fprintf(stderr, "Can't open output!\n");
		return (3);
	}

	i=0xf000;
	mp=malloc(i);
	while (mp==NULL) {
		i/=2;
		if (i < 0x0100) {
			fprintf(stderr, "Insufficient memory for copy!\n");
			return (4);
		}
		mp=malloc(i);
	}

	do {
		qi=read(fhi, mp, i);
		qo=write(fho, mp, qi);
	} while (qi == i);

	close(fhi);
	close(fho);

	return (0);
}
