/*
	By: P. Spear 6/9/92
	-------------------

	FF3.EXE:  Flie location and deletion utility written in Turbo C++ 3.0

	This procedure takes a file spec and searches all directories
	for occurences of the file.

	Usage: FF3 [drive:][filename].[ext] [/C] [/D] [/I] [/S] [/R[drive:]filename]

	[drive:][filename].[ext]\n");
			List or delete file(s) on specified or current drive.
	/C	Start at current directory and work down only. Default: entire drive.
	/D	Delete file(s) found (-Marks deleted file(S)). Blank for file list.
	/I	Interactive delete mode.
	/S	Silent operation, do not print to screen.
	/R	Create a test report file of found ans/or deleted file(s).

	Note: Drives A: thru Z:, and all wild cards supported.

	Example:  	FF3 C:\*.BAK D or FF3 C:*.BAK D
				or FF3 *.BAK D (this will operate on the current drive)

	Result:		All files with extension .BAK will be deleted from
				drive C:.

*/


#include <conio.h>
#include <stdio.h>
#include <dir.h>
#include <dos.h>
#include <ctype.h>

char	file[13];							/* file and extension */
char	continous='\r';
FILE    *report_file;
int		x,y;
int		found=0;
int		scroll=0;
int		deleted=0;
int		DELETE,SILENCE,INTERACT,REPORT,CURRENT=0;
int		print_loop=0;


/************************************** START main **************************/
main(int argc, char *argv[])

{

	char	rootpath[80] = " ";					/* set up initial path to search */
	char	*drive;
	char	*del_file;


	param_check(argc, argv);

	path_and_file(argc, argv, &rootpath);

	if (!SILENCE)
		clrscr();


	/* Send warning: About to delete all file on drive */

	if ((!strcmp(file,"*.*")&&DELETE)||(!strcmp(file,"????????.???")&&DELETE)||(!strcmp(file,"????????.*")&&DELETE)||(!strcmp(file,"*.???")&&DELETE))
		{
		printf("\nWARNING: All file on %s drive will be deleted!\n",rootpath);
		printf("Are you sure? (Y/N)");
		do {
			if ((*del_file=toupper(getch()))=='N')
				send_error(6);
			} while (*del_file!='Y'&&*del_file!='N');

		if (!SILENCE)
			clrscr();
		};


	search_proc(rootpath);						/* Call search process */


	/* If no silence parameter, print final results to screen */

	if (!SILENCE)
		{


		y=wherey();
		gotoxy(1,1);
		putchar(' ');
		gotoxy(1,y);
		if (!DELETE)
			printf("\n\t%i File(s) listed.\n",found);
		else
			printf("\n\t%i File(s) deleted. \n",deleted);
		}

	/* If report was selected, close the file */

	if (REPORT)
		fclose(report_file);

	exit();

	return 0;
}
/************************************** END main ****************************/




/************************************** START search_proc *******************/
search_proc(char currentpath[80])

{

	char	nextpath[80];				/* next path to search */
	char	searchpath[80];				/* current search path */
	char	fullname[80];				/* full filename for display */
	char	*del_file;					/* interactive delete response */
	int		done, x, y;					/* check for completion */
	struct	ffblk	ffblk;				/* file block for file info */


	strcpy(searchpath,currentpath);     /* set up search path */
	strcat(searchpath,file);
	done = findfirst(searchpath,&ffblk,0);   /* regular files */

	while (!done) {						/* go thru all files */
		strcpy(fullname,currentpath);	/* set up filename to display */
		strcat(fullname,ffblk.ff_name);

		if (REPORT&&!DELETE)
			{
			fputs(fullname, report_file);
			fputs("\n",report_file);
			}

		if (!SILENCE&&!DELETE)
			{
			y=wherey();
			lines();
			gotoxy(1,y);
			printf("    %s\n",fullname);
			scroll++;
			}
		if (DELETE)
			if (!INTERACT)
				{
				remove(fullname);
				deleted++;
				if (!SILENCE)
					{
					lines();
					gotoxy(2,wherey());
					printf("   %s\n",fullname);
					scroll++;

					};
				if (REPORT)
					{
					fputs(" ",report_file);
					fputs(fullname, report_file);
					fputs("\n", report_file);
					}

				}
			else
				do {
					x=wherex();
					y=wherey();
					lines();
					printf("    %s\n",fullname);
					scroll++;
					printf("    Delete file? (Y/N)");
					*del_file=toupper(getch());
					gotoxy(5,wherey());
					printf("                     ");
					gotoxy(1,wherey()-1);
					if (*del_file=='Y')
						{
						remove(fullname);
						deleted++;
						printf("   %s\n",fullname);

						if (REPORT)
							{
							fputs(" ",report_file);
							fputs(fullname, report_file);
							fputs("\n", report_file);
							}
						}
					else
						{
						printf("    %s\n",fullname);
						if (REPORT)
							{
							fputs("  ",report_file);
							fputs(fullname, report_file);
							fputs("\n", report_file);
							}
						}

				} while (*del_file!='Y'&&*del_file!='N');

		found++;
		done = findnext(&ffblk);		/* who's next */
	}

	strcpy(searchpath,currentpath);		/* reset path, using *.* for file.ext */
	strcat(searchpath,"*.*");

	ticker();

	done = findfirst(searchpath,&ffblk,FA_DIREC);  /* Directories */

	while (!done) {		/* this time, only look at directories */
		if (ffblk.ff_attrib == FA_DIREC && ffblk.ff_name[0] != '.') {
			strcpy(nextpath,currentpath);	/* set up path */
			strcat(nextpath,ffblk.ff_name);
			strcat(nextpath,"\\");
			search_proc(nextpath);			/* recursive call */
		}
		done = findnext(&ffblk);			/* until no more directories */
	}

	return 0;
}
/************************************** END search_proc *********************/



/************************************** START send_error ********************/
send_error(int choice)
{

	clrscr();

	switch (choice)
	{
	case 0: break;
	case 1:	printf("\nsyntax error: Interactive mode and Silent operation connot work together.\n\n"); break;
	case 2:	printf("\nsyntax error: The drive letter must be between A: and Z:.\n\n"); break;
	case 3: printf("\nsyntax error: Duplicate parameters.\n\n"); break;
	case 4: printf("\nsyntax error: Invalid switch in parameter list.\n\n"); break;
	case 5: printf("\nsyntax error: Too many parameters.\n\n"); break;
	case 6: printf("\nprogram terminated: You requested NOT to delete all files.\n\n"); break;
	case 7: printf("\nsystex error: No file name was given for the report.\n\n"); break;
	case 8: printf("\nprogram terminated: Error opening report file. Check path and filename.\n\n");
	case 9: printf("\nsyntax error: Interactive mode cannot function without the /D switch.\n\n");
	default: break;
	}
	printf("Usage:\n");
	printf("FF3 [drive:][filename].[ext] [/C] [/D] [/I] [/S] [/R[drive:]filename[.ext]]\n\n");
	printf("[drive:][filename].[ext]\n");
	printf("\tList or delete file(s) on specified or current drive.\n");
	printf("/C\tStart at current directory and work down only. Default: entire drive.\n");
	printf("/D\tDelete file(s) found (-Marks deleted file(S)). Blank for file list.\n");
	printf("/I\tInteractive delete mode.\n");
	printf("/S\tSilent operation, do not print to screen.\n");
	printf("/R\tCreate a text file with all file(s) found and/or deleted.\n\n");
	printf("Note: Drives A: thru Z:, and all wild cards supported.\n\n");
	printf("Example:  FF3 C:\\*.BAK D or FF3 C:*.BAK D\n");
	printf("          or FF3 *.BAK D (this will operate on the current drive)\n\n");
	printf("Result:   All files with extension .BAK will be deleted from\n");
	printf("          drive C:.\n\n");
	printf("Developed by: P. Spear        v1.20a\n");
	exit();

	return 0;
}
/************************************** END send_error **********************/




/************************************** START lines *************************/
lines()
{
	if (scroll>23)
		{
		if (continous=='\r'&&!DELETE)
			{
			x=wherex();
			y=wherey();
			gotoxy(1,1);
			putchar(' ');
			gotoxy(x,y);
			do	{
				gotoxy(5,25);
				printf("Press 'C' for continous or ENTER for next page");
				continous=toupper(getch());
				gotoxy(5,25);
				printf("                                              ");
				} while (continous!='C'&&continous!='\r');
			}
			scroll=0;
		}

	return 0;
}
/************************************** END lines ***************************/




/************************************** START param_check *******************/
param_check(int argc, char *argv[])
{



	int		report_arg, loop, file_fill=0;
	char	report_file_name[80]=" ";
	char	params[80];
	char	*p,*s;
	char 	ch;

	/* Chech to see if parameters are more than 2 characters long */

	if (argc < 2)
		send_error(0);
	else
		{

		if ((argc-1)>6)
			send_error(5);

		loop=1;
		strcpy(params, argv[loop+++1]);
		while (loop<=(argc-1))
			strcat(params, argv[loop+++1]);

		loop=0;
		s=params;
		while ((p=strchr(s, '/'))!=NULL)
			{
			switch (toupper(*(p+1)))
				{
				case 'C':	if (CURRENT)
								send_error(3);
							else
								CURRENT=1;
							break;
				case 'D':	if (DELETE)
								send_error(3);
							else
								DELETE=1;
							break;
				case 'I':	if (INTERACT)
								send_error(3);
							else
								INTERACT=1;
							break;
				case 'S':	if (SILENCE)
								send_error(3);
							else
								SILENCE=1;
							break;
				case 'R':	if (REPORT)
								send_error(3);
							else
								{
								REPORT=1;

								if (*(p+2)==NULL||*(p+2)=='/')
									send_error(7);
								else
									{
									while ((report_file_name[file_fill]=toupper(*(p+(file_fill+2))))!=NULL&&(*(p+(file_fill+3))!='/'))
										file_fill++;

									if ((report_file=fopen(report_file_name,"w"))==NULL)
										send_error(8);
									};
								}; break;
				default:	send_error(4); break;
				}
			loop++;
			s=p+1;
			}







		/* Send error: cannot interact with a silent screen */

		if (SILENCE&&INTERACT)
			send_error(1);
		else
			if (INTERACT&&!DELETE)
				send_error(9);



	}


	return 0;
}
/************************************** END param_check *********************/



/************************************** START path_and_file *****************/
path_and_file(int argc, char *argv[], char rootpath[80])
{
	int		loop;
	int		position;




	/* Load the file string with file name only, no drive letters */

	position=loop=*(argv[1]+2)=='\\'?3:2;
	if (*(argv[1]+1)==':')
		if (isalpha(*(argv[1])))
			{
			rootpath[0]=toupper(*argv[1]);
			while (*(argv[1]+loop)!=NULL)
				{
				file[loop++-position]=*(argv[1]+loop);
				if (*(argv[1]+loop)=='\\')  /* Only 1 '\' allowed */
					send_error(0);			/* Send error if more than 1 '\' */
				}
			}
		else
			send_error(2);					/* Drive indicator is not of alpha */

	else
		{
		rootpath[0]=getdisk()+'A';
		strcpy(file, argv[1]);				/* No drive was specified */
		}

	if (CURRENT)
		strcat(rootpath, ":");
	else
		strcat(rootpath, ":\\");					/* Load root path */


	return 0;
}
/************************************** END path_and_file *******************/



/************************************** START ticker ************************/
ticker(void)
{
if (!SILENCE)
		{
			x=wherex();
			y=wherey();
			gotoxy(1,1);
			if ((print_loop++%2)==0)
				putchar('\\');
			else
				putchar('/');
			gotoxy(x,y);
		}
return 0;
}
/************************************** END ticker **************************/