#ifndef BYTE
#define BYTE unsigned char
#endif

#ifndef WORD
#define WORD unsigned int
#endif

#ifndef LONG
#define LONG unsigned long
#endif

#ifndef NULL
#if (!defined(M_I86CM) && !defined(M_I86LM))
#define  NULL    0
#else
#define  NULL    0L
#endif
#endif

#ifndef TRUE
#define TRUE	1
#endif

#ifndef FALSE
#define FALSE	0
#endif

/* Scope specifiers */
#define	GLOBAL			0
#define PRIVATE			1
#define MY_SESSION		2
#define ALL_SESSIONS	3

/* Bindery object types (in HIGH-LOW order) */
#define OT_WILD					0xFFFF	/* Matches any type					*/
#define OT_UNKNOWN				0x0000	/* Unknown object type				*/
#define OT_USER					0x0100	/* User								*/
#define OT_USER_GROUP			0x0200	/* Group							*/
#define OT_PRINT_QUEUE			0x0300	/* Print queues						*/
#define OT_FILE_SERVER			0x0400	/* File server						*/
#define OT_JOB_SERVER			0x0500	/* Job server						*/
#define OT_GATEWAY				0x0600	/* Gateway							*/
#define OT_PRINT_SERVER			0x0700	/* Print server						*/
#define OT_ARCHIVE_QUEUE		0x0800	/* Archive queue					*/
#define OT_ARCHIVE_SERVER		0x0900	/* Archive server					*/
#define OT_JOB_QUEUE			0x0A00	/* Job queue						*/
#define OT_ADMINISTRATION		0x0B00	/* Administration object			*/
#define OT_NAS_SNA_GATEWAY		0x2100	/* NAS/SNA Gateway					*/
#define OT_REMOTE_BRIDGE_SERVER	0x2600	/* Remote bridge server				*/
#define OT_TCPIP_GATEWAY		0x2700	/* TCP/IP gateway					*/

/* Bindery object and property flags */
#define BF_STATIC		0x00
#define BF_DYNAMIC		0x01
#define BF_ITEM			0x00
#define BF_SET			0x02

/* Bindery object and property security access levels */
#define BS_ANY_READ			0x00	/* Readable by anyone */
#define BS_LOGGED_READ		0x01	/* Must be logged in to read */
#define BS_OBJECT_READ		0x02	/* Readable by same object or super */
#define BS_SUPER_READ		0x03	/* Readable by supervisor only */
#define BS_BINDERY_READ		0x04	/* Readable only by the bindery */
#define BS_ANY_WRITE		0x00	/* Writeable by anyone */
#define BS_LOGGED_WRITE		0x10	/* Must be logged in to write */
#define BS_OBJECT_WRITE		0x20	/* Writeable by same object or super */
#define BS_SUPER_WRITE		0x30	/* Writeable only by the supervisor */
#define BS_BINDERY_WRITE	0x40	/* Writeable by the bindery only */

/* File Attributes */
#define FA_NORMAL			0x00
#define FA_READ_ONLY		0x01
#define FA_HIDDEN			0x02
#define FA_SYSTEM			0x04
#define FA_EXECUTE_ONLY		0x08
#define FA_DIRECTORY		0x10
#define FA_NEEDS_ARCHIVED	0x20
#define FA_SHAREABLE		0x80

/* Extended file attributes */
#define FA_TRANSACTIONAL	0x10
#define FA_INDEXED			0x20
#define FA_READ_AUDIT		0x40
#define FA_WRITE_AUDIT		0x80

/* Trustee Access Rights in a network directory */
#define TA_NONE				0x00
#define TA_READ				0x01
#define TA_WRITE			0x02
#define TA_OPEN				0x04
#define TA_CREATE			0x08
#define TA_DELETE			0x10
#define TA_OWNERSHIP		0x20
#define TA_SEARCH			0x40
#define TA_MODIFY			0x80
#define TA_ALL				0xFF

/****************************************************************************/

/* Connection information structure */

typedef struct
{
	WORD	connectionID;		/* Connection ID							*/
	WORD	connectFlags;		/* Connection flags							*/
								/* 0x0001 = in use							*/
								/* 0x0002 = private							*/
								/* 0x0004 = logged in						*/
								/* 0x0008 = broadcast available				*/
								/* 0x0010 = aborted							*/
								/* 0x0020 = refuse general broadcasts		*/
								/* 0x0040 = broadcasts disabled				*/
								/* 0x0080 = primary connection				*/
	WORD	sessionID;			/* OS/2 session ID							*/	
	WORD	connectionNumber;	/* Server's connection	number				*/
	BYTE	serverAddr[12];		/* Server's address							*/
	WORD	serverType;			/* Server's object type						*/
	char	serverName[48];		/* Server name								*/
	WORD	clientType;			/* Client's object type						*/
	char	clientName[48];		/* Client's name							*/
} CONNECT_INFO;

#define	CONNECTION_IN_USE				0x0001
#define CONNECTION_PRIVATE				0x0002
#define CONNECTION_LOGGED_IN			0x0004
#define CONNECTION_BROADCAST_AVAILABLE	0x0008
#define CONNECTION_ABORTED				0x0010
#define CONNECTION_REFUSE_GEN_BROADCAST	0x0020
#define CONNECTION_BROADCASTS_DISABLED	0x0040
#define CONNECTION_PRIMARY				0x0080

/****************************************************************************/
/* Routines in the CONNECT module */

/* GetMaximumConnections */
extern void far pascal NWGETMAXIMUMCONNECTIONS(
	WORD far * );				/* Maximum connections supported			*/

/* AttachToFileServer */
extern WORD far pascal NWATTACHTOFILESERVER(
	char far *,					/* File server name							*/
	WORD,						/* Connection Global/Private scope flag		*/
	WORD far * );				/* New connection ID						*/

/* DetachFromFileServer */
extern WORD far pascal NWDETACHFROMFILESERVER(
	WORD );						/* Connection ID							*/

/* LogoutFromFileServer */
extern WORD far pascal NWLOGOUTFROMFILESERVER(
	WORD );						/* Connection ID							*/

/* GetConnectionList */
extern WORD far pascal NWGETCONNECTIONLIST(
	WORD,						/* Mode- MY_SESSION or ALL_SESSIONS			*/
	WORD far *,					/* Buffer where connection list is returned	*/
	WORD,						/* Size of connection list buffer			*/
	WORD far * );				/* Number of connections returned			*/

/* GetConnectionStatus */
extern WORD far pascal NWGETCONNECTIONSTATUS(
	WORD,						/* Connection ID							*/
	CONNECT_INFO far *,			/* Pointer to connection info structure		*/
	WORD );						/* Size of connection info buffer			*/

/* GetFileServerName */
extern WORD far pascal NWGETFILESERVERNAME(
	WORD,						/* Connection ID							*/
	char far * );				/* File server name							*/

/* GetConnectionNumber */
extern WORD far pascal NWGETCONNECTIONNUMBER(
	WORD,						/* Connection ID							*/
	WORD far * );				/* Server connection number					*/

/* GetDefaultConnectionID */
extern WORD far pascal NWGETDEFAULTCONNECTIONID(
	WORD far * );				/* Connection ID							*/

/* GetConnectionID */
extern WORD far pascal NWGETCONNECTIONID(
	BYTE far *,					/* File server name							*/
	WORD,						/* Mode- MY_SESSION, GLOBAL or PRIVATE		*/
	WORD far *,					/* Connection ID							*/
	WORD far * );				/* Connection scope- GLOBAL or PRIVATE		*/

/* SetDriveBase */
extern WORD far pascal NWSETDRIVEBASE(
	WORD,						/* Drive number								*/
	WORD,						/* Connection ID							*/
	BYTE,						/* Base directory handle                    */
	char far *,					/* Directory path							*/
	WORD );						/* Drive Global/Private scope flag			*/

/* DeleteDriveBase */
extern WORD far pascal NWDELETEDRIVEBASE(
	WORD,						/* Drive number								*/
	WORD );						/* Drive Global/Private scope flag			*/

/* GetDriveInformation */
extern WORD far pascal NWGETDRIVEINFORMATION(
	WORD,						/* Drive number								*/
	WORD, 						/* Mode- MY_SESSION, GLOBAL or PRIVATE		*/
	WORD far *,					/* Connection ID							*/
	BYTE far *,					/* Directory handle							*/
	WORD far * );				/* Drive scope GLOBAL or PRIVATE			*/

/* SetPrimaryConnectionID */
extern WORD far pascal NWSETPRIMARYCONNECTIONID(
	WORD );						/* Connection ID							*/

/* GetPrimaryConnectionID */
extern WORD far pascal NWGETPRIMARYCONNECTIONID(
	WORD far * );				/* Connection ID							*/

/* End of routines in the CONNECT module */
/****************************************************************************/
/* Routines in the LOGIN module */
	
/* LoginToFileServer */
extern WORD far pascal NWLOGINTOFILESERVER(
	WORD,						/* Connection ID							*/
	char far *,					/* Object name								*/
	WORD,						/* Object type								*/
	char far * );				/* Password									*/

/* VerifyObjectPassword */
extern WORD far pascal NWVERIFYOBJECTPASSWORD(
	WORD,						/* Connection ID							*/
	char far *,					/* Object name								*/
	WORD,						/* Object type								*/
	char far * );				/* Password									*/

/* ChangeObjectPassword */
extern WORD far pascal NWCHANGEOBJECTPASSWORD(
	WORD,						/* Connection ID							*/
	char far *,					/* Object name								*/
	WORD,						/* Object type								*/
	char far *,					/* Old password								*/
	char far * );				/* New password								*/

/* End of routines in the LOGIN module */
/****************************************************************************/
/* Routines in the BINDERY1 module */

/* ReadPropertyValue */
extern WORD far pascal NWREADPROPERTYVALUE(
	WORD,						/* Connection ID							*/
	char far *,					/* Object name								*/
	WORD,						/* Object type								*/
	char far *,					/* Property name							*/
	BYTE,						/* Segment number							*/
	BYTE far *,					/* Segment data returned here				*/
	BYTE far *,					/* More segments flag						*/
	BYTE far * );				/* Static/Dynamic & Item/Set flag			*/

/* WritePropertyValue */
extern WORD far pascal NWWRITEPROPERTYVALUE(
	WORD,						/* Connection ID							*/
	char far *,					/* Object name								*/
	WORD,						/* Object type								*/
	char far *,					/* Property name							*/
	BYTE,						/* Segment number							*/
	BYTE far *,					/* Data to write							*/
	BYTE );						/* More segments flag						*/

/* AddObjectToSet */
extern WORD far pascal NWADDOBJECTTOSET(
	WORD,						/* Connection ID							*/
	char far *,					/* Set object name							*/
	WORD,						/* Set object type							*/
	char far *,					/* Set property name						*/
	char far *,					/* Member to add object name				*/
	WORD );						/* Member to add object type				*/

/* DeleteObjectFromSet */
extern WORD far pascal NWDELETEOBJECTFROMSET(
	WORD,						/* Connection ID							*/
	char far *,					/* Set object name							*/
	WORD,						/* Set object type							*/
	char far *,					/* Set property name						*/
	char far *,					/* Member to delete object name				*/
	WORD );						/* Member to delete object type				*/

/* IsObjectInSet */
extern WORD far pascal NWISOBJECTINSET(
	WORD,						/* Connection ID							*/
	char far *,					/* Set object name							*/
	WORD,						/* Set object type							*/
	char far *,					/* Set property name						*/
	char far *,					/* Member object name						*/
	WORD );						/* Member object type						*/

/* ScanProperty */
extern WORD far pascal NWSCANPROPERTY(
	WORD,						/* Connection ID							*/
	char far *,					/* Object name								*/
	WORD,						/* Object type								*/
	char far *,					/* Search property name						*/
	LONG far *,					/* Sequence number							*/
	char far *,					/* Found property name						*/
	BYTE far *,					/* Found property flags						*/
	BYTE far *,					/* Found property security					*/
	BYTE far *,					/* Found property has value flag			*/
	BYTE far * );				/* More properties flag						*/

/* GetObjectID */
extern WORD far pascal NWGETOBJECTID(
	WORD,						/* Connection ID							*/
	char far *,					/* Object name								*/
	WORD,						/* Object type								*/
	LONG far * );				/* Object ID								*/

/* GetObjectName */
extern WORD far pascal NWGETOBJECTNAME(
	WORD,						/* Connection ID							*/
	LONG,						/* Object ID								*/
	char far *,					/* Object name								*/
	WORD far * );				/* Object type								*/

/* ScanObject */
extern WORD far pascal NWSCANOBJECT(
	WORD,						/* Connection ID							*/
	char far *,					/* Search object name						*/
	WORD,						/* Search object type						*/
	LONG far *,					/* Object ID (sequence number)				*/
	char far *,					/* Found object name						*/
	WORD far *,					/* Found object type						*/
	BYTE far *,					/* Found object has properties flag			*/
	BYTE far *,					/* Found object flags (dynamic/static)		*/
	BYTE far * );				/* Found object security					*/

/* GetBinderyAccessLevel */
extern WORD far pascal NWGETBINDERYACCESSLEVEL(
	WORD,						/* Connection ID							*/
	BYTE far *,					/* Bindery access level						*/
	LONG far * );				/* Object ID								*/

/* End of routines in the BINDERY1 module */
/****************************************************************************/
/* Routines in the BINDERY2 module */

/* CreateProperty */
extern WORD far pascal NWCREATEPROPERTY(
	WORD,						/* Connection ID							*/
	char far *,					/* Object name								*/
	WORD,						/* Object type								*/
	char far *,					/* New property name						*/
	BYTE,						/* New property flags (dynamic/static,		*/
								/* 						item/set)			*/
	BYTE );						/* New property security					*/

/* DeleteProperty */
extern WORD far pascal NWDELETEPROPERTY(
	WORD,						/* Connection ID							*/
	char far *,					/* Object name								*/
	WORD,						/* Object type								*/
	char far * );				/* Property name							*/

/* ChangePropertySecurity */
extern WORD far pascal NWCHANGEPROPERTYSECURITY(
	WORD,						/* Connection ID							*/
	char far *,					/* Object name								*/
	WORD,						/* Object type								*/
	char far *,					/* Property name							*/
	BYTE );						/* New property security					*/

/* CreateObject */
extern WORD far pascal NWCREATEOBJECT(
	WORD,						/* Connection ID							*/
	char far *,					/* New object name							*/
	WORD,						/* New object type							*/
	BYTE,						/* New object flags (dynamic/static)		*/
	BYTE );						/* New object security						*/

/* DeleteObject */
extern WORD far pascal NWDELETEOBJECT(
	WORD,						/* Connection ID							*/
	char far *,					/* Object name								*/
	WORD );						/* Object type								*/

/* RenameObject */
extern WORD far pascal NWRENAMEOBJECT(
	WORD,						/* Connection ID							*/
	char far *,					/* Old object name							*/
	char far *,					/* New object name							*/
	WORD );						/* Object type								*/

/* ChangeObjectSecurity */
extern WORD far pascal NWCHANGEOBJECTSECURITY(
	WORD,						/* Connection ID							*/
	char far *,					/* Object name								*/
	WORD,						/* Object type								*/
	BYTE );						/* New object security						*/

/* OpenBindery */
extern WORD far pascal NWOPENBINDERY(
	WORD );						/* Connection ID							*/

/* CloseBindery */
extern WORD far pascal NWCLOSEBINDERY(
	WORD );						/* Connection ID							*/

/* ScanObjectTrusteePaths */
extern WORD far pascal NWSCANOBJECTTRUSTEEPATHS(
	WORD,						/* Connection ID							*/
	LONG,						/* Object ID								*/
	BYTE,						/* Volume number							*/
	WORD far *,					/* Sequence number							*/
	BYTE far *,					/* Trustee access rights					*/
	char far * );				/* Directory path							*/

/* End of routines in the BINDERY2 module */
/****************************************************************************/
/* Routines in the VERSION module */

/* GetFileServerDescription */
extern WORD far pascal NWGETFILESERVERDESCRIPTION(
	WORD,						/* Connection ID							*/
	char far *,					/* Company name								*/
	char far *,					/* Revision description						*/
	char far *,					/* Revision date							*/
	char far * );				/* Copyright notice							*/

/* GetRequesterVersion */
extern WORD far pascal NWGETREQUESTERVERSION(
	BYTE far *,					/* Requester major version number			*/
	BYTE far *,					/* Requester minor version number			*/
	BYTE far * );				/* Requester revision number				*/

/* End of routines in the VERSION module */
/****************************************************************************/
/* Routines in the DIR module */

/* AddTrusteeToDirectory */
extern WORD far pascal NWADDTRUSTEETODIRECTORY(
	WORD,						/* Connection ID							*/
	BYTE,						/* NetWare directory handle (0 if path		*/
								/* includes the volume name)				*/
	char far *,					/* Directory path							*/
	LONG,						/* Trustee object ID						*/
	BYTE );						/* Trustee rights mask						*/

/* DeleteTrusteeFromDirectory */
extern WORD far pascal NWDELETETRUSTEEFROMDIRECTORY(
	WORD,						/* Connection ID							*/
	BYTE,						/* NetWare directory handle (0 if path		*/
								/* includes the volume name)				*/
	char far *,					/* Directory path							*/
	LONG );						/* Trustee object ID						*/

/* GetEffectiveDirectoryRights */
extern WORD far pascal NWGETEFFECTIVEDIRECTORYRIGHTS(
	WORD,						/* Connection ID							*/
	BYTE,						/* NetWare directory handle (0 if path		*/
								/* includes the volume name)				*/
	char far *,					/* Directory path							*/
	BYTE far * );				/* Effective rights mask					*/

/* ModifyMaximumRightsMask */
extern WORD far pascal NWMODIFYMAXIMUMRIGHTSMASK(
	WORD,						/* Connection ID							*/
	BYTE,						/* NetWare directory handle (0 if path		*/
								/* includes the volume name)				*/
	char far *,					/* Directory path							*/
	BYTE,						/* Revoke rights mask						*/
	BYTE );						/* Grant rights mask (overrides revoke)		*/

/* ScanDirectoryForTrustees */
extern WORD far pascal NWSCANDIRECTORYFORTRUSTEES(
	WORD,						/* Connection ID							*/
	BYTE,						/* NetWare directory handle (0 if path		*/
								/* includes the volume name)				*/
	char far *,					/* Directory path and search pattern		*/
	WORD far *,					/* Sequence number (initially set to 0)		*/
	char far *,					/* Found directory name						*/
	LONG far *,					/* Directory creation date and time			*/
	LONG far *,					/* Directory owner ID						*/
	LONG far *,					/* Trustee object ID's (array of 5 per call)*/
	BYTE far * );				/* Trustee rights mask (array of 5 per call)*/

/* ScanDirectoryInformation */
extern WORD far pascal NWSCANDIRECTORYINFORMATION(
	WORD,						/* Connection ID							*/
	BYTE,						/* NetWare directory handle (0 if path		*/
								/* includes the volume name)				*/
	char far *,					/* Directory path and search pattern		*/
	WORD far *,					/* Sequence number (initially set to 0)		*/
	char far *,					/* Found directory name						*/
	LONG far *,					/* Directory creation date and time			*/
	LONG far *,					/* Directory owner ID						*/
	BYTE far * );				/* Directory maximum rights mask			*/

/* SetDirectoryInformation */
extern WORD far pascal NWSETDIRECTORYINFORMATION(
	WORD,						/* Connection ID							*/
	BYTE,						/* NetWare directory handle (0 if path		*/
								/* includes the volume name)				*/
	char far *,					/* Directory path							*/
	LONG,						/* New directory creation date and time		*/
	LONG,						/* New directory owner ID					*/
	BYTE );						/* New directory maximum rights mask		*/

/* AllocTemporaryDirectoryHandle */
extern WORD far pascal NWALLOCTEMPORARYDIRECTORYHANDLE(
	WORD,						/* Connection ID							*/
	BYTE,						/* NetWare directory handle (0 if path		*/
								/* includes the volume name)				*/
	char far *,					/* Directory path							*/
	BYTE far *,					/* New directory handle						*/
	BYTE far * );				/* Effective rights mask in directory		*/

/* DeallocateDirectoryHandle */
extern WORD far pascal NWDEALLOCATEDIRECTORYHANDLE(
	WORD,						/* Connection ID							*/
	BYTE );						/* Directory handle to deallocate			*/

/* SetDirectoryHandlePath */
extern WORD far pascal NWSETDIRECTORYHANDLEPATH(
	WORD,						/* Connection ID							*/
	BYTE,						/* Source directory handle					*/
	char far *,					/* Directory path							*/
	BYTE );						/* Directory handle to be set to new path	*/

/* GetDirectoryHandlePath */
extern WORD far pascal NWGETDIRECTORYHANDLEPATH(
	WORD,						/* Connection ID							*/
	BYTE,						/* Directory handle							*/
	char far * );				/* Directory path							*/

/* End of routines in the DIR module */
/****************************************************************************/
/* Routines in the TTS module */

/* TTSIsAvailable */
extern WORD far pascal NWTTSISAVAILABLE(
	WORD );						/* Connection ID							*/

/* TTSBeginTransaction */
extern WORD far pascal NWTTSBEGINTRANSACTION(
	WORD );						/* Connection ID							*/

/* TTSEndTransaction */
extern WORD far pascal NWTTSENDTRANSACTION(
	WORD,						/* Connection ID							*/
	LONG far * );				/* Transaction number						*/

/* TTSAbortTransaction */
extern WORD far pascal NWTTSABORTTRANSACTION(
	WORD );						/* Connection ID							*/

/* TTSTransactionStatus */
extern WORD far pascal NWTTSTRANSACTIONSTATUS(
	WORD,						/* Connection ID							*/
	LONG );						/* Transaction number						*/

/* TTSGetProcessThresholds */
extern WORD far pascal NWTTSGETPROCESSTHRESHOLDS(
	WORD,						/* Connection ID							*/
	BYTE far *,					/* Logical record lock threshold level		*/
	BYTE far * );				/* Physical record lock threshold level		*/

/* TTSSetProcessThresholds */
extern WORD far pascal NWTTSSETPROCESSTHRESHOLDS(
	WORD,						/* Connection ID							*/
	BYTE,						/* Logical record lock threshold level		*/
	BYTE );						/* Physical record lock threshold level		*/

/* TTSGetConnectionThresholds */
extern WORD far pascal NWTTSGETCONNECTIONTHRESHOLDS(
	WORD,						/* Connection ID							*/
	BYTE far *,					/* Logical record lock threshold level		*/
	BYTE far * );				/* Physical record lock threshold level		*/

/* TTSSetConnectionThresholds */
extern WORD far pascal NWTTSSETCONNECTIONTHRESHOLDS(
	WORD,						/* Connection ID							*/
	BYTE,						/* Logical record lock threshold level		*/
	BYTE );						/* Physical record lock threshold level		*/

/* TTSGetControlFlags */
extern WORD far pascal NWTTSGETCONTROLFLAGS(
	WORD,						/* Connection ID							*/
	BYTE far * );				/* TTS control flags (by process)			*/

/* TTSSetControlFlags */
extern WORD far pascal NWTTSSETCONTROLFLAGS(
	WORD,						/* Connection ID							*/
	BYTE );						/* TTS control flags (by process)			*/

/* End of routines in the TTS module */
/****************************************************************************/
/* Routines in the SEMAPHOR module */

/* OpenSemaphore */
extern WORD far pascal NWOPENSEMAPHORE(
	WORD,						/* Connection ID							*/
	char far *,					/* Semaphore name							*/
	int,						/* Initial semaphore value (0 to 127)		*/
	LONG far *,					/* NetWare semaphore handle					*/
	WORD far * );				/* Semaphore open count						*/

/* ExamineSemaphore */
extern WORD far pascal NWEXAMINESEMAPHORE(
	WORD,						/* Connection ID							*/
	LONG,						/* NetWare semaphore handle					*/
	int *,						/* Semaphore value							*/
	WORD * );					/* Semaphore open count						*/

/* WaitOnSempahore */
extern WORD far pascal NWWAITONSEMAPHORE(
	WORD,						/* Connection ID							*/
	LONG,						/* NetWare semaphore handle					*/
	WORD );						/* Time out limit (in 1/18 of a second)		*/

/* SignalSemaphore */
extern WORD far pascal NWSIGNALSEMAPHORE(
	WORD,						/* Connection ID							*/
	LONG );						/* NetWare semaphore handle					*/

/* CloseSemaphore */
extern WORD far pascal NWCLOSESEMAPHORE(
	WORD,						/* Connection ID							*/
	LONG );						/* NetWare semaphore handle					*/

/* End of routines in the SEMAPHOR module */
/****************************************************************************/
/* Routines in the PARSPATH module */

/* ParseNetWarePath */
extern WORD far pascal NWPARSENETWAREPATH(
	char far *,					/* Path to be parsed						*/
	WORD far *,					/* Connection ID							*/
	BYTE far *,					/* Directory handle							*/
	char far * );				/* Path relative to directory handle		*/

/* End of routines in the PARSPATH module */
/****************************************************************************/
/* Routines in the FILE module */

/* GetExtendedFileAttributes */
extern WORD far pascal NWGETEXTENDEDFILEATTRIBUTES(
	char far *,					/* File name (and path)						*/
	BYTE far * );				/* Extended file attributes					*/

/* SetExtendedFileAttributes */
extern WORD far pascal NWSETEXTENDEDFILEATTRIBUTES(
	char far *,					/* File name (and path)						*/
	BYTE );						/* Extended file attributes					*/

/* FileServerFileCopy */
extern WORD far pascal NWFILESERVERFILECOPY(
	WORD,						/* OS/2 DOS source file handle				*/
	WORD,						/* OS/2 DOS destination file handle			*/
	LONG,						/* Source file offset to copy from			*/
	LONG,						/* Destination file offset to copy to		*/
	LONG,						/* Number of bytes to copy					*/
	LONG far * );				/* Number of bytes actually copied			*/

/* GetVolumeInfoWithHandle */
extern WORD far pascal NWGETVOLUMEINFOWITHHANDLE(
	WORD,						/* Connection ID							*/
	BYTE,						/* NetWare directory handle					*/
	char far *,					/* Volume name								*/
	WORD far *,					/* Total Blocks in volume					*/
	WORD far *,					/* Sectors per block (sector=512 bytes)		*/
	WORD far *,					/* Available blocks							*/
	WORD far *,					/* Total directory entries					*/
	WORD far *,					/* Available directory entries				*/
	WORD far * );				/* Volume is removable flag					*/

/* GetVolumeInfoWithNumber */
extern WORD far pascal NWGETVOLUMEINFOWITHNUMBER(
	WORD,						/* Connection ID							*/
	WORD,						/* Volume number							*/
	char far *,					/* Volume name								*/
	WORD far *,					/* Total Blocks in volume					*/
	WORD far *,					/* Sectors per block (sector=512 bytes)		*/
	WORD far *,					/* Available blocks							*/
	WORD far *,					/* Total directory entries					*/
	WORD far *,					/* Available directory entries				*/
	WORD far * );				/* Volume is removable flag					*/

/* GetVolumeName */
extern WORD far pascal NWGETVOLUMENAME(
	WORD,						/* Connection ID							*/
	WORD,						/* Volume number							*/
	char far * );				/* Volume name								*/

/* GetVolumeNumber */
extern WORD far pascal NWGETVOLUMENUMBER(
	WORD,						/* Connection ID							*/
	char far *,					/* Volume name								*/
	WORD far * );				/* Volume number							*/

/* RecoverErasedFile */
extern WORD far pascal NWRESTOREERASEDFILE(
	WORD,						/* Connection ID							*/
	BYTE,						/* NetWare directory handle					*/
	char far *,					/* Directory path							*/
	char far *,					/* Old name of recovered file				*/
	char far * );				/* New name of recovered file				*/

/* PurgeErasedFiles */
extern WORD far pascal NWPURGEERASEDFILES(
	WORD );						/* Connection ID							*/

/* GetFileConnectionID */
WORD far pascal NWGETFILECONNECTIONID(
	WORD fileHandle,			/* OS/2 DOS file handle						*/
	WORD far *connectionID );	/* Connection ID of file server where file	*/
								/* is located								*/

/* End of routines in the FILE module */
/****************************************************************************/
/* Routines in the SERVER module */

/* GetConnectionInformation */
extern WORD far pascal NWGETCONNECTIONINFORMATION(
	WORD,						/* Connection ID							*/
	BYTE,						/* Server connection number					*/
	char far *,					/* Client object name						*/
	WORD far *,					/* Client object type						*/
	LONG far *,					/* Client object ID							*/
	BYTE far * );				/* Client login time						*/
	
/* GetFileServerDateAndTime */
extern WORD far pascal NWGETFILESERVERDATEANDTIME(
	WORD,						/* Connection ID							*/
	BYTE far * );				/* Buffer for date and time					*/

/* GetObjectConnectionNumbers */
extern WORD far pascal NWGETOBJECTCONNECTIONNUMBERS(
	WORD,						/* Connection ID							*/
	char far *,					/* Object name								*/
	WORD,						/* Object type								*/
	WORD far *,					/* Number of connections object is logged in*/
	WORD far *,					/* List of each connection number			*/
	WORD );						/* Max connection numbers that will fit in	*/
								/* the passed connection list (currently	*/
								/* the max that will be returned is 50)		*/

/* GetInternetAddress */
extern WORD far pascal NWGETINTERNETADDRESS(
	WORD,						/* Connection ID							*/
	WORD,						/* Server connection number of station for	*/
								/* which the internet address should be		*/
								/* returned									*/
	BYTE far * );				/* Internet address (10 bytes)				*/

/* GetFileServerInformation */
extern WORD far pascal NWGETFILESERVERINFORMATION(
	WORD,						/* Connection ID							*/
	char far *,					/* File server name							*/
	BYTE far *,					/* OS major version number					*/
	BYTE far *,					/* OS minor version number					*/
	BYTE far *,					/* OS revision number						*/
	WORD far *,					/* Maximum connections supported			*/
	WORD far *,					/* Peak connections used					*/
	WORD far *,					/* Connections currently in use				*/
	WORD far *,					/* Maximum number of volumes supported		*/
	BYTE far *,					/* SFT level supported						*/
	BYTE far * );				/* Transaction tracking supported			*/

extern WORD far pascal NWGETFILESERVEREXTENDEDINFO(
	WORD,						/* Connection ID							*/
	BYTE far *,					/* Accounting version						*/
	BYTE far *,					/* VAP version								*/
	BYTE far *,					/* Queue manager version					*/
	BYTE far *,					/* Internal print server version			*/
	BYTE far *,					/* Virtual console support version			*/
	BYTE far *,					/* Security and restrictions version		*/
	BYTE far * );				/* Internetwork bridging version			*/

/* End of routines in the SERVER module */
/****************************************************************************/
/* Routines in the BROADMSG module */

/* SendBroadcastMessage */
extern WORD far pascal NWSENDBROADCASTMESSAGE(
	WORD,						/* Connection ID							*/
	char far *,					/* Message to broadcast (59 chars max)		*/
	WORD,						/* Number of connections to broadcast to	*/
	WORD far *,					/* List of connection numbers				*/
	BYTE far * );				/* List of result for each broadcast		*/

/* GetBroadcastMode */
extern WORD far pascal NWGETBROADCASTMODE(
	WORD,						/* Connection ID							*/
	WORD far * );				/* Broadcast mode- receive all broadcasts(0)*/
								/* receive only console broadcasts(1),		*/
								/* disable all broadcasts(2)				*/

/* SetBroadcastMode */
extern WORD far pascal NWSETBROADCASTMODE(
	WORD,						/* Connection ID							*/
	WORD );						/* Broadcast mode- receive all broadcasts(0)*/
								/* receive only console broadcasts(1),		*/
								/* disable all broadcasts(2)				*/
/* BroadcastToConsole */
extern WORD far pascal NWBROADCASTTOCONSOLE(
	WORD,						/* Connection ID							*/
	char far * );				/* Message to broadcast (59 chars max)		*/

/* SendConsoleBroadcast */
extern WORD far pascal NWSENDCONSOLEBROADCAST(
	WORD,						/* Connection ID							*/
	char far *,					/* Message to broadcast (59 chars max)		*/
	WORD,						/* Number of connections to broadcast to	*/
								/* (0 means all connections)				*/
	WORD far * );				/* List of connection numbers				*/

/* End of routines in the BROADMSG module */
/****************************************************************************/
/* Routines in the MEMPRIM module */

/* WordSwap */
extern WORD far pascal NWWORDSWAP(
	WORD );						/* Word to be swapped						*/

/* LongSwap */
extern LONG far pascal NWLONGSWAP(
	LONG );						/* Long to be swapped						*/

/* End of routines in the MEMPRIM module */
/****************************************************************************/
/****************************************************************************/

