#ifndef BYTE
#define BYTE unsigned char
#endif

#ifndef WORD
#define WORD unsigned int
#endif

#ifndef LONG
#define LONG unsigned long
#endif

#ifndef NULL
#if (!defined(M_I86CM) && !defined(M_I86LM))
#define  NULL    0
#else
#define  NULL    0L
#endif
#endif

/****************************************************************************/

typedef struct
{
	LONG targetServerID;
	BYTE targetExecutionTime[6];
	BYTE jobDescription[50];
	BYTE jobControlFlags;
	BYTE tabSize;
	WORD numberCopies;
	WORD printFlags;
	WORD maxLines;
	WORD maxChars;
	BYTE formName[16];
	BYTE reserved1[6];	/* must be set to zeros */
	WORD formType;
	BYTE bannerFileName[13];
	BYTE reserved2;		/* must be set to zero */

	/* The following fields can be gotten, but not set */
	WORD connectionID;
	LONG queueID;
	WORD setupStringMaxLength;
	WORD resetStringMaxLength;
} SpoolFlagsStruct;

typedef struct
{
	BYTE clientStation;
	BYTE clientTask;
	LONG clientID;
	LONG targetServerID;
	BYTE targetExecutionTime[6];
	BYTE jobEntryTime[6];
	WORD jobNumber;
	WORD formType;
	BYTE jobPosition;
	BYTE jobControlFlags;
	BYTE jobFileName[14];
	BYTE jobFileHandle[6];
	BYTE servicingServerStation;
	BYTE servicingServerTask;
	LONG servicingServerID;
	BYTE jobDescription[50];

	BYTE clientJobInfoVer;
	BYTE tabSize;
	WORD numberCopies;
	WORD printFlags;
	WORD maxLines;
	WORD maxChars;
	BYTE formName[16];
	BYTE reserved[6]; /* must be set to zeros */
	BYTE bannerUserName[13];
	BYTE bannerFileName[13];
	BYTE bannerHeaderFileName[14];
	BYTE filePathName[80];
} PrintJobStruct;

/****************************************************************************/
/* Routine in the NWPRINT module */

/* SpoolStartCapture */
extern WORD far pascal NWSPOOLSTARTCAPTURE(
	WORD deviceID,
	LONG queueID,
	WORD connectionID,
	WORD scope);

/* SpoolEndCapture */
extern WORD far pascal NWSPOOLENDCAPTURE(
	WORD deviceID,
	WORD scope);

/* SpoolCancelCapture */
extern WORD far pascal NWSPOOLCANCELCAPTURE(
	WORD deviceID,
	WORD scope);

/* SpoolGetPrintJobFlags */
extern WORD far pascal NWSPOOLGETPRINTJOBFLAGS(
	WORD deviceID,
	SpoolFlagsStruct far *getFlags,
	WORD mode,
	WORD far *scope);

/* SpoolSetPrintJobFlags */
extern WORD far pascal NWSPOOLSETPRINTJOBFLAGS(
	WORD deviceID,
	SpoolFlagsStruct far *setFlags,
	WORD scope);

/* SpoolGetBannerUserName */
extern WORD far pascal NWSPOOLGETBANNERUSERNAME(
	char far *userName,
	WORD mode,
	WORD far *scope);

/* SpoolSetBannerUserName */
extern WORD far pascal NWSPOOLSETBANNERUSERNAME(
	char far *userName,
	WORD scope);

/* SpoolGetPrinterSetupString */
extern WORD far pascal NWSPOOLGETPRINTERSETUPSTRING(
	WORD deviceID,
	WORD far *bufferLen,
	char far *buffer,
	WORD mode,
	WORD far *scope);

/* SpoolSetPrinterSetupString */
extern WORD far pascal NWSPOOLSETPRINTERSETUPSTRING(
	WORD deviceID,
	WORD bufferLen,
	char far *buffer,
	WORD scope);

/* SpoolGetPrinterResetString */
extern WORD far pascal NWSPOOLGETPRINTERRESETSTRING(
	WORD deviceID,
	WORD far *bufferLen,
	char far *buffer,
	WORD mode,
	WORD far *scope);

/* SpoolSetPrinterResetString */
extern WORD far pascal NWSPOOLSETPRINTERRESETSTRING(
	WORD deviceID,
	WORD bufferLen,
	char far *buffer,
	WORD scope);

/* End of routines in the NWPRINT module */
/****************************************************************************/
/****************************************************************************/





