/***************************************************************

   NetCom.c

   Tests the NetCom control. We use most of the functions in
   the NetCom control. This is a very simple program because
   it only does "one-shot" communication. If we wanted to handle
   large amounts of data, we would have to add logic for re-posting
   receives and sends as each is completed. This is "left as an
   exercise for the reader".
   
   Modify as you wish.

   Northeast Data Corp.
   April 1, 1994

****************************************************************/
#define  STRICT               
#include <windows.h>
#include <stdlib.h>
#include "NetCom.h"
#include "test.h"

   // Globals
HINSTANCE   hInstMain;
HWND        hWndTheList;

BOOL FAR PASCAL nameCallBack(LPSTR lpszName, int nNameNum);

/***************************************************************

                  Main Window Procedure

****************************************************************/
int PASCAL WinMain (HINSTANCE hInstance, 
                    HINSTANCE hPrevInstance,
                    LPSTR     lpszCmdLine, 
                    int       nCmdShow)
{
   WNDCLASS    wc;
   HWND        hWnd;
   MSG         msg;

   if (!hPrevInstance)
   {
      wc.style          = CS_HREDRAW | CS_VREDRAW;
      wc.lpfnWndProc    = testWndProc;
      wc.cbClsExtra     = 0;
      wc.cbWndExtra     = 0;
      wc.hInstance      = hInstance;
      wc.hIcon          = LoadIcon(hInstance, "testIcon");
      wc.hCursor        = LoadCursor(NULL, IDC_ARROW);
      wc.hbrBackground  = (HBRUSH)(COLOR_WINDOW + 1);
      wc.lpszMenuName   = "testMenu";
      wc.lpszClassName  = "NetComtest";


      if (!RegisterClass(&wc))
         return FALSE;
   }

   hInstMain=hInstance;

   //Create and show main window.
   hWnd=CreateWindow("NetComtest", "NetCom Test",
                     WS_MINIMIZEBOX | WS_OVERLAPPEDWINDOW,
                     35, 35, 350, 340,
                     NULL, NULL, hInstance, NULL);

   ShowWindow(hWnd, nCmdShow);
   UpdateWindow(hWnd);

     // Force the dll to load
   registerNetCom();

   while (GetMessage(&msg, NULL, 0, 0))
   {
      TranslateMessage(&msg);
      DispatchMessage(&msg);
   }

   return msg.wParam;
}



/*
 * testWndProc
 *
 * Purpose:
 *  Window class procedure.  Standard callback.
 *
 */
long FAR PASCAL testWndProc(WNDPARAMS)
{

   switch (message)
   {
      case WM_CREATE:
         break;

      case WM_DESTROY:
         PostQuitMessage(0);
         break;

      case WM_COMMAND:
         switch (wParam)
         {
            case IDM_EXIT:
               PostMessage(hWnd, WM_CLOSE, 0, 0L);
               break;

            case IDM_DATAGRAMS:
               DialogBox(hInstMain,
                         "DATAGRAMS",
                         hWnd,
                         datagramProc);
               break;

            case IDM_SESSIONS:
               DialogBox(hInstMain,
                         "SESSIONS",
                         hWnd,
                         sessionProc);
               break;

            case IDM_ABOUT:
               break;
         }
         break;

      default:
          return (DefWindowProc(hWnd, message, wParam, lParam));
   }

   return 0L;
}

/********************************************************************

   datagramProc

   The dialog box procedure for sending datagrams.

*********************************************************************/
BOOL FAR PASCAL datagramProc(WNDPARAMS)
{
   HWND              hWndNet;
   LRESULT           lResult;
   char              szTemp[1024];
   char              szFrom[40];
   HANDLE            hRecData;
   LPRECINFOSTRUCT   lpRec;
   FARPROC           lpfnCallBack;
   int               tabs[]={80};

   switch (message)
   {
      case WM_INITDIALOG:

            // Set the tabstops in the listbox
         SendDlgItemMessage(hWnd,IDC_NETNAMES,
                            LB_SETTABSTOPS,1,(LPARAM)(int FAR *)&tabs);
         return TRUE;

      case WM_COMMAND:

            // Get a handle to the netcom control
         hWndNet=GetDlgItem(hWnd,IDC_NETCOM);

         switch (wParam)
         {
            case IDC_NETCOM:

                  // Handle notifications from the NetCom control
               switch (LOWORD(lParam))
               {
                  case NCN_RECEIVEDDATAGRAM:

                        // Get the data - it's in the handle given in
                        //  the high word of lParam
                     hRecData=(HANDLE)HIWORD(lParam);
                     if (hRecData)
                     {
                           // Get a pointer to the data
                        lpRec=GlobalLock(hRecData);

                           // Terminate the data - we'll assume 
                           //  it's a string (which you can't do in
                           //  real life).
                        *(lpRec->lpData+lpRec->nLen)=0;

                           // Display the data
                        wsprintf(szFrom,"Datagram from %s",(LPSTR)(lpRec->szFrom));
                        MessageBox(hWnd,(LPSTR)(lpRec->lpData),(LPSTR)szFrom,MB_OK);

                           // We have to unlock the handle before 
                           //  returning. NetCom will free this memory
                           //  for us.
                        GlobalUnlock(hRecData);
                     }
                     break;
               }
               break;

            case IDC_INITIALIZE:

                  // Turn the TRACE on so we can see what's happening
                  //  step by step.
               lResult=SendMessage(hWndNet,NCM_SETTRACE,TRUE,0L);

                  // Send the INITIALIZE command
               lResult=SendMessage(hWndNet,NCM_SETCOMMAND,
                                   NCC_INIT,(LPARAM)(LPSTR)szTemp);

                  // szTemp has the permanent node name - display it
               SetDlgItemText(hWnd,IDC_PERMNAME,szTemp);
               break;

            case IDC_ADDGROUP:

                  // Use the local name for the net name
               GetDlgItemText(hWnd,IDC_LOCALNAME,szTemp,sizeof(szTemp));

                  // A blank name is not allowed
               if (lstrlen(szTemp)<1)
                  MessageBox(hWnd,"You must enter a local name","NetCom Test",
                             MB_OK);
               else
               {
                  lResult=SendMessage(hWndNet,NCM_SETNAME,lstrlen(szTemp),(LPARAM)(LPSTR)szTemp);

                  lResult=SendMessage(hWndNet,NCM_SETCOMMAND,NCC_REGISTERGROUP,0L);
               }
               break;

            case IDC_ADDUNIQUE:

                  // Use the local name for the net name
               GetDlgItemText(hWnd,IDC_LOCALNAME,szTemp,sizeof(szTemp));

                  // A blank name is not allowed
               if (lstrlen(szTemp)<1)
                  MessageBox(hWnd,"You must enter a local name","NetCom Test",
                             MB_OK);
               else
               {
                  lResult=SendMessage(hWndNet,NCM_SETNAME,lstrlen(szTemp),(LPARAM)(LPSTR)szTemp);

                  lResult=SendMessage(hWndNet,NCM_SETCOMMAND,NCC_REGISTERNAME,0L);
               }
               break;

            case IDC_DELETE:

                  // Use the local name for the net name
               GetDlgItemText(hWnd,IDC_LOCALNAME,szTemp,sizeof(szTemp));

                  // A blank name is not allowed
               if (lstrlen(szTemp)<1)
                  MessageBox(hWnd,"You must enter a local name","NetCom Test",
                             MB_OK);
               else
               {
                  lResult=SendMessage(hWndNet,NCM_SETNAME,lstrlen(szTemp),(LPARAM)(LPSTR)szTemp);

                  lResult=SendMessage(hWndNet,NCM_SETCOMMAND,NCC_DELETENAME,0L);
               }
               break;

            case IDC_SENDDATAGRAM:

                  // Get the data to send
               GetDlgItemText(hWnd,IDC_SENDDATA,szTemp,sizeof(szTemp));

                  // Tell the NetCom control what the data is
               lResult=SendMessage(hWndNet,NCM_SETDATA,lstrlen(szTemp),(LPARAM)(LPSTR)szTemp);

                  // Set the local name
               GetDlgItemText(hWnd,IDC_LOCALNAME,szTemp,sizeof(szTemp));
               lResult=SendMessage(hWndNet,NCM_SETNAME,lstrlen(szTemp),(LPARAM)(LPSTR)szTemp);

                  // Set the remote name
               GetDlgItemText(hWnd,IDC_REMOTENAME,szTemp,sizeof(szTemp));
               lResult=SendMessage(hWndNet,NCM_SETREMOTENAME,lstrlen(szTemp),(LPARAM)(LPSTR)szTemp);

                  // Tell NetCom to send the datagram
               lResult=SendMessage(hWndNet,NCM_SETCOMMAND,NCC_SENDDATAGRAM,0L);
               break;

            case IDC_RECEIVEDATAGRAM:

                  // Set the local name
               GetDlgItemText(hWnd,IDC_LOCALNAME,szTemp,sizeof(szTemp));
               lResult=SendMessage(hWndNet,NCM_SETNAME,lstrlen(szTemp),(LPARAM)(LPSTR)szTemp);

                  // Tell NetCom to post a listen for a datagram
               lResult=SendMessage(hWndNet,NCM_SETCOMMAND,NCC_RECEIVEDATAGRAM,0L);
               break;

            case IDC_CANCELALL:

                  // Cancel all requests
               lResult=SendMessage(hWndNet,NCM_SETCOMMAND,NCC_CANCELALL,0L);
               break;

            case IDC_RESETADAPTER:

                  // Reset the network adapter (all names will be cleared!!)

                  // Set the remote name  (* for our local adapter)
               GetDlgItemText(hWnd,IDC_REMOTENAME,szTemp,sizeof(szTemp));
               lResult=SendMessage(hWndNet,NCM_SETREMOTENAME,lstrlen(szTemp),(LPARAM)(LPSTR)szTemp);

               lResult=SendMessage(hWndNet,NCM_SETCOMMAND,NCC_RESET,0L);
               break;

            case IDC_ADAPTERSTATUS:

                  // Display the adapter status

                  // Set the remote name  (* for our local adapter)
               GetDlgItemText(hWnd,IDC_REMOTENAME,szTemp,sizeof(szTemp));
               lResult=SendMessage(hWndNet,NCM_SETREMOTENAME,lstrlen(szTemp),(LPARAM)(LPSTR)szTemp);

               lResult=SendMessage(hWndNet,NCM_SETCOMMAND,
                                   NCC_ADAPTERSTATUS,0L);
               break;

            case IDC_LISTNAMES:

                  // Get a list of names from the NetBios name table

                  // Set the remote name  (* for our local adapter)
               GetDlgItemText(hWnd,IDC_REMOTENAME,szTemp,sizeof(szTemp));
               lResult=SendMessage(hWndNet,NCM_SETREMOTENAME,lstrlen(szTemp),(LPARAM)(LPSTR)szTemp);

                  // Put the listbox window handle into a global variable so
                  //  the callback routine can access it.
               hWndTheList=GetDlgItem(hWnd,IDC_NETNAMES);
 
                  // Clear out the current name list
               SendMessage(hWndTheList,LB_RESETCONTENT,0,0L);

                  // Call the service and let our callback handle the
                  //  names that get sent back. 
               lpfnCallBack=MakeProcInstance((FARPROC)nameCallBack,hInstMain);
               lResult=SendMessage(hWndNet,NCM_SETCOMMAND,
                                   NCC_LISTNAMES,(LPARAM)lpfnCallBack);
               FreeProcInstance(lpfnCallBack);
               break;

            case IDOK:
            case IDCANCEL:
               EndDialog(hWnd,FALSE);
               break;
         }
   }
   return FALSE;
}

/********************************************************************

   nameCallBack

   The callback function for getting the netbios names from the
   NetCom control.

*********************************************************************/
BOOL FAR PASCAL nameCallBack(LPSTR lpszName, int nNameNum)
{
   char     szTemp[100];

      // Build a string for the listbox
   wsprintf(szTemp,"%-17.17s\t%d",(LPSTR)lpszName,nNameNum);

      // Put into listbox
   SendMessage(hWndTheList, LB_ADDSTRING,0,(LPARAM)(LPSTR)szTemp);

      // Tell NetCom to send us the next one (0 tells it to quit,
      //  but we want all of them). We could do some error checking
      //  on the listbox and stop NetCom if an error occurred.
   return 1;
}

/********************************************************************

   sessionProc

   The dialog box procedure for establishing and using sessions.

   This is a simplistic demonstration. If we want to handle multiple
   sessions, we would have to keep track of the session numbers that
   are established and set the appropriate send and receive session
   values at the proper time.
   

*********************************************************************/
BOOL FAR PASCAL sessionProc(WNDPARAMS)
{
   HWND              hWndNet;
   LRESULT           lResult;
   char              szTemp[1024];
   char              szFrom[60];
   HANDLE            hRecData;
   LPRECINFOSTRUCT   lpRec;

   switch (message)
   {
      case WM_COMMAND:

            // Get a handle to the netcom control
         hWndNet=GetDlgItem(hWnd,IDC_NETCOM);

         switch (wParam)
         {
            case IDC_NETCOM:

                  // Handle notifications from the NetCom control
               switch (LOWORD(lParam))
               {
                  case NCN_RECEIVEDDATA:

                        // Get the data - it's in the handle given in
                        //  the high word of lParam
                     hRecData=(HANDLE)HIWORD(lParam);
                     if (hRecData)
                     {
                           // Get a pointer to the data
                        lpRec=GlobalLock(hRecData);

                           // Terminate the data - we'll assume it's 
                           //   null-terminated string (not always true)
                        *(lpRec->lpData+lpRec->nLen)=0;

                           // Display the data
                        wsprintf(szFrom,"Data on session %s",(LPSTR)(lpRec->szFrom));
                        MessageBox(hWnd,lpRec->lpData,szFrom,MB_OK);

                           // We have to unlock the handle before 
                           //  returning. NetCom will free this memory
                           //  for us.
                        GlobalUnlock(hRecData);
                     }
                     break;

                  case NCN_SESSIONCLOSED:

                        // The hiword of lParam contains the session number
                     wsprintf(szFrom,"Session %d closed",HIWORD(lParam));
                     MessageBox(hWnd,szFrom,"NetCom",MB_OK);
                     break;

                  case NCN_SENDCOMPLETE:

                        // The hiword of lParam contains the session number
                     wsprintf(szFrom,"Send complete on session %d",HIWORD(lParam));
                     MessageBox(hWnd,szFrom,"NetCom",MB_OK);
                     break;

                  case NCN_NEWRECSESSION:

                        // The hiword of lParam contains the session number
                     wsprintf(szFrom,"New Receive session: %d",HIWORD(lParam));
                     MessageBox(hWnd,szFrom,"NetCom",MB_OK);
                     break;

                  case NCN_NEWSENDSESSION:

                        // The hiword of lParam contains the session number
                     wsprintf(szFrom,"New Send session: %d",HIWORD(lParam));
                     MessageBox(hWnd,szFrom,"NetCom",MB_OK);
                     break;
               }
               break;

            case IDC_INITIALIZE:

                  // Turn the TRACE on
               lResult=SendMessage(hWndNet,NCM_SETTRACE,TRUE,0L);

                  // Send the INITIALIZE command
               lResult=SendMessage(hWndNet,NCM_SETCOMMAND,
                                   NCC_INIT,(LPARAM)(LPSTR)szTemp);

                  // szTemp has the permanent node name
               SetDlgItemText(hWnd,IDC_PERMNAME,szTemp);
               break;

            case IDC_ADAPTERSTATUS:

                  // Display the adapter status

                  // Set the remote name  (* for our local adapter)
               GetDlgItemText(hWnd,IDC_REMOTENAME,szTemp,sizeof(szTemp));
               lResult=SendMessage(hWndNet,NCM_SETREMOTENAME,lstrlen(szTemp),(LPARAM)(LPSTR)szTemp);

               lResult=SendMessage(hWndNet,NCM_SETCOMMAND,
                                   NCC_ADAPTERSTATUS,0L);
               break;

            case IDC_ADDGROUP:

                  // Use the local name for the net name
               GetDlgItemText(hWnd,IDC_LOCALNAME,szTemp,sizeof(szTemp));

                  // A blank name is not allowed
               if (lstrlen(szTemp)<1)
                  MessageBox(hWnd,"You must enter a local name","NetCom Test",
                             MB_OK);
               else
               {
                  lResult=SendMessage(hWndNet,NCM_SETNAME,lstrlen(szTemp),(LPARAM)(LPSTR)szTemp);

                  lResult=SendMessage(hWndNet,NCM_SETCOMMAND,NCC_REGISTERGROUP,0L);
               }
               break;


            case IDC_ADDUNIQUE:

                  // Use the local name for the net name
               GetDlgItemText(hWnd,IDC_LOCALNAME,szTemp,sizeof(szTemp));

                  // A blank name is not allowed
               if (lstrlen(szTemp)<1)
                  MessageBox(hWnd,"You must enter a local name","NetCom Test",
                             MB_OK);
               else
               {
                  lResult=SendMessage(hWndNet,NCM_SETNAME,lstrlen(szTemp),(LPARAM)(LPSTR)szTemp);

                  lResult=SendMessage(hWndNet,NCM_SETCOMMAND,NCC_REGISTERNAME,0L);
               }
               break;

            case IDC_DELETE:

                  // Use the local name for the net name
               GetDlgItemText(hWnd,IDC_LOCALNAME,szTemp,sizeof(szTemp));

                  // A blank name is not allowed
               if (lstrlen(szTemp)<1)
                  MessageBox(hWnd,"You must enter a local name","NetCom Test",
                             MB_OK);
               else
               {
                  lResult=SendMessage(hWndNet,NCM_SETNAME,lstrlen(szTemp),(LPARAM)(LPSTR)szTemp);

                  lResult=SendMessage(hWndNet,NCM_SETCOMMAND,NCC_DELETENAME,0L);
               }
               break;

            case IDC_CALL:

                  // Call the name in the Remote Name edit box

                  // Set the local name
               GetDlgItemText(hWnd,IDC_LOCALNAME,szTemp,sizeof(szTemp));
               lResult=SendMessage(hWndNet,NCM_SETNAME,lstrlen(szTemp),(LPARAM)(LPSTR)szTemp);

                  // Set the remote name
               GetDlgItemText(hWnd,IDC_REMOTENAME,szTemp,sizeof(szTemp));
               lResult=SendMessage(hWndNet,NCM_SETREMOTENAME,lstrlen(szTemp),(LPARAM)(LPSTR)szTemp);

                  // Tell NetCom to do the call
               lResult=SendMessage(hWndNet,NCM_SETCOMMAND,NCC_CALL,0L);
               break;

            case IDC_LISTEN:

                  // Set up a listen on the name in the Remote Name edit box

                  // Set the local name
               GetDlgItemText(hWnd,IDC_LOCALNAME,szTemp,sizeof(szTemp));
               lResult=SendMessage(hWndNet,NCM_SETNAME,lstrlen(szTemp),(LPARAM)(LPSTR)szTemp);

                  // Set the remote name
               GetDlgItemText(hWnd,IDC_REMOTENAME,szTemp,sizeof(szTemp));
               lResult=SendMessage(hWndNet,NCM_SETREMOTENAME,lstrlen(szTemp),(LPARAM)(LPSTR)szTemp);

                  // Tell NetCom to set up the listen
               lResult=SendMessage(hWndNet,NCM_SETCOMMAND,NCC_LISTEN,0L);
               break;

            case IDC_SENDDATA:

                  // Get the data to send
               GetDlgItemText(hWnd,IDC_DATA,szTemp,sizeof(szTemp));

                  // Tell the NetCom control what the data is
               lResult=SendMessage(hWndNet,NCM_SETDATA,lstrlen(szTemp),(LPARAM)(LPSTR)szTemp);

                  // Tell NetCom to send the data
               lResult=SendMessage(hWndNet,NCM_SETCOMMAND,NCC_SEND,0L);
               break;

            case IDC_RECEIVE:

                  // Tell NetCom to post a receive for the current
                  //  receive session
               lResult=SendMessage(hWndNet,NCM_SETCOMMAND,NCC_RECEIVE,0L);
               break;

            case IDC_HANGUPSEND:

                  // Tell NetCom to hangup on the current SEND session
               lResult=SendMessage(hWndNet,NCM_SETCOMMAND,NCC_HANGUPONSEND,0L);
               break;

            case IDC_HANGUPRECEIVE:

                  // Tell NetCom to hangup on the current RECEIVE session
               lResult=SendMessage(hWndNet,NCM_SETCOMMAND,NCC_HANGUPONREC,0L);
               break;

            case IDC_CANCELALL:

                  // Cancel all requests
               lResult=SendMessage(hWndNet,NCM_SETCOMMAND,NCC_CANCELALL,0L);
               break;

            case IDC_RESETADAPTER:

                  // Reset the network adapter (all names will be cleared!!)

                  // Set the remote name  (* for our local adapter)
               GetDlgItemText(hWnd,IDC_REMOTENAME,szTemp,sizeof(szTemp));
               lResult=SendMessage(hWndNet,NCM_SETREMOTENAME,lstrlen(szTemp),(LPARAM)(LPSTR)szTemp);

               lResult=SendMessage(hWndNet,NCM_SETCOMMAND,NCC_RESET,0L);
               break;

            case IDCANCEL:
            case IDOK:
               EndDialog(hWnd,FALSE);
               break;
         }
   }
   return FALSE;
}



