;libreria de rutinas para netware
;Autor: Carlos San Miguel
;Copyright (c) 1991 Carlos San Miguel
;Copyright (c) 1991 ProSoft

;*this library is a set of netware specific subroutines that are designed to
;*be linked with PDS 7.1. All the original comments were written in Spanish and
;*were left in the source file. The English comments begin with ;* and were added
;*for cumpuserve users to read. As you will see some of the original comments were
;*written in english so could say we are talking spanglish.

;*Assemble with MASM 5.1
;*     masm netware;
;*then create a library with lib.exe

;esta rutina nos da el numero de la estacion de trabajo
;sintaxis:  GetConnectionNumber NumeroDeConeccion

;*this routine returns the connection number of the current workstation
;*sintax:  GetConnectionNumber NumeroDeConeccion%

.Model Medium, BASIC
.Code

GetConnectionNumber Proc Uses SI AX CX, Address:Ptr

	XOR AX,AX		;zero out AX
	MOV AH,0DCh		;function DCh get connection number
	INT 21h			;go do it
	MOV SI,Address
	MOV [SI],AL
	RET
GetConnectionNumber EndP

;esta rutina nos da informacion de la estacion de trabajo
;primero se tiene que llamar a la rutina GetConnectionNumber
;sintaxis:
;    GetConnectionInfo VARPTR(ReqBuf), VARSEG(ReqBuf), VARPTR(RepBuf), VARSEG(RepBuf)
;
;en donde las variables ReqBuf y RepBuf tienen la siguiente estructura:

;*this sub returns workstation info.
;*first you have to call GetConnectionNumber and pass the connection
;*number to this routine

;sintax:
;    GetConnectionInfo VARPTR(ReqBuf), VARSEG(ReqBuf), VARPTR(RepBuf), VARSEG(RepBuf)
;
;where the vars ReqBuf y RepBuf have the next structure

;TYPE RequestBuffer
;     ReqBufLen AS INTEGER
;     Phantom   AS STRING * 1
;     ConNumber AS STRING * 1
;END TYPE
;DIM ReqBuf AS RequestBuffer
;
;TYPE ReplyBuffer
;     RepBufLen AS INTEGER      
;     ObjId     AS STRING * 4
;     ObjType   AS STRING * 2
;     ObjName   AS STRING * 48
;     LogYear   AS STRING * 1
;     LogMonth  AS STRING * 1
;     LogDay    AS STRING * 1
;     LogHour   AS STRING * 1
;     LogMinute AS STRING * 1
;     LogSecond AS STRING * 1
;     LogWDay   AS STRING * 1
;END TYPE
;
;DIM RepBuf AS ReplyBuffer
;
;las siguientes variables tienen que ser inicializdas antes de llamar
; a GetConnectionInfo
;*the following vars must be initialized before calling GetConnectionInfo

;ReqBuf.ReqBufLen = LEN(ReqBuf)
;ReqBuf.Phantom   = CHR$(&H16)
;ReqBuf.ConNumber = CHR$(NumeroDeConeccion)    'NumeroDeConeccion es el numero
;                                              'que nos regresa GetConnectionNumber
;                                              '*NumeroDeConeccion is the connection
;                                              '*number returned by GetConnectionNumber
;RepBuf.RepBufLen = LEN(RepBuf)

GetConnectionInfo Proc Uses DS ES SI DI AX CX, ReqBufAdr:Ptr, ReqBufSeg:Ptr, RepBufAdr:Ptr, RepBufSeg:Ptr

   MOV SI,ReqBufSeg        ;segment of request buffer into DS
   MOV DS,[SI]
   MOV SI,RepBufSeg        ;segment of reply buffer into ES
   MOV ES,[SI]
   MOV SI,ReqBufAdr        ;address of request buffer into AX
   MOV AX,[SI]
   MOV SI,RepBufAdr        ;address of reply buffer into DI
   MOV DI,[SI]
   MOV SI,AX
	XOR AX,AX		;zero out AX
	MOV AH,0E3h		;function E3h get connection number info
	INT 21h			;go do it
	RET
GetConnectionInfo EndP

;esta subrutina tiene el mismo efecto que el comando logout
;*this sub has the same effect as the logout command

Logout Proc Uses AX

	XOR AX,AX		;zero out AX
	MOV AH,0D7h		;function D7h logout
	INT 21h			;go do it
	RET
Logout EndP

;*the next set of subs are for redirecting printing to any of the
;*printers on the file server

;esta rutina lee las banderas default de captura
;sintaxis:
;    GetDefaultCaptureFlags LEN((RepBuf), VARSEG(ReqBuf), VARPTR(ReqBuf)
;
;en donde la variable ReqBuf tiene la siguiente estructura:

;*this sub returns the current cature flags. You would call this sub to save
;*the current settings before redirecting the printer. And after you have sent
;*your printing to the server you would reset the capture flags to their original
;*settings. That way you can switch between printing to a local printer and a 
;*network printer.
;sintax:
;    GetDefaultCaptureFlags LEN((RepBuf), VARSEG(ReqBuf), VARPTR(ReqBuf)
;
;where ReqBuf has the next structure:


;TYPE ReplyBuffer
;     Status    AS STRING * 1
;     Flags     AS STRING * 1
;     TabSize   AS STRING * 1
;     ServerPrn AS STRING * 1
;     Copies    AS STRING * 1
;     FromType  AS STRING * 1
;     Reserved1 AS STRING * 1
;     BannerTxt AS STRING * 13
;     Reserved2 AS STRING * 1
;     LocalPrn  AS STRING * 1
;     FCTO      AS INTEGER
;     FCODC     AS STRING * 1
;     MaxLines  AS INTEGER
;     MaxChars  AS INTEGER
;     FormName  AS STRING * 13
;     LptCapFlg AS STRING * 1
;     FilCapFlg AS STRING * 1
;     TimingOut AS STRING * 1
;     Addr1     AS STRING * 1
;     Addr2     AS STRING * 1
;     CIQPJ     AS STRING * 1
;     CIP       AS STRING * 1
;     PQF       AS STRING * 1
;     PJV       AS STRING * 1
;     PQID      AS STRING * 4
;     PJN       AS STRING * 4
;END TYPE
;
;DIM RepBuf AS ReplyBuffer
;
GetDefaultCaptureFlags Proc Uses DS ES SI DI AX CX, Lenght:Ptr, RepBufSeg:Ptr, RepBufAdr:Ptr

	XOR AX,AX		;zero out AX
	MOV AH,0B8h		;function B8h
	MOV AL,00h
   MOV SI,RepBufSeg        ;segment of reply buffer into ES
   MOV ES,[SI]
   MOV SI,RepBufAdr        ;address of reply buffer into BX
   MOV BX,[SI]
   MOV SI, Lenght          ;get length of repbuf
   MOV CX, [SI]            ;into CX
   INT 21h
   RET
GetDefaultCaptureFlags EndP

;esta rutina prepara las banderas default de captura
;sintaxis:
;    SetDefaultCaptureFlags LEN((RepBuf), VARSEG(ReqBuf), VARPTR(ReqBuf)
;
;en donde la variable ReqBuf tiene la siguiente estructura:

;*this sub sets the default capture flags. With this sub you can tell Netware
;*which network printer you want to use as well as the number of 
;*copies of you want to print and some other flags.
;*
;*sintax:
;*    SetDefaultCaptureFlags LEN((RepBuf), VARSEG(ReqBuf), VARPTR(ReqBuf)
;*
;*where ReqBuf has the next structure

;TYPE ReplyBuffer
;     Status    AS STRING * 1
;     Flags     AS STRING * 1
;     TabSize   AS STRING * 1
;     ServerPrn AS STRING * 1
;     Copies    AS STRING * 1
;     FromType  AS STRING * 1
;     Reserved1 AS STRING * 1
;     BannerTxt AS STRING * 13
;     Reserved2 AS STRING * 1
;     LocalPrn  AS STRING * 1
;     FCTO      AS INTEGER
;     FCODC     AS STRING * 1
;     MaxLines  AS INTEGER
;     MaxChars  AS INTEGER
;     FormName  AS STRING * 13
;     LptCapFlg AS STRING * 1
;     FilCapFlg AS STRING * 1
;     TimingOut AS STRING * 1
;     Addr1     AS STRING * 1
;     Addr2     AS STRING * 1
;     CIQPJ     AS STRING * 1
;     CIP       AS STRING * 1
;     PQF       AS STRING * 1
;     PJV       AS STRING * 1
;     PQID      AS STRING * 4
;     PJN       AS STRING * 4
;END TYPE
;
;DIM RepBuf AS ReplyBuffer
;
SetDefaultCaptureFlags Proc Uses DS ES SI DI AX CX, Lenght:Ptr, RepBufSeg:Ptr, RepBufAdr:Ptr

	XOR AX,AX		;AX = 0
	MOV AH,0B8h		;funcion B8h
	MOV AL,01h      ;sub funcion 01h
   MOV SI,RepBufSeg        ;segmento de la estructura en ES
   MOV ES,[SI]
   MOV SI,RepBufAdr        ;direccion de la estructura en BX
   MOV BX,[SI]
   MOV SI, Lenght          ;longitud de la estructura en CX
   MOV CX, [SI]            ;into CX
   INT 21h                 ;ejecutar la instruccion
   RET
SetDefaultCaptureFlags EndP

;esta subrutina inicia la captura de la impresora default
;*after you have set the capture glas with the sub above, you have to
;*let Netware know that you want to start printing on the network printer.
;*use this next sub to start sending to the network printer. It opens a capture
;*file that can later be sent to the queue with the EndCapture sub.

StartCapture Proc Uses AX DX

	XOR AX,AX		;AX = 0
	MOV AH,0DFh		;funcion DFh 
   mov dl,00h      ;dl = 0
	INT 21h			;ejecutar la operacion
	RET
StartCapture EndP

;esta subrutina finaliza la captura de la impresora default
;*This sub ends the redirection of the printer. When you are done printing
;*on the network printer, you call this sub to let Netware know that you
;*do not want your printing redirected any more. The capture file is closed and
;*sent to the queue.

EndCapture Proc Uses AX DX

	XOR AX,AX		;AX = 0
	MOV AH,0DFh		;funcion DFh 
   mov dl,01h      ;dl = 1
	INT 21h			;ejecutar la operacion
	RET
EndCapture EndP

;esta subrutina finaliza la captura de la impresora default
;*this sub cancels any redirection that has been sent to the network
;*printer since the last StartCapture call, and deletes the capture file

CancelCapture Proc Uses AX DX

	XOR AX,AX		;AX = 0
	MOV AH,0DFh		;funcion DFh 
   mov dl,02h      ;dl = 2
	INT 21h			;ejecutar la operacion
	RET
CancelCapture EndP

;esta rutina obtiene los derechos efectivos de un directorio del usuario
;sintaxis:
;    GetEffectiveDirRights VARSEG((RepBuf), VARPTR(RepBuf), VARSEG(ReqBuf), VARPTR(ReqBuf)
;
;en donde la variables ReqBuf y RepBuf tienen las siguientes estructuras:

;*this sub get the effective directory rights of the user
;*
;*sintax:
;*   GetEffectiveDirRights VARSEG((RepBuf), VARPTR(RepBuf), VARSEG(ReqBuf), VARPTR(ReqBuf), ErCode
;*
;*where ReqBuf and RepBuf have the next structures:

;TYPE RequestBuffer
;     BufLen    AS INTEGER         'request buffer length - 2
;     Constant  AS STRING * 1
;     DirHandle AS STRING * 1
;     PathLen   AS STRING * 1
;     Path      AS STRING * 255
;END TYPE

;TYPE ReplyBuffer
;     BufLen    AS INTEGER         'repply buffer length - 2
;     Rights    AS STRING * 1
;END TYPE
;
;DIM RepBuf AS ReplyBuffer
;DIM ReqBuf AS RequestBuffer
;
GetEffectiveDirRights  Proc Uses DS ES SI DI AX CX, ReqBufSeg:Ptr, ReqBufAdr:Ptr, RepBufSeg:Ptr, RepBufAdr:Ptr, ErCode:Ptr

	XOR AX,AX		;AX = 0
	MOV AH,0E2h		;funcion E2h
   MOV SI,RepBufSeg        ;segmento de la estructura en ES
   MOV ES,[SI]
   MOV SI,RepBufAdr        ;direccion de la estructura en BX
   MOV DI,[SI]
   MOV SI,ReqBufSeg        ;segmento de la estructura en DS
   MOV DS,[SI]
   MOV SI,ReqBufAdr        ;direccion de la estructura en SI
   MOV SI,[SI]
   INT 21h                 ;ejecutar la instruccion
	MOV SI,ErCode           ;error code 00h = Succesfull
	MOV [SI],AL             ;           98h = Volume does not exist
   RET                     ;           9Bh = bad directory handle
GetEffectiveDirRights EndP

End


