/* PLAYCM1 function */


#include <bios.h>
#include <ctype.h>
#include <direct.h>
#include <dos.h>
#include <io.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define BUFFERSIZE 81

int play_cm1(char *song)
	
{
/* This program reads a file of notes and durations and plays them */

/* Arguments:

          *song - pointer to name of music file; "*" for random mode
   
   Returns:

		0 - Proper termination
		1 - Invalid music file
		2 - No parameters supplied
		3 - No music files found

													*/

	/* Structure declaration */
	struct ffblk filedata;

	/* file declaration */											
	FILE *input_file;
	
	/* Variable declaration */
	char music_file[13], current_line[81], *pointer, temp[25], words[20];

	int freq, counter=0, length, duration, counter2=0;
	int rand_flag=0, notepos=0;
	
	/* Code begins here */
	/* Seed random number generator */
	srand(10);
	
	/* Read song file name */
	strcpy(temp,song);
	if (temp[0] != '*') 
		strcpy(music_file,temp);
	else 
		rand_flag=1;
	
	/* If "*" do random mode */
	if (rand_flag == 1) {
		if (findfirst("*.CM1", &filedata, FA_NORMAL) == 0) {
			counter++;
			while (findnext(&filedata) == 0)
				counter++;
			counter=rand() % counter + 1;
			
			/* Reset file finder */
			findfirst("*.CM1", &filedata, FA_NORMAL);
			for (counter2=1;counter2<counter;counter2++)
				findnext(&filedata);
			strcpy(music_file,filedata.ff_name);
		}
		else 
			return 3;
	}
	else {	
		if (pointer=stristr(music_file,".CM1") == NULL) 
			strcat(music_file,".CM1");
	}
	
	/* Open music file w/buffering */
	input_file = fopen(music_file,"r");
	setvbuf(input_file,NULL,_IOFBF,8192);
	
	if (input_file == NULL) 
		return 1;
	
	/* Reset counter, play music */
	counter = 0;
	
	/* Assign frequency value to each note.  notepos and words are used with
	   version 2.0 of MUSIC.EXE, which displays the notes on a graphical scale
	   and shows lyrics                                                       */
	while (fgets(current_line, BUFFERSIZE, input_file) != NULL && !kbhit()) {
		counter++;
		if ((current_line[0] <= 'g' && current_line[0] >= 'a') || (current_line[0] <= 'G' && current_line[0] >='A') || (current_line[0] == 'r' || current_line[0] == 'R')) {
			switch (current_line[0]) {
				case 'C': {
					freq=536;
					notepos=9;
				}
				break;
				case 'c': {
					freq=268;
					notepos=16;
				}
				break;
				case 'D': {
					freq=602;
					notepos=8;
				}
				break;
				case 'd': {
					freq=301;
					notepos=15;
				}
				break;
				case 'E': {
					freq=675;
					notepos=7;
				}
				break;
				case 'e': {
					freq=337;
					notepos=14;
				}
				break;
				case 'F': {
					freq=716;
					notepos=6;
				}
				break;
				case 'f': {
					freq=358;
					notepos=13;
				}
				break;
				case 'G': {
					freq=803;
					notepos=5;
				}
				break;
				case 'g': {
					freq=401;
					notepos=12;
				}
				break;
				case 'A': {
					freq=902;
					notepos=4;
				}
				break;
				case 'a': {
					freq=451;
					notepos=11;
				}
				break;
				case 'B': {
					freq=1012;
					notepos=3;
				}
				break;
				case 'b': {
					freq=506;
					notepos=10;
				}
				break;
				case 'R':
				case 'r': {
					freq=26000;
					notepos=0;
				}
				break;
			}
			
		     if (current_line[2] == 35) 
			     freq = freq * 1.06;
		     if (current_line[2] == 98) 
			     freq = freq * .94;
			
			if (strlen(current_line) > 3) {
				strcpy(words,&current_line[3]);
				words[strlen(words)-1]=0;
			}
				
		     duration = current_line[1] - 48;
		     length=32/duration;
			if (current_line[2] == 46)
				length=length*1.5;
				
		     sound(freq,length);
		     
			strcpy(words,"");
		}
	}
	
	/* Close music file */
	fclose(input_file);
	
	return 0;
}


