{***************************************************************************}
{** Program : GETGROUP                                                    **}
{***************************************************************************}
{** Version : 1.0             ** Started :           ** Ended :           **}
{***************************************************************************}
{******************************** Description ******************************}
{***************************************************************************}
{** Example program to list all the groups that a user is in.             **}
{**                                                                       **}
{**                                                                       **}
{**                                                                       **}
{**                                                                       **}
{**                                                                       **}
{**                                                                       **}
{**                                                                       **}
{***************************************************************************}
{******************************** Information ******************************}
{***************************************************************************}
{** The first parameter must be a valid userid for which the information  **}
{** is to be returned.                                                    **}
{**                                                                       **}
{**                                                                       **}
{**                                                                       **}
{**                                                                       **}
{***************************************************************************}

{$X+}

PROGRAM GETGROUP;

USES

 nwvar,
 nwerror,
 nwbindry;

VAR

  BinderyFunc     : BinderyOBJ;
  ObjectName      : TObjectName;
  ObjectType      : OT_BinderyType;
  ObjectID        : OT_BinderyID;
  PropertyValue   : TPropertyValue;
  AreMoreSegments : byte;
  PropertyFlags   : byte;
  PropertyOffset  : byte;
  ObjectName1     : TObjectName;
  ObjectType1     : OT_BinderyType;

BEGIN

  BinderyFunc.Init (true);
  if paramcount < 1 then
    begin

      writeln ('You must supply a userid as the first parameter!');
      halt;

    end;

  ObjectName := BinderyFunc.UppercaseNW (paramstr (1));
  ObjectType := OT_User;

  if BinderyFunc.GetBinderyObjectID (ObjectName, ObjectType, ObjectID) <> SUCCESSFUL then
    begin

      writeln ('The userid that you specified does not exist!');
      halt;

    end;

  repeat

  PropertyOffset := 0;
  if BinderyFunc.ReadPropertyValue (ObjectName, ObjectType, 'GROUPS_I'#39'M_IN',
                                    1, PropertyValue, AreMoreSegments, PropertyFlags) <> SUCCESSFUL then
    begin

      writeln ('The userid does have the correct property to proceed!');
      halt;

    end
  else
    begin

      writeln;
      writeln ('Groups that user ', ObjectName, ' is a member of :');
      writeln;

      repeat

        move (PropertyValue [PropertyOffSet], ObjectID, 4);
        ObjectID := BinderyFunc.LongSwap (ObjectID);
        if ObjectID <> 0 then
          begin

            BinderyFunc.GetBinderyObjectName (ObjectID, ObjectName1, ObjectType1);
            writeln (' ':2, ObjectName1);

          end;

        inc (PropertyOffset, 4);

      until ObjectID = 0;

    end;

  until AreMoreSegments = 0;

  BinderyFunc.Done;

end.
