{***************************************************************************}
{** Program : BLIST.PAS                                                   **}
{***************************************************************************}
{** Version : 1.0             ** Started :           ** Ended :           **}
{***************************************************************************}
{******************************** Description ******************************}
{***************************************************************************}
{** BLIST will simply list all the objects in the bindery of a specified  **}
{** type.                                                                 **}
{**                                                                       **}
{**                                                                       **}
{**                                                                       **}
{***************************************************************************}
{******************************** Information ******************************}
{***************************************************************************}
{** USAGE :                                                               **}
{**                                                                       **}
{**   BLIST SearchSpec BinderyObjectType                                  **}
{**                                                                       **}
{**                                                                       **}
{***************************************************************************}

program BLIST;

USES

  nwvar,
  nwerror,
  nwbindry;

VAR

  BinderyServices : BinderyOBJ;
  CommandLine     : STRING;
  BObjectType     : OT_BinderyType;
  BSearchSpec     : TObjectName;


procedure GetCommandLine;

BEGIN

  if paramcount < 2 then
    begin

      writeln;
      writeln ('You must supply two parameters :');
      writeln;
      writeln ('BINDLIST <searchspec> <ObjectType>');
      writeln;
      writeln ('Examples : Users        = 1');
      writeln ('         : Groups       = 2');
      writeln ('         : PrintQueues  = 3');
      writeln ('         : FileServers  = 4');
      writeln ('         : PrintServers = 7');

      halt;

    end;

  BSearchSpec := BinderyServices.UppercaseNW (PARAMSTR (1));
  BObjectType := BinderyServices.StrToInt (paramstr (2));

END; {GetCommandLine}

{***}

procedure DisplayBinderyObjects;

VAR

  ObjectID    : OT_BinderyID;
  ObjectName  : TObjectName;
  ObjectType  : OT_BinderyType;
  ObjectHasProperty,
  ObjectFlags,
  ObjectSecurity    : BYTE;

BEGIN

  ObjectID := - 1;
  WITH BinderyServices DO
    WHILE ScanBinderyObject (BSearchSpec, BObjectType, ObjectID, ObjectName,
                             ObjectType, ObjectHasProperty, ObjectFlags, ObjectSecurity) = SUCCESSFUL DO

      WRITELN (ObjectName, HexString (ObjectHasProperty, 2) : 50 - LENGTH (ObjectName), 'h  ',
               HexString (ObjectFlags, 2), 'h  ', HexString (ObjectSecurity, 2), 'h');

END; {DisplayBinderyObjects}

{***}

BEGIN

  BinderyServices.Init (false);
  GetCommandLine;
  DisplayBinderyObjects;
  BinderyServices.Done;

END.


