ECHO OFF
CLS
rem     This BAT file provides an example collection facility for meter
rem     files held at stand alone PCs.
rem
rem           Title: Meter and Log file Collection utility
rem     Description: This BATCH file requires a string with which to
rem                  name the files it copies. This utility presumes
rem                  installation took place using the default settings
rem                  therefore data will be written to C:\LANLOG.DAT in
rem                  data files LLOGDAT.MET and/or LLOGDAT.LOG
rem
rem    Improvements: It is relatively easy to collect data files in a
rem                  compressed form by modifying this batch file and
rem                  including a copy of PKZip or LHARC on the diskette.

rem     check to see user has provided a data file name

if "%1"=="" goto error1

rem     check to see if files already exist on A: drive

if exist A:\%1.LOG goto error2

if exist A:\%1.MET goto error2

rem     user has provided a file name that isn't a duplicate

:COLL

ECHO    ͻ
ECHO         Collection of Meter and/or Log files from PCs    
ECHO    ͹
ECHO                                                          
ECHO            Collection will take only a few moments.      
ECHO                                                          
ECHO     NOTE: Please ensure you have enough disk space on    
ECHO           the floppy disk for the meter and/or log       
ECHO           files.                                         
ECHO                                                          
ECHO       {Cntrl-C} = terminate, any other key = continue    
ECHO                                                          
ECHO    ͼ

rem     get user response

PAUSE

if not exist C:\LANLOG.DAT\LLOGDAT.LOG goto GETMET

COPY C:\LANLOG.DAT\LLOGDAT.LOG A:\%1.LOG > nul

:GETMET

if not exist C:\LANLOG.DAT\LLOGDAT.MET goto QUIT

COPY C:\LANLOG.DAT\LLOGDAT.MET A:\%1.MET > nul

goto QUIT

:ERROR1

rem     user didn't provide a command line parameter for created data
rem     file name.

CLS

ECHO    ͻ
ECHO                         SYNTAX ERROR                     
ECHO    ͹
ECHO                                                          
ECHO     This BATCH file requires a name with which to create 
ECHO     unique data files on the floppy disk.                
ECHO                                                          
ECHO     The correct syntax:                                  
ECHO                                                          
ECHO                   COLLEG01 {name}                        
ECHO                                                          
ECHO     where {name} is any DOS valid 8 character string.    
ECHO                                                          
ECHO     Example:                                             
ECHO                                                          
ECHO                   COLLEG01 GEORGE                        
ECHO                                                          
ECHO                                                          
ECHO    ͼ

goto QUIT

:ERROR2

rem     user provided a command line parameter but a duplicat file name
rem     exists.

CLS

ECHO    ͻ
ECHO                     NAME ALREADY EXISTS!                 
ECHO    ͹
ECHO                                                          
ECHO     The name you provided for the collected data file    
ECHO     already exists, please think of another file name    
ECHO     and try again.                                       
ECHO                                                          
ECHO    ͼ

rem     The End

:QUIT

ECHO ON
