
:
: Make sure the network is loaded
:
if "%LAN_LOADED" != "1"   call startnet

:
: Setup misc env var's
:
SET NODE=3

:
: Setup PCBSuperScript env var's. Used by door driver files and SS
: scripts files. They are NOT used by SS.EXE.
:
: SSDRIVE         The drive name where SS.EXE is located
: SSDIR           The path to where SS.EXE is located
: SS_PRG_DIR      The drive and path to where SS.EXE is located
: SS_DEF_DIR      The drive and path to where definition files are located
: SS_LOG_DIR      The drive and path to where log files are located
:
SET SSDRIVE=K:
SET SSDIR=\DOOR\SS
SET SS_PRG_DIR=%SSDRIVE%%SSDIR%
SET SS_DEF_DIR=%SSDRIVE%%SSDIR%\def
SET SS_LOG_DIR=%SSDRIVE%%SSDIR%\log

:
: If you set the env var 'SSERRLOG' to the name of a file, it will be used
: to log any errors that occur during the execution of the script.
:
SET SSERRLOG=%SSDRIVE%%SSDIR%\sserr.log

:
: If you run *any* doors as a "SWAP" door, you *must* setup the PCBoard env
: vars before loading PCBoard. This is due to the swapper code that CDC uses
: in PCboard; it will give any shell process a copy of the environment as it
: was *before* PCBoard was loaded. Therefor, any env var's that PCBoard sets
: prior to a shell (i.e. running a door) are not "seen" by the shell process
: (i.e. the door program).
:
SET PCBDRIVE=F:
SET PCBDIR=\PCB
SET PCBDAT=%PCBDRIVE%%PCBDIR%\PCBOARD.DAT
SET PCBNODE=3
SET PCBEXE=pcb145.exe

:
: run pcboard...
:
: NOTE: If you don't use 4Dos (or Norton's NDos), comment out the line
:       below and replace with:
:
:       %PCBDRIVE%
:       cd %PCBDIR%
:
pushd %PCBDRIVE%%PCBDIR%
if exist remote.bat   rename  remote.bat remote.sys
if exist event.bat    rename  event.bat  event.sys
if exist door.bat     del     door.bat
if exist endpcb       del     endpcb
%PCBEXE
if exist remote.bat   remote
if exist door.bat     door
if exist event.bat    event
if exist endpcb       goto end
board

:end
:
: Clean up environment and quit to DOS (or wherever we came from)
:
: NOTE: If you don't use 4Dos (or Norton's NDos), comment out the line
:       below.
popd
SET SSDRIVE=
SET SSDIR=
SET SSERRLOG=
SET SS_PRG_DIR=
SET SS_DEF_DIR=
SET SS_LOG_DIR=
SET PCBDRIVE=
SET PCBDIR=
SET PCBDAT=
SET PCBNODE=
SET PCBEXE=
