
{*******************************************************}
{                                                       }
{       Turbo Pascal Version 7.0                        }
{       Graphics Vision Unit                            }
{                                                       }
{       Copyright (c) 1994,95 by Solar Designer         }
{                                                       }
{*******************************************************}

unit Utils;
{$X+,I-,S-,P-}
{$C FIXED PRELOAD PERMANENT}
interface
   uses
      Language, KeyMouse, Objects;

var
   Timer           :Word absolute $0040:$006C;

{ Keyboard support routines }

   function  GetAltChar(KeyCode        :Word)    :Char;
   function  GetAltCode(Ch             :Char)    :Word;
   function  GetCtrlChar(KeyCode       :Word)    :Char;
   function  GetCtrlCode(Ch            :Char)    :Word;
   function  CtrlToArrow(KeyCode       :Word)    :Word;

{ String routines }

   procedure FormatStr(var Result      :String;
                       const Format    :String;
                       var Params);

   procedure PrintStr(const S          :String);

   function  CStrLen(const S           :String)  :Integer;

   function  IsNumber (Chr             :Char)    :Boolean;
   function  IsLetter (Chr             :Char)    :Boolean;
   function  IsSpecial(Chr             :Char;
                       const Special   :String)  :Boolean;
   function  NumChar  (Chr             :Char;
                       Const S         :String;
                       N               :Integer) :Integer;
implementation

{ Keyboard support routines }

const
   AltCodesU       :Array[$78..$83] of Char =    '1234567890-=';

function GetAltChar;
begin
   GetAltChar := #0;
   if Lo(KeyCode) = 0 then
   case Hi(KeyCode) of
      $02     : GetAltChar := #240;
      $10..$34: GetAltChar := AltCodes^[Hi(KeyCode)];
      $78..$83: GetAltChar := AltCodesU[Hi(KeyCode)];
   end;
end;

function GetAltCode;
var
   I     :Word;
begin
   GetAltCode := 0;
   if Ch = #0 then Exit;
   Ch := UpCase(Ch);
   if Ch = #240 then
   begin
      GetAltCode := $0200; Exit;
   end;
   for I := $10 to $34 do
   if AltCodes^[I] = Ch then
   begin
      GetAltCode := I shl 8; Exit;
   end;
   for I := $78 to $83 do
   if AltCodesU[I] = Ch then
   begin
      GetAltCode := I shl 8; Exit;
   end;
end;

function GetCtrlChar;
begin
   GetCtrlChar := #0;
   if (Lo(KeyCode) <> 0) and (Lo(KeyCode) <= Byte('Z') - Byte('A') + 1) then
      GetCtrlChar := Char(Lo(KeyCode) + Byte('A') - 1);
end;

function GetCtrlCode;
begin
   GetCtrlCode := GetAltCode(Ch) or (Byte(UpCase(Ch)) - Byte('A') + 1);
end;

function CtrlToArrow;
const
   NumCodes = 11;
   CtrlCodes: array[0..NumCodes-1] of Char = ^S^D^E^X^A^F^G^V^R^C^H;
   ArrowCodes: array[0..NumCodes-1] of Word =
   (kbLeft, kbRight, kbUp, kbDown, kbHome, kbEnd, kbDel, kbIns,
    kbPgUp, kbPgDn, kbBack);
var
   I     :Integer;
begin
   CtrlToArrow := KeyCode;
   for I := 0 to NumCodes - 1 do
   if Lo(KeyCode) = Byte(CtrlCodes[I]) then
   begin
      CtrlToArrow := ArrowCodes[I]; Exit;
   end;
end;

{ String formatting routines }

{$L FORMAT.OBJ}

procedure FormatStr; external;

procedure PrintStr; assembler;
asm
   PUSH  DS
   LDS   SI,S
   CLD
   LODSB
   XOR   AH,AH
   XCHG  AX,CX
   MOV   AH,40H
   MOV   BX,1
   MOV   DX,SI
   INT   21H
   POP   DS
end;

function CStrLen; assembler;
asm
        LES     DI,S
        MOV     CL,ES:[DI]
        INC     DI
        XOR     CH,CH
        MOV     BX,CX
        JCXZ    @@2
        MOV     AL,'~'
        CLD
@@1:    REPNE   SCASB
        JNE     @@2
        DEC     BX
        JMP     @@1
@@2:    MOV     AX,BX
end;

function IsNumber; assembler;
asm
        XOR     ax,ax
        MOV     Ch,Chr
        CMP     Ch,'0'
        JB      @@1
        CMP     Ch,'9'
        JA      @@1
        INC     ax
@@1:
end;

function IsLetter; assembler;
asm
        mov     ax,word ptr AIsLetter
        or      ax,word ptr AIsLetter+2
        jz      @@2
        call    AIsLetter
        or      ax,ax
        jnz     @@1
@@2:
{       xor     ax,ax }
        MOV     Cl,Chr
        AND     Cl,0DFH
        CMP     Cl,'A'
        JB      @@1
        CMP     Cl,'Z'
        JA      @@1
        INC     ax
@@1:
end;

function IsSpecial; assembler;
asm
        XOR     dx,dx
        LES     DI,Special
        xor     cx,cx
        MOV     cl,ES:[DI]
        INC     DI
        MOV     AL,Chr
        cld
        REPNE   SCASB
        JCXZ    @@1
        INC     dx
@@1:    MOV     ax,dx
end;

function NumChar; assembler;
asm
   les  di,S
   mov  si,di
   mov  al,Chr
   mov  dl,byte ptr N
   xor  cx,cx
   mov  cl,es:[di]
   inc  di
   xor  dx,dx
   cld
@@1:
   repne scasb
   jnz  @@2
   dec  dl
   jnz  @@2
   sub  di,si
   dec  di
   mov  dx,di
@@2:
   mov  ax,dx
end;

end.
