
{*******************************************************}
{                                                       }
{       Turbo Pascal Version 7.0                        }
{       Graphics Vision Unit                            }
{                                                       }
{       Copyright (c) 1994,95 by Solar Designer         }
{                                                       }
{*******************************************************}

unit StdVideo;
interface
uses
   GMenus,
   GModes;

const
   cmVideoBase =   $F800;
   hcVideoBase =   $F800;

   { CGA modes }
   cm320x200x4  =  cmVideoBase + 4;

   { EGA modes }
   cm320x200x16 =  cmVideoBase + gm320x200x16;
   cm640x200x16 =  cmVideoBase + gm640x200x16;
   cm640x350x16 =  cmVideoBase + gm640x350x16;

   { VGA modes }
   cm640x480x16 =  cmVideoBase + gm640x480x16;
   cm320x200x256 = cmVideoBase + gm320x200x256;

   { Low resolution VGA modes }
   cm320x133x256 = cmVideoBase + gm320x133x256;
   cm320x100x256 = cmVideoBase + gm320x100x256;
   cm320x80x256 =  cmVideoBase + gm320x80x256;
   cm320x50x256 =  cmVideoBase + gm320x50x256;
   cm320x40x256 =  cmVideoBase + gm320x40x256;
   cm320x25x256 =  cmVideoBase + gm320x25x256;

   { Extended VGA modes }
   cm360x480x256 = cmVideoBase + gm360x480x256;
   cm320x200x256x= cmVideoBase + gm320x200x256x;
   cm320x240x256 = cmVideoBase + gm320x240x256;
   cm376x282x256 = cmVideoBase + gm376x282x256;
   cm320x400x256 = cmVideoBase + gm320x400x256;
   cm320x480x256 = cmVideoBase + gm320x480x256;
   cm360x360x256 = cmVideoBase + gm360x360x256;
   cm376x308x256 = cmVideoBase + gm376x308x256;
   cm376x564x256 = cmVideoBase + gm376x564x256;
   cm256x224x256 = cmVideoBase + gm256x224x256;

   { VESA SVGA modes }
   cm800x600x16 =  cmVideoBase + gm800x600x16;
   cm1024x768x16 = cmVideoBase + gm1024x768x16;
   cm640x400x256 = cmVideoBase + gm640x400x256;
   cm640x480x256 = cmVideoBase + gm640x480x256;
   cm800x600x256 = cmVideoBase + gm800x600x256;

   { Realtek & Trident SVGA modes }
   cm640x400x16 =  cmVideoBase + gm640x400x16;

   { Realtek SVGA modes }
   cm960x720x16 =  cmVideoBase + gm960x720x16;
   cm768x1024x16 = cmVideoBase + gm768x1024x16;
   cm512x512x256 = cmVideoBase + gm512x512x256;

   { Trident SVGA modes }
   cm1024x480x256= cmVideoBase + gm1024x480x256;

   hcVideoCGA =    hcVideoBase + 0;
   hcVideoEGA =    hcVideoBase + 1;
   hcVideoVGA =    hcVideoBase + 2;
   hcVideoLowVGA = hcVideoBase + 3;
   hcVideoExtVGA = hcVideoBase + 4;
   hcVideoVESALo = hcVideoBase + 5;
   hcVideoVESAHi = hcVideoBase + 6;
   hcVideoRTVGA =  hcVideoBase + 8;
   hcVideoTrident= hcVideoBase + 9;

function  StdVideoCGAMenuItems(Next    :PMenuItem)         :PMenuItem;
function  StdVideoEGAMenuItems(Next    :PMenuItem)         :PMenuItem;
function  StdVideoVGAMenuItems(Next    :PMenuItem)         :PMenuItem;
function  StdVideoExtVGAMenuItems(Next :PMenuItem)         :PMenuItem;
function  StdVideoVESAMenuItems(Next   :PMenuItem)         :PMenuItem;
function  StdVideoRTVGAMenuItems(Next  :PMenuItem)         :PMenuItem;
function  StdVideoTridentMenuItems(Next:PMenuItem)         :PMenuItem;

function  StdVideoMenuItems(Next       :PMenuItem)         :PMenuItem;

procedure SetVideoMode(ModeCmd         :Word);

implementation
uses
   KeyMouse, GDrivers, GApp,
   DOS;

function  StdVideoCGAMenuItems;
begin
   StdVideoCGAMenuItems :=
     NewItem('320x200x4', '', kbNoKey, cm320x200x4, hcVideoCGA,
   Next);
end;

function  StdVideoEGAMenuItems;
begin
   StdVideoEGAMenuItems :=
     NewItem('320x200x16', '', kbNoKey, cm320x200x16, hcVideoEGA,
     NewItem('640x200x16', '', kbNoKey, cm640x200x16, hcVideoEGA,
     NewItem('640x350x16', '', kbNoKey, cm640x350x16, hcVideoEGA,
   Next)));
end;

function  StdVideoVGAMenuItems;
begin
   StdVideoVGAMenuItems :=
     NewItem('640x480x16', '', kbNoKey, cm640x480x16, hcVideoVGA,
     NewItem('320x200x256', '', kbNoKey, cm320x200x256, hcVideoVGA,
   Next));
end;

function  StdVideoExtVGAMenuItems;
begin
   StdVideoExtVGAMenuItems :=
     NewItem('320x200x256', '', kbNoKey, cm320x200x256x, hcVideoExtVGA,
     NewItem('320x240x256', '', kbNoKey, cm320x240x256, hcVideoExtVGA,
     NewItem('376x282x256', '', kbNoKey, cm376x282x256, hcVideoExtVGA,
     NewItem('320x400x256', '', kbNoKey, cm320x400x256, hcVideoExtVGA,
     NewItem('320x480x256', '', kbNoKey, cm320x480x256, hcVideoExtVGA,
     NewItem('360x480x256', '', kbNoKey, cm360x480x256, hcVideoExtVGA,
     NewItem('360x360x256', '', kbNoKey, cm360x360x256, hcVideoExtVGA,
     NewItem('376x308x256', '', kbNoKey, cm376x308x256, hcVideoExtVGA,
     NewItem('376x564x256', '', kbNoKey, cm376x564x256, hcVideoExtVGA,
     NewItem('256x224x256', '', kbNoKey, cm256x224x256, hcVideoExtVGA,
     NewLine(
     NewItem('320x133x256', '', kbNoKey, cm320x133x256, hcVideoLowVGA,
   Next))))))))))));
end;

function  StdVideoVESAMenuItems;
begin
   StdVideoVESAMenuItems :=
     NewItem('800x600x16', '', kbNoKey, cm800x600x16, hcVideoVESALo,
     NewItem('1024x768x16', '', kbNoKey, cm1024x768x16, hcVideoVESAHi,
     NewItem('640x400x256', '', kbNoKey, cm640x400x256, hcVideoVESAHi,
     NewItem('640x480x256', '', kbNoKey, cm640x480x256, hcVideoVESAHi,
     NewItem('800x600x256', '', kbNoKey, cm800x600x256, hcVideoVESAHi,
   Next)))));
end;

function  StdVideoRTVGAMenuItems;
begin
   StdVideoRTVGAMenuItems :=
     NewItem('640x400x16', '', kbNoKey, cm640x400x16, hcVideoRTVGA,
     NewItem('960x720x16', '', kbNoKey, cm960x720x16, hcVideoRTVGA,
     NewItem('768x1024x16', '', kbNoKey, cm768x1024x16, hcVideoRTVGA,
     NewItem('512x512x256', '', kbNoKey, cm512x512x256, hcVideoRTVGA,
   Next))));
end;

function  StdVideoTridentMenuItems;
begin
   StdVideoTridentMenuItems :=
     NewItem('640x400x16', '', kbNoKey, cm640x400x16, hcVideoTrident,
     NewItem('1024x480x256', '', kbNoKey, cm1024x480x256, hcVideoTrident,
   Next));
end;

function  StdVideoMenuItems;
begin
   StdVideoMenuItems :=
     NewSubMenu('~C~GA', hcVideoCGA, NewMenu(StdVideoCGAMenuItems(nil)),
     NewSubMenu('~E~GA', hcVideoEGA, NewMenu(StdVideoEGAMenuItems(nil)),
     NewSubMenu('~V~GA', hcVideoVGA, NewMenu(StdVideoVGAMenuItems(nil)),
     NewSubMenu('E~x~t VGA', hcVideoExtVGA, NewMenu(StdVideoExtVGAMenuItems(nil)),
     NewSubMenu('VESA ~S~VGA', hcVideoVESAHi, NewMenu(StdVideoVESAMenuItems(nil)),
     NewSubMenu('~R~ealtek SVGA', hcVideoRTVGA, NewMenu(StdVideoRTVGAMenuItems(nil)),
     NewSubMenu('~T~rident SVGA', hcVideoTrident, NewMenu(StdVideoTridentMenuItems(nil)),
   Next)))))));
end;

procedure SetVideoMode;
var
   BestDrv         :Integer;
   SR              :SearchRec;
const
   Drivers         :Array [1..7] of String[8] =
   ('VESA16LO', 'VESA16HI', 'VESA256',
    'VGA256', 'VGA256LO', 'VGA256HI', 'CGALO');
begin
   case ModeCmd of
      cm320x200x16..cm640x480x16,
      cm800x600x16, cm640x400x16:      BestDrv:=1;

      cm1024x768x16,
      cm960x720x16, cm768x1024x16:     BestDrv:=2;

      cm640x400x256, cm640x480x256,
      cm800x600x256, cm512x512x256,
      cm1024x480x256:                  BestDrv:=3;

      cm320x200x256:                   BestDrv:=4;

      cm320x133x256..cm320x25x256:     BestDrv:=5;

      cm360x480x256..cm256x224x256:    BestDrv:=6;

      cm320x200x4:                     BestDrv:=7;
   else
      Exit;
   end;

   FindFirst(GetPath+Drivers[BestDrv]+DriverExt, Archive+ReadOnly, SR);
   if DosError<>0 then
   case BestDrv of
      1: BestDrv:=2;
      4:
      begin
         BestDrv:=3;
         FindFirst(GetPath+Drivers[BestDrv]+DriverExt, Archive+ReadOnly, SR);
         if DosError<>0 then BestDrv:=5;
      end;
   end;

   Application^.SetScreenMode(Drivers[BestDrv], ModeCmd - cmVideoBase);
end;

end.
