
{*******************************************************}
{                                                       }
{       Turbo Pascal Version 7.0                        }
{       Graphics Vision Unit                            }
{                                                       }
{       Copyright (c) 1994,95 by Solar Designer         }
{                                                       }
{*******************************************************}

unit Russian;
interface
   uses
      Language;

   const
{ System error messages }

      ErrorString  :TErrorString=
      ('~Enter~   ~Esc~ ⬥',
       '᪠ 訡  ன⢥ %c',
       ' 饭    ன⢥ %c',
       '  ⮢  ன⢥ %c',
       '訡 楫⭮   ன⢥ %c',
       '訡 ᪠  ன⢥ %c',
       ' ⨯ ⥫  ன⢥ %c',
       '    ன⢥ %c',
       ' 㬠  ਭ',
       '訡   ன⢥ %c',
       '訡 ⥭  ன⢥ %c',
       '⭠ 訡 ன⢠ %c',
       '  FAT  ',
       '訡 㯠  ன',
       '⠢   ன⢮ %c');

      AltCodes     :TAltCodes =
      ''#0#0''#0#0#0'';

      WMenuItems   :TWMenuItems =
      ('~~', '~~/', '~~६' ,'~~');

      ButtonNames  :TButtonNames =
      ('', '', 'O~K', '');

      MsgTitles    :TMsgTitles =
      ('', '訡', 'ଠ', '⢥ত');

   function  RussianUpCase(C           :Char)    :Char;
   function  IsRussianLetter(C         :Char)    :Boolean;

implementation

function RussianUpCase; assembler;
asm
   mov  ax,word ptr C
   cmp  al,''
   jb   @@1
   cmp  al,''
   ja   @@1
   cmp  al,''
   jb   @@2
   sub  al,''-''
   jmp  @@1
@@2:
   cmp  al,''
   ja   @@1
   sub  al,''-''
@@1:
end;

function IsRussianLetter; assembler;
asm
   push word ptr C
   call RussianUpCase
   xor  dx,dx
   cmp  al,''
   jb   @@1
   cmp  al,''
   ja   @@1
   inc  dx
@@1:
   mov  ax,dx
end;

begin
   Language.ErrorString:=@ErrorString;
   Language.AltCodes:=@AltCodes;
   Language.WMenuItems:=@WMenuItems;
   Language.ButtonNames:=@ButtonNames;
   Language.MsgTitles:=@MsgTitles;
   Language.AUpCase:=RussianUpCase;
   Language.AIsLetter:=IsRussianLetter;
   ProgramLanguage:=plRussian;
end.
