
{*******************************************************}
{                                                       }
{       Turbo Pascal Version 7.0                        }
{       Graphics Vision Unit                            }
{                                                       }
{       Copyright (c) 1994,95 by Solar Designer         }
{                                                       }
{*******************************************************}

unit MousePtr;
{$A-}
interface
uses
   GraphDrv, DOS;

const
   ForceMouseEmul  :Boolean= False;
 { Set to True to force mouse emulation for all the video modes }

var
   MouseImage      :Pointer;

procedure InitMousePtr;
procedure DoneMousePtr;

procedure SetMouseImage(Image          :Pointer);

implementation
uses
   KeyMouse, GDrivers, GRect;

{$L mouseimg.obj}
{$L mouseint.obj}

procedure MouseImageD; External;
procedure MouseIntProc; External;
procedure MouseHandlerProc; External;
procedure InitRange; External;
procedure Hide; External;
procedure Show; External;

var
   SavedImage      :Pointer;

const
   SavedImageSize  :Word =   0;

var
   LastExitProc    :Pointer;

const
   LastMouseInt    :Pointer= nil;
   Working         :Boolean= False;
   MouseVisible    :Integer= 0;
   MouseX          :Integer= 0;
   MouseY          :Integer= 0;
   MickeyX         :Integer= 0;
   MickeyY         :Integer= 0;
   MouseSrcEASet   :Boolean= False;

var
   MouseSrcEA      :TGRect;

var
   LastVideoSeg    :Word;

procedure InitMouseOutput; Near;
begin
   LastVideoSeg:=DriverPtr^.VideoSeg;
   SetDriverOutput(ToScreen);
end;

procedure DoneMouseOutput; Near;
begin
   DriverPtr^.VideoSeg:=LastVideoSeg;
end;

procedure FreeSavedImage;
begin
   if SavedImageSize<>0 then FreeMem(SavedImage, SavedImageSize);
   SavedImageSize:=0;
end;

procedure SetMouseImage;
var
   RImage          :^TGPoint;
begin
   Working:=True;

   Hide;
   FreeSavedImage;
   if Image=nil then RImage:=@MouseImageD else RImage:=Image;
   SavedImageSize:=4+RImage^.X*RImage^.Y;
   GetMem(SavedImage, SavedImageSize);
   MouseImage:=RImage;
   KeyMouse.MouseImage:=Image;
   if MouseVisible>0 then Show;

   if MouseSrcEASet then
   asm
      cli
      mov  Working,False
      mov  cx,MouseSrcEA.A.X
      mov  dx,MouseSrcEA.A.Y
      mov  si,MouseSrcEA.B.X
      mov  di,MouseSrcEA.B.Y
      mov  ax,10h
      int  33h
      sti
   end else Working:=False;
end;

procedure InitMousePtr;
begin
   if LastMouseInt<>nil then Exit;

   MouseEmul:=((DriverPtr^.MouseConvX=$FF) or ForceMouseEmul) and
      GraphDrv.Supported(GraphDrv.PutBlock) and (ButtonCount<>0);
   if not MouseEmul then Exit;

   FillChar(MouseVisible, 11, 0);
   SetMouseImage(nil);

   KeyMouse.MouseConvX:=0; KeyMouse.MouseConvY:=0;
   KeyMouse.MouseSafe:=(GDrivers.MaxColor=15);

   InitRange;
   GetIntVec($33, LastMouseInt);
   SetIntVec($33, @MouseIntProc);
   KeyMouse.MouseHandler:=@MouseHandlerProc;
   LastExitProc:=ExitProc; ExitProc:=@DoneMousePtr;
end;

procedure DoneMousePtr;
begin
   if LastMouseInt=nil then Exit;

   KeyMouse.MouseSafe:=True;

   SetIntVec($33, LastMouseInt);
   asm cli end;
   KeyMouse.MouseHandler:=nil;
   asm sti end;

   Hide;

   FreeSavedImage;

   ExitProc:=LastExitProc;
   LastMouseInt:=nil;
end;

begin
   KeyMouse.InitMousePtr:=InitMousePtr;
   KeyMouse.DoneMousePtr:=DoneMousePtr;
   KeyMouse.SetMousePtr:=SetMouseImage;
   MouseEmulInst:=True;
end.
