
{*******************************************************}
{                                                       }
{       Turbo Pascal Version 7.0                        }
{       Graphics Vision Unit                            }
{                                                       }
{       Copyright (c) 1994,95 by Solar Designer         }
{                                                       }
{*******************************************************}

unit Language;
{$X+,I-,S-,P+}
{$C FIXED PRELOAD PERMANENT}
interface
   uses
      Objects, Strings;

   type
      TLanguage=   (plNone, plOther, plEnglish, plRussian);

   const
      ProgramLanguage   :TLanguage =   plNone;

   type
      TErrorString=Array [0..14] of PChar;
      TAltCodes=   Array [$10..$34] of Char;
      TWMenuItems= Array [0..3] of PChar;
      TButtonNames=Array [0..3] of PChar;
      TMsgTitles=  Array [0..3] of PChar;

   const
      ErrorString  :^TErrorString =    nil;
      AltCodes     :^TAltCodes =       nil;
      WMenuItems   :^TWMenuItems =     nil;
      ButtonNames  :^TButtonNames =    nil;
      MsgTitles    :^TMsgTitles =      nil;
      AUpCase      :Function(C         :Char)    :Char =   nil;
      AIsLetter    :Function(C         :Char)    :Boolean= nil;

   procedure GetErrorMessage(Code           :Integer;
                             Var Message    :String );

   function  UpCase(C                  :Char)    :Char;

implementation

procedure GetErrorMessage;
const
   Codes :Array [0..15] of Byte=
   (2, 1, 3, 2, 4, 2, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14);
begin
   If ErrorString<>nil then
   begin
      If Code<0 then Code:=0 else Code:=Codes[Code];
      Message:=StrPas(ErrorString^[Code]);
   end
   else Message:='';
end;

function UpCase; assembler;
asm
   mov  ax,word ptr C
   mov  dx,word ptr AUpCase
   or   dx,word ptr AUpCase+2
   jz   @@1
   push ax
   call AUpCase
@@1:
   cmp  al,'a'
   jb   @@2
   cmp  al,'z'
   ja   @@2
   sub  al,'a'-'A'
@@2:
end;

end.
