
{*******************************************************}
{                                                       }
{       Turbo Pascal Version 7.0                        }
{       Graphics Vision Unit                            }
{                                                       }
{       Copyright (c) 1994,95 by Solar Designer         }
{                                                       }
{*******************************************************}

unit KeyMouse;
{$X+,I-,S-,P-}
{$C FIXED PRELOAD PERMANENT}

interface
   uses
      Objects, GRect, Events;

{ ******** EVENT MANAGER ******** }

const

{ Extended key codes }

   kbEsc       = $011B;  kbAltSpace  = $0200;  kbCtrlIns   = $0400;
   kbShiftIns  = $0500;  kbCtrlDel   = $0600;  kbShiftDel  = $0700;
   kbBack      = $0E08;  kbCtrlBack  = $0E7F;  kbShiftTab  = $0F00;
   kbTab       = $0F09;  kbAltQ      = $1000;  kbAltW      = $1100;
   kbAltE      = $1200;  kbAltR      = $1300;  kbAltT      = $1400;
   kbAltY      = $1500;  kbAltU      = $1600;  kbAltI      = $1700;
   kbAltO      = $1800;  kbAltP      = $1900;  kbCtrlEnter = $1C0A;
   kbEnter     = $1C0D;  kbAltA      = $1E00;  kbAltS      = $1F00;
   kbAltD      = $2000;  kbAltF      = $2100;  kbAltG      = $2200;
   kbAltH      = $2300;  kbAltJ      = $2400;  kbAltK      = $2500;
   kbAltL      = $2600;  kbAltZ      = $2C00;  kbAltX      = $2D00;
   kbAltC      = $2E00;  kbAltV      = $2F00;  kbAltB      = $3000;
   kbAltN      = $3100;  kbAltM      = $3200;  kbF1        = $3B00;
   kbF2        = $3C00;  kbF3        = $3D00;  kbF4        = $3E00;
   kbF5        = $3F00;  kbF6        = $4000;  kbF7        = $4100;
   kbF8        = $4200;  kbF9        = $4300;  kbF10       = $4400;
   kbHome      = $4700;  kbUp        = $4800;  kbPgUp      = $4900;
   kbGrayMinus = $4A2D;  kbLeft      = $4B00;  kbRight     = $4D00;
   kbGrayPlus  = $4E2B;  kbEnd       = $4F00;  kbDown      = $5000;
   kbPgDn      = $5100;  kbIns       = $5200;  kbDel       = $5300;
   kbShiftF1   = $5400;  kbShiftF2   = $5500;  kbShiftF3   = $5600;
   kbShiftF4   = $5700;  kbShiftF5   = $5800;  kbShiftF6   = $5900;
   kbShiftF7   = $5A00;  kbShiftF8   = $5B00;  kbShiftF9   = $5C00;
   kbShiftF10  = $5D00;  kbCtrlF1    = $5E00;  kbCtrlF2    = $5F00;
   kbCtrlF3    = $6000;  kbCtrlF4    = $6100;  kbCtrlF5    = $6200;
   kbCtrlF6    = $6300;  kbCtrlF7    = $6400;  kbCtrlF8    = $6500;
   kbCtrlF9    = $6600;  kbCtrlF10   = $6700;  kbAltF1     = $6800;
   kbAltF2     = $6900;  kbAltF3     = $6A00;  kbAltF4     = $6B00;
   kbAltF5     = $6C00;  kbAltF6     = $6D00;  kbAltF7     = $6E00;
   kbAltF8     = $6F00;  kbAltF9     = $7000;  kbAltF10    = $7100;
   kbCtrlPrtSc = $7200;  kbCtrlLeft  = $7300;  kbCtrlRight = $7400;
   kbCtrlEnd   = $7500;  kbCtrlPgDn  = $7600;  kbCtrlHome  = $7700;
   kbAlt1      = $7800;  kbAlt2      = $7900;  kbAlt3      = $7A00;
   kbAlt4      = $7B00;  kbAlt5      = $7C00;  kbAlt6      = $7D00;
   kbAlt7      = $7E00;  kbAlt8      = $7F00;  kbAlt9      = $8000;
   kbAlt0      = $8100;  kbAltMinus  = $8200;  kbAltEqual  = $8300;
   kbCtrlPgUp  = $8400;  kbAltBack   = $0800;  kbNoKey     = $0000;

   kbSpace     = $3920;
   kbCtrlA=      kbAltA+1;
   kbCtrlB=      kbAltB+2;
   kbCtrlC=      kbAltC+3;
   kbCtrlD=      kbAltD+4;
   kbCtrlE=      kbAltE+5;
   kbCtrlF=      kbAltF+6;
   kbCtrlG=      kbAltG+7;
   kbCtrlH=      kbAltH+8;
   kbCtrlI=      kbAltI+9;
   kbCtrlJ=      kbAltJ+10;
   kbCtrlK=      kbAltK+11;
   kbCtrlL=      kbAltL+12;
   kbCtrlM=      kbAltM+13;
   kbCtrlN=      kbAltN+14;
   kbCtrlO=      kbAltO+15;
   kbCtrlP=      kbAltP+16;
   kbCtrlQ=      kbAltQ+17;
   kbCtrlR=      kbAltR+18;
   kbCtrlS=      kbAltS+19;
   kbCtrlT=      kbAltT+20;
   kbCtrlU=      kbAltU+21;
   kbCtrlV=      kbAltV+22;
   kbCtrlW=      kbAltW+23;
   kbCtrlX=      kbAltX+24;
   kbCtrlY=      kbAltY+25;
   kbCtrlZ=      kbAltZ+26;

{ Keyboard state and shift masks }

   kbRightShift  = $0001;
   kbLeftShift   = $0002;
   kbCtrlShift   = $0004;
   kbAltShift    = $0008;
   kbScrollState = $0010;
   kbNumState    = $0020;
   kbCapsState   = $0040;
   kbInsState    = $0080;

{ Mouse button state masks }

   mbLeftButton  = $01;
   mbRightButton = $02;
   mbCenterButton= $04;

const

{ Initialized variables }

   ButtonCount     :Byte =             0;
   MouseEvents     :Boolean =          False;
   MouseReverse    :Boolean =          False;
   DoubleDelay     :Word =             8;
   RepeatDelay     :Word =             8;
   MouseVisible    :Integer =          0;
   MouseEASet      :Integer =          0;
   MouseOn         :Boolean =          True;

   MouseConvX      :Byte =             3;     { These variables are }
   MouseConvY      :Byte =             3;     { initialized by }
   UseMouse        :Boolean =          False; { GDrivers.InitVideo }

   MouseSafe       :Boolean =          True;

{ Mouse pointer emulation for SVGA }
   MouseHandler    :Pointer =          nil;
   MouseEmul       :Boolean =          False;
   MouseEmulInst   :Boolean =          False;
   MickeyPixelX    :Word =             1;
   MickeyPixelY    :Word =             1;
   MouseImage      :Pointer =          nil;
   InitMousePtr    :Procedure =        nil;
   DoneMousePtr    :Procedure =        nil;
   SetMousePtr     :Procedure (Image   :Pointer)=nil;

var
{ Uninitialized variables }

   MouseIntFlag    :Byte;
   MouseButtons    :Byte;
   MouseWhere      :TGPoint;

   MouseEA         :TGRect;

{ Event manager routines }

   procedure InitEvents;
   procedure DoneEvents;
   procedure ShowMouse;
   procedure ShowMouseRect;
   procedure HideMouse;
   procedure HideMouseRect(var R       :TGRect);
   procedure GetMouseEvent(var Event   :TEvent);
   procedure GetKeyEvent(var Event     :TEvent);
   function  GetShiftState             :Byte;

   procedure SetMousePos(Pos                     :TGPoint);

   procedure SetMouseRange(var Range             :TGRect);

   procedure SetMouseShape(HotX, HotY            :Integer;
                           Shape                 :Pointer);

implementation

{ ******** EVENT MANAGER ******** }

const
{ Event manager constants }

   EventQSize =    16;

var
{ Event manager variables }

   LastButtons     :Byte;
   DownButtons     :Byte;
   LastDouble      :Boolean;
   LastWhere       :TGPoint;
   DownWhere       :TGPoint;
   DownTicks       :Word;
   AutoTicks       :Word;
   AutoDelay       :Word;
   EventCount      :Word;
   EventQHead      :Word;
   EventQTail      :Word;
   EventQueue      :Array[0..EventQSize - 1] of TEvent;
   EventQLast      :record end;

var
   ShiftState      :Byte absolute $0040:$0017;
   Ticks           :Word absolute $0040:$006C;

{ Detect mouse driver }

procedure DetectMouse; near; assembler;
asm
	MOV	AX,3533H
	INT	21H
	MOV	AX,ES
	OR	AX,BX
	JE	@@1
	XOR	AX,AX
	INT	33H
	OR	AX,AX
	JE	@@1
	PUSH	BX
	MOV	AX,4
	XOR	CX,CX
	XOR	DX,DX
	INT	33H
	POP	AX
@@1:	MOV	ButtonCount,AL
end;

{ Store event in GetMouseEvent and GetKeyEvent }

procedure StoreEvent; near; assembler;
asm
	MOV	DI,SP
	LES	DI,SS:[DI+8]
	CLD
	STOSW
	XCHG	AX,BX
	STOSW
	XCHG	AX,CX
	STOSW
	XCHG	AX,DX
	STOSW
end;

{ Get mouse state }
{ Out	BL = Button mask }
{	CX = X coordinate }
{	DX = Y coordinate }
{	DI = Timer ticks }

procedure GetMouseState; near; assembler;
asm
	CLI
	CMP	EventCount,0
	JNE	@@1
	MOV	BL,MouseButtons
	MOV	CX,MouseWhere.Word[0]
	MOV	DX,MouseWhere.Word[2]
	MOV	ES,Seg0040
	MOV	DI,ES:Ticks
	JMP	@@3
@@1:	MOV	SI,EventQHead
	CLD
	LODSW
	XCHG	AX,DI
	LODSW
	XCHG	AX,BX
	LODSW
	XCHG	AX,CX
	LODSW
	XCHG	AX,DX
	CMP	SI,OFFSET EventQLast
	JNE	@@2
	MOV	SI,OFFSET EventQueue
@@2:	MOV	EventQHead,SI
	DEC	EventCount
@@3:	STI
	CMP	MouseReverse,0
	JE	@@4
	MOV	BH,BL
	AND	BH,3
	JE	@@4
	CMP	BH,3
	JE	@@4
	XOR	BL,3
@@4:
end;

procedure MouseInt; far; assembler;
asm
        push si
        push di
	MOV	SI,SEG @DATA
	MOV	DS,SI
        les  di,MouseHandler
        mov  si,es
        or   si,di
        pop  di
        pop  si
        je   @@3
        call dword ptr MouseHandler
@@3:
	MOV	SI,CX
        MOV     CL,MouseConvX
        SHR     SI,CL
        MOV     CL,MouseConvY
        SHR     DX,CL
	MOV	MouseButtons,BL
	MOV	MouseWhere.X,SI
	MOV	MouseWhere.Y,DX
	TEST	AX,11110B
	JE	@@2
	CMP	EventCount,EventQSize
	JE	@@2
	MOV	ES,Seg0040
	MOV	AX,ES:Ticks
	MOV	DI,EventQTail
	PUSH	DS
	POP	ES
	CLD
	STOSW
	XCHG	AX,BX
	STOSW
	XCHG	AX,SI
	STOSW
	XCHG	AX,DX
	STOSW
	CMP	DI,OFFSET EventQLast
	JNE	@@1
	MOV	DI,OFFSET EventQueue
@@1:	MOV	EventQTail,DI
	INC	EventCount
@@2:	MOV	MouseIntFlag,1
end;

procedure InitEvents; assembler;
asm
        cmp     UseMouse,0
        je      @@1
	XOR	AX,AX
	CMP	AL,ButtonCount
	JE	@@1
	MOV	DownButtons,AL
	MOV	LastDouble,AL
	MOV	EventCount,AX
	MOV	AX,OFFSET DS:EventQueue
	MOV	EventQHead,AX
	MOV	EventQTail,AX
	MOV	AX,3
	INT	33H
	XCHG	AX,CX
	MOV	CL,MouseConvX
	SHR	AX,CL
	MOV	CL,MouseConvY
	SHR	DX,CL
	MOV	MouseButtons,BL
	MOV	MouseWhere.X,AX
	MOV	MouseWhere.Y,DX
	MOV	LastButtons,BL
	MOV	LastWhere.X,AX
	MOV	LastWhere.Y,DX
	MOV	AX,12
	MOV	CX,0FFFFH
	MOV	DX,OFFSET CS:MouseInt
	PUSH	CS
	POP	ES
	INT	33H
        CALL    ShowMouse
	MOV	MouseEvents,1
@@1:
end;

procedure DoneEvents; assembler;
asm
	CMP	ButtonCount,0
	JE	@@1
	CMP	MouseEvents,0
	JE	@@1
	MOV	MouseEvents,0
        CALL    HideMouse
	MOV	AX,12
	XOR	CX,CX
	MOV	DX,CX
	MOV	ES,CX
	INT	33H
@@1:
end;

procedure ShowMouse; assembler;
asm
        CMP	ButtonCount,0
        JE	@@1
        CMP     MouseOn,0
        JZ      @@1
        CMP     MouseVisible,0
        jl      @@2
	MOV	AX,1
	INT	33H

        cmp     MouseEASet,0
        jbe     @@2
        push    ds
        lea     si,MouseEA
        push    si
        call    HideMouseRect
        dec     MouseEASet
@@2:
        INC     MouseVisible
@@1:
end;

procedure ShowMouseRect; assembler;
asm
        cmp     MouseSafe,0
        jz      @@9
        jmp     ShowMouse
@@9:
        CMP	ButtonCount,0
        JE	@@1
        CMP     MouseOn,0
        JZ      @@1
        CMP     MouseEASet,1
        jne     @@2
	MOV	AX,1
	INT	33H
@@2:
        dec     MouseEASet
@@1:
end;

procedure HideMouse; assembler;
asm
        CMP	ButtonCount,0
	JE	@@1
        CMP     MouseOn,0
        JZ      @@1
        CMP     MouseVisible,0
        JLE     @@2
	MOV	AX,2
	INT	33H
@@2:
        DEC     MouseVisible
@@1:
end;

procedure HideMouseRect; assembler;
var
   RA              :TGRect;
asm
        cmp     MouseSafe,0
        jz      @@9
        call    HideMouse
        jmp     @@1
@@9:
	CMP	ButtonCount,0
	JE	@@1
        CMP     MouseOn,0
        JZ      @@1

        les     di,R
        push    es
        push    di
        push    ss
        lea     si,RA
        push    si
        call    TGRect.Copy
        push    ss
        lea     si,RA
        push    si
        call    TGRect.Arrange
        cmp     MouseEASet,0
        jnz     @@5
        push    ss
        lea     si,RA
        push    si
        push    ds
        lea     si,MouseEA
        push    si
        call    TGRect.Copy
@@5:
        lea     di,RA
        push    ss
        pop     es
        cmp     MouseEASet,0
        je      @@3
        push    ss
        push    si
        push    ds
        lea     si,MouseEA
        push    si
        call    TGRect.Union
        push    ds
        pop     es
        lea     di,MouseEA
@@3:
        mov     cx,es:[di].TGRect.A.X
        mov     dx,es:[di].TGRect.A.Y
        mov     si,es:[di].TGRect.B.X
        mov     di,es:[di].TGRect.B.Y
	MOV	AX,10h
	INT	33H
        inc     MouseEASet
@@1:
end;

procedure GetMouseEvent(var Event      :TEvent); assembler;
asm
	CMP	MouseEvents,0
	JE	@@2
	CALL	GetMouseState
	MOV	BH,LastDouble
	MOV	AL,LastButtons
	CMP	AL,BL
	JE	@@1
	OR	AL,AL
	JE	@@3
	OR	BL,BL
	JE	@@5
	MOV	BL,AL
@@1:	CMP	CX,LastWhere.X
	JNE	@@6
	CMP	DX,LastWhere.Y
	JNE	@@6
	OR	BL,BL
	JE	@@2
	MOV	AX,DI
	SUB	AX,AutoTicks
	CMP	AX,AutoDelay
	JAE	@@7
@@2:	XOR	AX,AX
	MOV	BX,AX
	MOV	CX,AX
	MOV	DX,AX
	JMP	@@9
@@3:	MOV	BH,0
	CMP	BL,DownButtons
	JNE	@@4
	CMP	CX,DownWhere.X
	JNE	@@4
	CMP	DX,DownWhere.Y
	JNE	@@4
	MOV	AX,DI
	SUB	AX,DownTicks
	CMP	AX,DoubleDelay
	JAE	@@4
	MOV	BH,1
@@4:	MOV	DownButtons,BL
	MOV	DownWhere.X,CX
	MOV	DownWhere.Y,DX
	MOV	DownTicks,DI
	MOV	AutoTicks,DI
	MOV	AX,RepeatDelay
	MOV	AutoDelay,AX
	MOV	AX,evMouseDown
	JMP	@@8
@@5:	MOV	AX,evMouseUp
	JMP	@@8
@@6:	MOV	AX,evMouseMove
	JMP	@@8
@@7:	MOV	AutoTicks,DI
	MOV	AutoDelay,1
	MOV	AX,evMouseAuto
@@8:    MOV	LastButtons,BL
	MOV	LastDouble,BH
	MOV	LastWhere.X,CX
	MOV	LastWhere.Y,DX
@@9:	CALL	StoreEvent
end;

procedure GetKeyEvent(var Event        :TEvent); assembler;
asm
	MOV	AH,1
	INT	16H
	MOV	AX,0
	MOV	BX,AX
	JE	@@1
	MOV	AH,0
	INT	16H
	XCHG	AX,BX
	MOV	AX,evKeyDown
@@1:	XOR	CX,CX
	MOV	DX,CX
	CALL	StoreEvent
end;

function GetShiftState                 :Byte; assembler;
asm
	MOV	ES,Seg0040
	MOV	AL,ES:ShiftState
end;

procedure SetMousePos;
assembler;
asm
        mov  ax,4
        mov  cx,Pos.X
        mov  dx,Pos.Y
        int  33h
end;

procedure SetMouseRange;
assembler;
asm
        les  di,Range
        MOV  AX,8
        MOV  CL,MouseConvY
        MOV  BX,es:[di].TGRect.A.Y
        MOV  DX,es:[di].TGRect.B.Y
        SHL  BX,CL
        SHL  DX,CL
        MOV  CX,BX
        INT  33H
        MOV  AX,7
        MOV  CL,MouseConvX
        MOV  BX,es:[di].TGRect.A.X
        MOV  DX,es:[di].TGRect.B.X
        SHL  BX,CL
        SHL  DX,CL
        MOV  CX,BX
        INT  33H
end;

procedure SetMouseShape;
assembler;
asm
        mov  ax,9
        mov  bx,HotX
        mov  cx,HotY
        les  dx,Shape
        int  33h
end;

var
   SaveExit        :Pointer;

procedure ExitKeyMouse; far;
begin
   DoneEvents;
   ExitProc := SaveExit;
end;

begin
   DetectMouse;
   SaveExit := ExitProc;
   ExitProc := @ExitKeyMouse;
end.
