
{*******************************************************}
{                                                       }
{       Turbo Pascal Version 7.0                        }
{       Graphics Vision Unit                            }
{                                                       }
{       Copyright (c) 1994,95 by Solar Designer         }
{                                                       }
{*******************************************************}

unit GRect;
{$S-}
interface

   type
      PGPoint =    ^TGPoint;
      TGPoint =
      object
         X, Y      :Integer;

         procedure Move(ADX, ADY                 :Integer);
         function  Rect(x1, y1, x2, y2           :Integer) :Boolean;
      end;

      PGRect =     ^TGRect;
      TGRect =
      object
         A, B      :TGPoint;

         procedure Assign(XA, YA, XB, YB         :Integer);
         procedure Copy(var R                    :TGRect);
         procedure Move(ADX, ADY                 :Integer);
         procedure Grow(ADX, ADY                 :Integer);
         procedure Intersect(var R               :TGRect);
         procedure Union(var R                   :TGRect);
         function  Contains(P                    :TGPoint) :Boolean;
         function  Equals(var R                  :TGRect)  :Boolean;
         function  Empty                                   :Boolean;

         function  Intersects(var R              :TGRect)  :Boolean;

         procedure MakeEmpty;
         procedure Clear;
         procedure Arrange;

         function  SizeX                         :Integer;
         function  SizeY                         :Integer;
         procedure GetSize(var S                 :TGPoint);
         procedure SetSize(var S                 :TGPoint);

         function  CenterX                       :Integer;
         function  CenterY                       :Integer;
         procedure GetCenter(var P               :TGPoint);
      end;

implementation

procedure TGPoint.Move; assembler;
asm
        LES     DI,Self
        MOV     AX,ADX
        ADD     ES:[DI].TGPoint.X,AX
        MOV     AX,ADY
        ADD     ES:[DI].TGPoint.Y,AX
end;

function  TGPoint.Rect; assembler;
asm
   xor  ax,ax
   les  di,Self
   mov  cx,es:[di].TGPoint.X
   mov  dx,es:[di].TGPoint.Y
   cmp  cx,x1
   jl   @@1
   cmp  dx,y1
   jl   @@1
   cmp  cx,x2
   jg   @@1
   cmp  dx,y2
   jg   @@1
   inc  ax
@@1:
end;

procedure CheckEmpty; near; assembler;
asm
        MOV     AX,ES:[DI].TGRect.A.X
        CMP     AX,ES:[DI].TGRect.B.X
        jg      @@1
        MOV     AX,ES:[DI].TGRect.A.Y
        CMP     AX,ES:[DI].TGRect.B.Y
        jle     @@2
@@1:    CLD
        mov     ax,MaxInt
        STOSW
        STOSW
        STOSW
        STOSW
@@2:
end;

procedure TGRect.Assign; assembler;
asm
        LES     DI,Self
        CLD
        MOV     AX,XA
        STOSW
        MOV     AX,YA
        STOSW
        MOV     AX,XB
        STOSW
        MOV     AX,YB
        STOSW
end;

procedure TGRect.Copy; assembler;
asm
        PUSH    DS
        LDS     SI,R
        LES     DI,Self
        CLD
        MOVSW
        MOVSW
        MOVSW
        MOVSW
        POP     DS
end;

procedure TGRect.Move; assembler;
asm
        LES     DI,Self
        cmp     es:[di].TGRect.A.X,MaxInt
        je      @@1
        MOV     AX,ADX
        ADD     ES:[DI].TGRect.A.X,AX
        ADD     ES:[DI].TGRect.B.X,AX
        MOV     AX,ADY
        ADD     ES:[DI].TGRect.A.Y,AX
        ADD     ES:[DI].TGRect.B.Y,AX
@@1:
end;

procedure TGRect.Grow; assembler;
asm
        LES     DI,Self
        cmp     es:[di].TGRect.A.X,MaxInt
        je      @@1
        MOV     AX,ADX
        SUB     ES:[DI].TGRect.A.X,AX
        ADD     ES:[DI].TGRect.B.X,AX
        MOV     AX,ADY
        SUB     ES:[DI].TGRect.A.Y,AX
        ADD     ES:[DI].TGRect.B.Y,AX
        CALL    CheckEmpty
@@1:
end;

procedure TGRect.Intersect; assembler;
var
   AR              :TGRect;
asm
        PUSH    DS
        LDS     SI,R
        push    ss
        pop     es
        lea     di,AR
        mov     bx,di
        cld
        movsw
        movsw
        movsw
        movsw
        mov     si,bx
        push    es
        pop     ds
        push    ds
        push    si
        call    Arrange
        LES     DI,Self
        push    es
        push    di
        call    Arrange
        cmp     es:[di].TGRect.A.X,MaxInt
        je      @@4
        LODSW
        SCASW
        JLE     @@1
        DEC     DI
        DEC     DI
        STOSW
@@1:    LODSW
        SCASW
        JLE     @@2
        DEC     DI
        DEC     DI
        STOSW
@@2:    LODSW
        SCASW
        JGE     @@3
        DEC     DI
        DEC     DI
        STOSW
@@3:    LODSW
        SCASW
        JGE     @@4
        DEC     DI
        DEC     DI
        STOSW
@@4:    POP     DS
        SUB     DI,8
        CALL    CheckEmpty
end;

procedure TGRect.Union; assembler;
asm
        PUSH    DS
        LDS     SI,R
        LES     DI,Self
        cmp     es:[di].TGRect.A.X,MaxInt
        jne     @@5
        movsw
        movsw
        movsw
        movsw
        jmp     @@4
@@5:
        CLD
        LODSW
        cmp     ax,MaxInt
        je      @@4
        SCASW
        JGE     @@1
        DEC     DI
        DEC     DI
        STOSW
@@1:    LODSW
        SCASW
        JGE     @@2
        DEC     DI
        DEC     DI
        STOSW
@@2:    LODSW
        SCASW
        JLE     @@3
        DEC     DI
        DEC     DI
        STOSW
@@3:    LODSW
        SCASW
        JLE     @@4
        DEC     DI
        DEC     DI
        STOSW
@@4:    POP     DS
end;

function TGRect.Contains; assembler;
asm
        LES     DI,Self
        xor     ax,ax
        MOV     DX,P.X
        CMP     DX,ES:[DI].TGRect.A.X
        JL      @@1
        CMP     DX,ES:[DI].TGRect.B.X
        jg      @@1
        MOV     DX,P.Y
        CMP     DX,ES:[DI].TGRect.A.Y
        JL      @@1
        CMP     DX,ES:[DI].TGRect.B.Y
        jg      @@1
        INC     AX
@@1:
end;

function TGRect.Equals; assembler;
asm
        PUSH    DS
        LDS     SI,R
        LES     DI,Self
        MOV     CX,4
        CLD
        xor     ax,ax
        REP     CMPSW
        JNE     @@1
        INC     AX
@@1:    POP     DS
end;

function TGRect.Empty; assembler;
asm
   xor  ax,ax
   les  di,Self
   cmp  es:[di].TGRect.A.X,MaxInt
   jne  @@1
   inc  ax
@@1:
end;

function TGRect.Intersects;
var
   Intersection    :TGRect;
begin
   Intersection:=Self; Intersection.Intersect(R);
   Intersects:=Intersection.A.X<>MaxInt;
end;

procedure TGRect.Clear; assembler;
asm
   les  di,Self
   cld
   xor  ax,ax
   stosw
   stosw
   stosw
   stosw
end;

procedure TGRect.MakeEmpty; assembler;
asm
   les  di,Self
   mov  es:[di].TGRect.A.X,MaxInt
end;

procedure TGRect.Arrange; assembler;
asm
   les  di,Self
   mov  ax,es:[di].TGRect.A.X
   cmp  ax,MaxInt
   je   @@2
   cmp  ax,es:[di].TGRect.B.X
   jle  @@1
   xchg ax,es:[di].TGRect.B.X
   mov  es:[di].TGRect.A.X,ax
@@1:
   mov  ax,es:[di].TGRect.A.Y
   cmp  ax,es:[di].TGRect.B.Y
   jle  @@2
   xchg ax,es:[di].TGRect.B.Y
   mov  es:[di].TGRect.A.Y,ax
@@2:
end;

function  TGRect.SizeX; assembler;
asm
   xor  ax,ax
   les  di,Self
   mov  dx,es:[di].TGRect.A.X
   cmp  dx,MaxInt
   je   @@1
   mov  ax,es:[di].TGRect.B.X
   sub  ax,dx
   inc  ax
@@1:
end;

function  TGRect.SizeY; assembler;
asm
   xor  ax,ax
   les  di,Self
   mov  dx,es:[di].TGRect.A.X
   cmp  dx,MaxInt
   je   @@1
   mov  dx,es:[di].TGRect.A.Y
   mov  ax,es:[di].TGRect.B.Y
   sub  ax,dx
   inc  ax
@@1:
end;

procedure TGRect.GetSize; assembler;
asm
   push ds
   lds  si,S
   les  di,Self
   push es
   push di
   call SizeX
   mov  [si].TGPoint.X,ax
   push es
   push di
   call SizeY
   mov  [si].TGPoint.Y,ax
   pop  ds
end;

procedure TGRect.SetSize; assembler;
asm
   les  di,Self
   mov  ax,es:[di].TGRect.A.X
   cmp  ax,MaxInt
   je   @@1
   push ds
   lds  si,S
   add  ax,[si].TGPoint.X
   dec  ax
   mov  es:[di].TGRect.B.X,ax
   mov  ax,es:[di].TGRect.A.Y
   add  ax,[si].TGPoint.Y
   dec  ax
   mov  es:[di].TGRect.B.Y,ax
   pop  ds
@@1:
end;

function  TGRect.CenterX; assembler;
asm
   xor  ax,ax
   les  di,Self
   mov  dx,es:[di].TGRect.A.X
   cmp  dx,MaxInt
   je   @@1
   mov  ax,es:[di].TGRect.B.X
   sub  ax,dx
   inc  ax
   shr  ax,1
   add  ax,dx
@@1:
end;

function  TGRect.CenterY; assembler;
asm
   xor  ax,ax
   les  di,Self
   cmp  es:[di].TGRect.A.X,MaxInt
   je   @@1
   mov  dx,es:[di].TGRect.A.Y
   mov  ax,es:[di].TGRect.B.Y
   sub  ax,dx
   inc  ax
   shr  ax,1
   add  ax,dx
@@1:
end;

procedure TGRect.GetCenter; assembler;
asm
   push ds
   lds  si,P
   les  di,Self
   push es
   push di
   call CenterX
   mov  [si].TGPoint.X,ax
   push es
   push di
   call CenterY
   mov  [si].TGPoint.Y,ax
   pop  ds
end;

end.
