
{*******************************************************}
{                                                       }
{       Turbo Pascal Version 7.0                        }
{       Graphics Vision Unit                            }
{                                                       }
{       Copyright (c) 1994,95 by Solar Designer         }
{                                                       }
{*******************************************************}

unit GPalette;
interface

   type
      TColor =     Char;
      TPalette =   PChar;

   const
      cpBlack =              #$00; cpBlue =                #$01;
      cpGreen =              #$02; cpCyan =                #$03;
      cpRed =                #$04; cpMagenta =             #$05;
      cpBrown =              #$06; cpLightGray =           #$07;
      cpDarkGray =           #$08; cpLightBlue =           #$09;
      cpLightGreen =         #$0A; cpLightCyan =           #$0B;
      cpLightRed =           #$0C; cpLightMagenta =        #$0D;
      cpYellow =             #$0E; cpWhite =               #$0F;

      cpMain =               #$10; cpBackground=           cpMain;
      cpText =               #$11; cpForeground=           cpText;
      cpNormal =             cpText;

      cpDefault =            #$13;

      cpFrame =              #$14; cpBorder =              cpFrame;
      cpHFrame =             #$15;

      cpShadow =             #$17;

      cpDisabled =           #$18; cpHighlight =           #$19;
      cpSelected =           #$1A; cpSelDisabled =         #$1B;
      cpSelectedBk =         #$1C; cpShortcut =            #$1D;

      cpTitle =              #$20; cpTitleBk =             #$21;
      cpIcons =              #$22; cpBottomIcons =         #$23;
      cpTopIcons =           cpIcons;
      cpTopIconsBk =         #$24;
      cpBottom =             #$25;

      cpBar =                #$28; cpBarSelected =         #$29;
      cpArrows =             #$2A; cpIndicator =           #$2C;

      cpButBody =            #$30; cpButFrame =            #$31;
      cpButHigh =            #$32; cpButShadow =           #$33;

      cpButDisabled =        #$38; cpButSelected =         #$39;
      cpButDefault =         #$3A;

      cpCheckBk =            #$40; cpCheckX =              #$41;

      cpCursor =             #$60;

      cpError =              #$7F;

      ColorTable   :Array [0..15] of Byte =
      (0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15);

   function  FindColor(Color           :TColor;
                       Palette         :TPalette)          :Integer;

implementation

   function  FindColor;
   assembler;
   asm
      push ds
      lds  si,Palette
      mov  ax,ds
      or   ax,si
      jz   @@3
      mov  dl,Color
@@2:
      lodsw
      or   al,al
      je   @@3
      cmp  al,dl
      jne  @@2
      mov  al,ah
      xor  ah,ah
      cmp  al,15
      ja   @@1
      mov  bx,offset ColorTable
      xlat
      jmp  @@1
@@3:
      mov  ax,-1
@@1:
      pop  ds
   end;

end.
