
{*******************************************************}
{                                                       }
{       Turbo Pascal Version 7.0                        }
{       Graphics Vision Unit                            }
{                                                       }
{       Copyright (c) 1994,95 by Solar Designer         }
{                                                       }
{*******************************************************}

unit GMsgBox;

{$X+,I-,S-}

interface
uses
   Strings,
   GRect, Language;

const

{ Message box classes }

   mfClassMask   = $0003;
   mfWarning     = $0000;    { Display a Warning box }
   mfError       = $0001;    { Dispaly a Error box }
   mfInformation = $0002;    { Display an Information Box }
   mfConfirmation= $0003;    { Display a Confirmation Box }

   mfInsertInApp = $0080;    { Insert message box into application }
                             { instead of the Desktop }

{ Message box button flags }

   mfYesButton   = $0100;    { Put a Yes button into the dialog }
   mfNoButton    = $0200;    { Put a No button into the dialog }
   mfOKButton    = $0400;    { Put an OK button into the dialog }
   mfCancelButton= $0800;    { Put a Cancel button into the dialog }

   mfYesNoCancel = mfYesButton + mfNoButton + mfCancelButton;
                             { Standard Yes, No, Cancel dialog }
   mfOKCancel    = mfOKButton + mfCancelButton;
                             { Standard OK, Cancel dialog }

{ MessageBox displays the given string in a standard sized
  dialog box. Before the dialog is displayed the Msg and Params
  are passed to FormatStr.  The resulting string is displayed
  as a TStaticText view in the dialog. }

function MessageBox(const Msg          :String;
                    Params             :Pointer;
                    AOptions           :Word)              :Word;

{ MessageBoxRect allows the specification of a TRect for the
  message box to occupy. }

function MessageBoxRect(var R          :TGRect;
                        const Msg      :String;
                        Params         :Pointer;
                        AOptions       :Word)              :Word;

{ InputBox displays a simple dialog that allows the user to type in a string. }

function InputBox(const Title, ALabel  :String;
                  var S                :String;
                  Limit                :Byte)              :Word;

{ InputBoxRect is like InputBox but allows the specification of a rectangle. }

function InputBoxRect(var Bounds       :TGRect;
                      const Title, ALabel:String;
                      var S            :String;
                      Limit            :Byte)              :Word;

implementation
uses
   Utils, GDrivers, GViews, GDialogs, GApp;

procedure GetBoxRect(var R             :TGRect);
var
   Max             :TGRect;
begin
   R.Assign(0, 0, SystemFont.Width*28, SystemFont.Height*12);
   Desktop^.GetExtent(Max);
   R.Intersect(Max);
end;

function  MessageBox;
var
   R               :TGRect;
begin
   GetBoxRect(R);
   if AOptions and mfInsertInApp = 0 then
      R.Move((Desktop^.Size.X - R.B.X) shr 1, (Desktop^.Size.Y - R.B.Y) shr 1)
   else R.Move((Application^.Size.X - R.B.X) shr 1, (Application^.Size.Y - R.B.Y) shr 1);
   MessageBox := MessageBoxRect(R, Msg, Params, AOptions);
end;

function  MessageBoxRect;
const
   Commands        :Array [0..3] of Word =
   (cmYes, cmNo, cmOK, cmCancel);
var
   I, X, DX, ButtonCount     :Integer;
   Dialog                    :PDialog;
   Control                   :PView;
   T                         :TGRect;
   ButtonList                :Array [0..4] of PView;
   S                         :String;
begin
   New(Dialog, Init(R, StrPas(MsgTitles^[AOptions and mfClassMask])));
   with Dialog^ do
   begin
      GetInterior(R);
      R.Grow(-FrameOffset, -CharHeight); Dec(R.B.Y, CharHeight shl 1 + ButtonShift.Y);
      FormatStr(S, Msg, Params^);
      Insert(New(PStaticText, Init(R, S)));
      X := 0; ButtonCount := 0; LongInt(R.A):=0;
      for I := 0 to 3 do
      if AOptions and (mfYesButton shl I) <> 0 then
      begin
         Control := New(PButton, InitAt(R.A, StrPas(ButtonNames^[I]), Commands[i], bfNormal));
         Inc(X, Control^.Size.X);
         ButtonList[ButtonCount] := Control;
         Inc(ButtonCount);
      end;
      GetInterior(R);
      DX := (R.B.X - R.A.X - X) div (ButtonCount + 1);
      X := DX + R.A.X;
      for I := 0 to ButtonCount - 1 do
      begin
         Control := ButtonList[I];
         Insert(Control);
         Control^.MoveTo(X, R.B.Y - Control^.Size.Y - 8);
         Inc(X, DX + Control^.Size.X);
      end;
      SelectNext(False);
   end;
   if AOptions and mfInsertInApp = 0
   then MessageBoxRect := Desktop^.ExecView(Dialog)
   else MessageBoxRect := Application^.ExecView(Dialog);
   Dispose(Dialog, Done);
end;

function  InputBox;
var
   R               :TGRect;
begin
   GetBoxRect(R);
   R.Move((Desktop^.Size.X - R.B.X) shr 1, (Desktop^.Size.Y - R.B.Y) shr 1);
   InputBox := InputBoxRect(R, Title, ALabel, S, Limit);
end;

function  InputBoxRect;
var
   Dialog          :PDialog;
   Control         :PView;
   B1, B2          :PButton;
   R, I            :TGRect;
   C               :Word;
begin
   Dialog := New(PDialog, Init(Bounds, Title));
   with Dialog^ do
   begin
      GetInterior(I);

      R.Assign((2+Ord(ALabel<>'')+CStrLen(ALabel))*CharWidth, CharHeight shl 1,
         I.B.X-I.A.X-(CharWidth shl 1), CharHeight*3);
      R.Move(I.A.X, I.A.Y);
      Control := New(PInputLine, Init(R, Limit));
      Insert(Control);

      R.Assign(I.A.X+(CharWidth shl 1), R.A.Y,
         R.A.X-CharWidth, R.A.Y+CharHeight);
      Insert(New(PLabel, Init(R, ALabel, Control)));

      LongInt(R.A):=0;
      B1 := New(PButton, InitAt(R.A, 'O~K~', cmOk, bfDefault));
      B2 := New(PButton, InitAt(R.A, 'Cancel', cmCancel, bfNormal));
      R.A.X := (I.B.X - I.A.X - B1^.Size.X - B2^.Size.X) div 3;
      R.A.Y := I.B.Y - B1^.Size.Y - 8;
      B1^.MoveTo(R.A.X, R.A.Y); Insert(B1);
      B2^.MoveTo(I.B.X - R.A.X - B2^.Size.X, R.A.Y); Insert(B2);

      SelectNext(False);
   end;
   if Length(S)>Limit then S[0]:=Chr(Limit);
   Dialog^.SetData(S);
   C := DeskTop^.ExecView(Dialog);
   if C <> cmCancel then Dialog^.GetData(S);
   Dispose(Dialog, Done);
   InputBoxRect := C;
end;

end.
